/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder;

import com.simibubi.create.Create;
import com.simibubi.create.foundation.ponder.PonderScene;
import com.simibubi.create.foundation.ponder.PonderStoryBoardEntry;
import com.simibubi.create.foundation.ponder.PonderWorld;
import com.simibubi.create.foundation.ponder.SceneBuilder;
import com.simibubi.create.foundation.ponder.content.PonderChapter;
import com.simibubi.create.foundation.ponder.content.PonderChapterRegistry;
import com.simibubi.create.foundation.ponder.content.PonderTagRegistry;
import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.Template;

public class PonderRegistry {
    public static final PonderTagRegistry TAGS = new PonderTagRegistry();
    public static final PonderChapterRegistry CHAPTERS = new PonderChapterRegistry();
    public static final Map<ResourceLocation, List<PonderStoryBoardEntry>> ALL = new HashMap<ResourceLocation, List<PonderStoryBoardEntry>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addStoryBoard(PonderStoryBoardEntry entry) {
        Map<ResourceLocation, List<PonderStoryBoardEntry>> map = ALL;
        synchronized (map) {
            List list;
            List list2 = list = ALL.computeIfAbsent(entry.getComponent(), $ -> new ArrayList());
            synchronized (list2) {
                list.add(entry);
            }
        }
    }

    public static List<PonderScene> compile(ResourceLocation id) {
        List<PonderStoryBoardEntry> list = ALL.get(id);
        if (list == null) {
            return Collections.emptyList();
        }
        return PonderRegistry.compile(list);
    }

    public static List<PonderScene> compile(PonderChapter chapter) {
        List<PonderStoryBoardEntry> list = CHAPTERS.getStories(chapter);
        if (list == null) {
            return Collections.emptyList();
        }
        return PonderRegistry.compile(list);
    }

    public static List<PonderScene> compile(List<PonderStoryBoardEntry> entries) {
        ArrayList<PonderScene> scenes = new ArrayList<PonderScene>();
        for (int i = 0; i < entries.size(); ++i) {
            PonderStoryBoardEntry sb = entries.get(i);
            Template activeTemplate = PonderRegistry.loadSchematic(sb.getSchematicLocation());
            PonderWorld world = new PonderWorld(BlockPos.field_177992_a, (World)Minecraft.func_71410_x().field_71441_e);
            activeTemplate.func_237152_b_((IServerWorld)world, BlockPos.field_177992_a, new PlacementSettings(), world.field_73012_v);
            world.createBackup();
            PonderScene scene = PonderRegistry.compileScene(i, sb, world);
            scene.begin();
            scenes.add(scene);
        }
        return scenes;
    }

    public static PonderScene compileScene(int i, PonderStoryBoardEntry sb, PonderWorld world) {
        PonderScene scene = new PonderScene(world, sb.getNamespace(), sb.getComponent(), sb.getTags());
        SceneBuilder builder = scene.builder();
        sb.getBoard().program(builder, scene.getSceneBuildingUtil());
        return scene;
    }

    public static Template loadSchematic(ResourceLocation location) {
        return PonderRegistry.loadSchematic(Minecraft.func_71410_x().func_195551_G(), location);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Template loadSchematic(IResourceManager resourceManager, ResourceLocation location) {
        String namespace = location.func_110624_b();
        String path = "ponder/" + location.func_110623_a() + ".nbt";
        ResourceLocation location1 = new ResourceLocation(namespace, path);
        try (IResource resource = resourceManager.func_199002_a(location1);){
            Template template = PonderRegistry.loadSchematic(resource.func_199027_b());
            return template;
        }
        catch (FileNotFoundException e) {
            Create.LOGGER.error("Ponder schematic missing: " + location1, (Throwable)e);
            return new Template();
        }
        catch (IOException e) {
            Create.LOGGER.error("Failed to read ponder schematic: " + location1, (Throwable)e);
        }
        return new Template();
    }

    public static Template loadSchematic(InputStream resourceStream) throws IOException {
        Template t = new Template();
        DataInputStream stream = new DataInputStream(new BufferedInputStream(new GZIPInputStream(resourceStream)));
        CompoundNBT nbt = CompressedStreamTools.func_152456_a((DataInput)stream, (NBTSizeTracker)new NBTSizeTracker(0x20000000L));
        t.func_186256_b(nbt);
        return t;
    }
}

