/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.relays.encased;

import com.jozufozu.flywheel.backend.Backend;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.contraptions.base.IRotate;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.base.KineticTileEntityRenderer;
import com.simibubi.create.content.contraptions.relays.encased.SplitShaftTileEntity;
import com.simibubi.create.foundation.render.PartialBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.Iterate;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;

public class SplitShaftRenderer
extends KineticTileEntityRenderer {
    public SplitShaftRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    @Override
    protected void renderSafe(KineticTileEntity te, float partialTicks, MatrixStack ms, IRenderTypeBuffer buffer, int light, int overlay) {
        if (Backend.getInstance().canUseInstancing(te.func_145831_w())) {
            return;
        }
        Block block = te.func_195044_w().func_177230_c();
        Direction.Axis boxAxis = ((IRotate)block).getRotationAxis(te.func_195044_w());
        BlockPos pos = te.func_174877_v();
        float time = AnimationTickHolder.getRenderTime((IWorld)te.func_145831_w());
        for (Direction direction : Iterate.directions) {
            Direction.Axis axis = direction.func_176740_k();
            if (boxAxis != axis) continue;
            float offset = SplitShaftRenderer.getRotationOffsetForPosition(te, pos, axis);
            float angle = time * te.getSpeed() * 3.0f / 10.0f % 360.0f;
            float modifier = 1.0f;
            if (te instanceof SplitShaftTileEntity) {
                modifier = ((SplitShaftTileEntity)te).getRotationSpeedModifier(direction);
            }
            angle *= modifier;
            angle += offset;
            angle = angle / 180.0f * (float)Math.PI;
            SuperByteBuffer superByteBuffer = PartialBufferer.getFacing(AllBlockPartials.SHAFT_HALF, te.func_195044_w(), direction);
            SplitShaftRenderer.kineticRotationTransform(superByteBuffer, te, axis, angle, light);
            superByteBuffer.renderInto(ms, buffer.getBuffer(RenderType.func_228639_c_()));
        }
    }
}

