/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.UnaryOperator;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.ItemHandlerHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.BackpackInventoryHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.settings.memory.MemorySettingsCategory;
import net.p3pp3rf1y.sophisticatedbackpacks.util.ISlotTracker;
import net.p3pp3rf1y.sophisticatedbackpacks.util.ItemStackKey;

public class InventoryHandlerSlotTracker
implements ISlotTracker {
    private final Map<ItemStackKey, Set<Integer>> fullStackSlots = new HashMap<ItemStackKey, Set<Integer>>();
    private final Map<Integer, ItemStackKey> fullSlotStacks = new HashMap<Integer, ItemStackKey>();
    private final Map<ItemStackKey, Set<Integer>> partiallyFilledStackSlots = new HashMap<ItemStackKey, Set<Integer>>();
    private final Map<Integer, ItemStackKey> partiallyFilledSlotStacks = new HashMap<Integer, ItemStackKey>();
    private final Set<Integer> emptySlots = new TreeSet<Integer>();
    private final MemorySettingsCategory memorySettings;

    public InventoryHandlerSlotTracker(MemorySettingsCategory memorySettings) {
        this.memorySettings = memorySettings;
    }

    public void addPartiallyFilled(int slot, ItemStack stack) {
        ItemStackKey stackKey = new ItemStackKey(stack);
        this.partiallyFilledStackSlots.computeIfAbsent(stackKey, k -> new TreeSet()).add(slot);
        this.partiallyFilledSlotStacks.put(slot, stackKey);
    }

    @Override
    public Set<ItemStackKey> getFullStacks() {
        return this.fullStackSlots.keySet();
    }

    @Override
    public Set<ItemStackKey> getPartialStacks() {
        return this.partiallyFilledStackSlots.keySet();
    }

    public void addFull(int slot, ItemStack stack) {
        ItemStackKey stackKey = new ItemStackKey(stack);
        this.fullStackSlots.computeIfAbsent(stackKey, k -> new HashSet()).add(slot);
        this.fullSlotStacks.put(slot, stackKey);
    }

    public void removePartiallyFilled(int slot) {
        if (this.partiallyFilledSlotStacks.containsKey(slot)) {
            ItemStackKey stackKey = this.partiallyFilledSlotStacks.remove(slot);
            Set<Integer> partialSlots = this.partiallyFilledStackSlots.get(stackKey);
            partialSlots.remove(slot);
            if (partialSlots.isEmpty()) {
                this.partiallyFilledStackSlots.remove(stackKey);
            }
        }
    }

    private void removeFull(int slot) {
        if (this.fullSlotStacks.containsKey(slot)) {
            ItemStackKey stackKey = this.fullSlotStacks.remove(slot);
            Set<Integer> fullSlots = this.fullStackSlots.get(stackKey);
            fullSlots.remove(slot);
            if (fullSlots.isEmpty()) {
                this.fullStackSlots.remove(stackKey);
            }
        }
    }

    @Override
    public void removeAndSetSlotIndexes(BackpackInventoryHandler inventoryHandler, int slot, ItemStack stack) {
        this.removePartiallyFilled(slot);
        this.removeFull(slot);
        this.emptySlots.remove(slot);
        this.set(inventoryHandler, slot, stack);
    }

    private void set(BackpackInventoryHandler inventoryHandler, int slot, ItemStack stack) {
        if (stack.func_190926_b()) {
            this.emptySlots.add(slot);
        } else if (this.isPartiallyFilled(inventoryHandler, slot, stack)) {
            this.addPartiallyFilled(slot, stack);
        } else {
            this.addFull(slot, stack);
        }
    }

    @Override
    public void clear() {
        this.partiallyFilledStackSlots.clear();
        this.partiallyFilledSlotStacks.clear();
    }

    @Override
    public void refreshSlotIndexesFrom(BackpackInventoryHandler itemHandler) {
        this.fullStackSlots.clear();
        this.fullSlotStacks.clear();
        this.partiallyFilledSlotStacks.clear();
        this.partiallyFilledStackSlots.clear();
        this.emptySlots.clear();
        for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
            ItemStack stack = itemHandler.getStackInSlot(slot);
            this.set(itemHandler, slot, stack);
        }
    }

    private boolean isPartiallyFilled(BackpackInventoryHandler itemHandler, int slot, ItemStack stack) {
        return stack.func_190916_E() < itemHandler.getStackLimit(slot, stack);
    }

    @Override
    public ItemStack insertItemIntoHandler(BackpackInventoryHandler itemHandler, ISlotTracker.IItemHandlerInserter inserter, UnaryOperator<ItemStack> overflowHandler, ItemStack stack, boolean simulate) {
        ItemStackKey stackKey = new ItemStackKey(stack);
        ItemStack remainingStack = this.handleOverflow(overflowHandler, stackKey, stack);
        if (remainingStack.func_190926_b()) {
            return remainingStack;
        }
        if (!(remainingStack = this.insertIntoSlotsThatMatchStack(inserter, remainingStack, simulate, stackKey)).func_190926_b()) {
            remainingStack = this.insertIntoEmptySlots(inserter, remainingStack, simulate);
        }
        return remainingStack;
    }

    @Override
    public ItemStack insertItemIntoHandler(BackpackInventoryHandler itemHandler, ISlotTracker.IItemHandlerInserter inserter, UnaryOperator<ItemStack> overflowHandler, int slot, ItemStack stack, boolean simulate) {
        boolean doesNotMatchCurrentSlot;
        ItemStackKey stackKey = new ItemStackKey(stack);
        ItemStack remainingStack = stack;
        if ((remainingStack = this.handleOverflow(overflowHandler, stackKey, remainingStack)).func_190926_b()) {
            return remainingStack;
        }
        ItemStack existing = itemHandler.getStackInSlot(slot);
        boolean wasEmpty = existing.func_190926_b();
        boolean bl = doesNotMatchCurrentSlot = !ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)existing);
        if (wasEmpty || doesNotMatchCurrentSlot) {
            remainingStack = this.insertIntoSlotsThatMatchStack(inserter, remainingStack, simulate, stackKey);
        }
        if (!remainingStack.func_190926_b() && doesNotMatchCurrentSlot) {
            remainingStack = this.insertIntoEmptySlots(inserter, remainingStack, simulate);
        }
        if (!remainingStack.func_190926_b()) {
            remainingStack = inserter.insertItem(slot, remainingStack, simulate);
        }
        return remainingStack;
    }

    private ItemStack handleOverflow(UnaryOperator<ItemStack> overflowHandler, ItemStackKey stackKey, ItemStack remainingStack) {
        if (this.fullStackSlots.containsKey(stackKey) && !this.fullStackSlots.get(stackKey).isEmpty()) {
            remainingStack = (ItemStack)overflowHandler.apply(remainingStack);
        }
        return remainingStack;
    }

    private ItemStack insertIntoSlotsThatMatchStack(ISlotTracker.IItemHandlerInserter inserter, ItemStack stack, boolean simulate, ItemStackKey stackKey) {
        int matchingSlot;
        ItemStack remainingStack = stack;
        int sizeBefore = this.partiallyFilledStackSlots.containsKey(stackKey) ? this.partiallyFilledStackSlots.get(stackKey).size() : 0;
        int i = 0;
        while (this.partiallyFilledStackSlots.get(stackKey) != null && !this.partiallyFilledStackSlots.get(stackKey).isEmpty() && i++ < sizeBefore && !(remainingStack = inserter.insertItem(matchingSlot = this.partiallyFilledStackSlots.get(stackKey).iterator().next().intValue(), remainingStack, simulate)).func_190926_b()) {
        }
        return remainingStack;
    }

    private ItemStack insertIntoEmptySlots(ISlotTracker.IItemHandlerInserter inserter, ItemStack stack, boolean simulate) {
        ItemStack remainingStack = stack.func_77946_l();
        if (!(remainingStack = this.insertIntoEmptyMemorySlots(inserter, simulate, remainingStack)).func_190926_b()) {
            int sizeBefore = this.emptySlots.size();
            int i = 0;
            while (!this.emptySlots.isEmpty() && i++ < sizeBefore) {
                Iterator<Integer> it = this.emptySlots.iterator();
                int slot = it.next();
                while (this.memorySettings.isSlotSelected(slot)) {
                    if (!it.hasNext()) {
                        return remainingStack;
                    }
                    slot = it.next();
                }
                if (!(remainingStack = inserter.insertItem(slot, remainingStack, simulate)).func_190926_b()) continue;
                break;
            }
        }
        return remainingStack;
    }

    private ItemStack insertIntoEmptyMemorySlots(ISlotTracker.IItemHandlerInserter inserter, boolean simulate, ItemStack stack) {
        ItemStack remainingStack;
        block1: {
            int memorySlot;
            Item item;
            remainingStack = stack;
            Map<Item, Set<Integer>> memoryFilterItemSlots = this.memorySettings.getFilterItemSlots();
            if (!memoryFilterItemSlots.containsKey(item = remainingStack.func_77973_b())) break block1;
            Iterator<Integer> iterator = memoryFilterItemSlots.get(item).iterator();
            while (!(!iterator.hasNext() || this.emptySlots.contains(memorySlot = iterator.next().intValue()) && (remainingStack = inserter.insertItem(memorySlot, remainingStack, simulate)).func_190926_b())) {
            }
        }
        return remainingStack;
    }
}

