/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.ftb.mods.ftbchunks.FTBChunks;
import dev.ftb.mods.ftbchunks.client.ChunkScreen;
import dev.ftb.mods.ftbchunks.client.FTBChunksClient;
import dev.ftb.mods.ftbchunks.client.FTBChunksClientConfig;
import dev.ftb.mods.ftbchunks.client.RegionMapPanel;
import dev.ftb.mods.ftbchunks.client.map.MapDimension;
import dev.ftb.mods.ftbchunks.client.map.MapRegion;
import dev.ftb.mods.ftbchunks.client.map.MapRegionData;
import dev.ftb.mods.ftbchunks.client.map.Waypoint;
import dev.ftb.mods.ftbchunks.core.MouseHandlerFTBC;
import dev.ftb.mods.ftbchunks.integration.RefreshMinimapIconsEvent;
import dev.ftb.mods.ftbchunks.net.TeleportFromMapPacket;
import dev.ftb.mods.ftblibrary.config.ConfigFromString;
import dev.ftb.mods.ftblibrary.config.StringConfig;
import dev.ftb.mods.ftblibrary.config.ui.EditConfigFromStringScreen;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.math.MathUtils;
import dev.ftb.mods.ftblibrary.math.XZ;
import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftblibrary.ui.ContextMenuItem;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.ScreenWrapper;
import dev.ftb.mods.ftblibrary.ui.SimpleButton;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.input.Key;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.util.StringUtils;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.InputMappings;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.biome.Biome;

public class LargeMapScreen
extends BaseScreen {
    public Color4I backgroundColor = Color4I.rgb((int)0x202225);
    public RegionMapPanel regionPanel = new RegionMapPanel(this);
    public int zoom = 256;
    public MapDimension dimension;
    public int scrollWidth = 0;
    public int scrollHeight = 0;
    public int prevMouseX;
    public int prevMouseY;
    public int grabbed = 0;
    public boolean movedToPlayer = false;
    public Button claimChunksButton;
    public Button dimensionButton;
    public Button waypointsButton;
    public Button settingsButton;
    public Button alliesButton;
    public Button syncButton;

    public LargeMapScreen() {
        MapDimension dim = MapDimension.getCurrent();
        if (dim == null) {
            FTBChunks.LOGGER.warn("Closed large map screen to prevent map dimension manager crash");
            this.closeGui();
        }
        this.dimension = dim;
        this.regionPanel.setScrollX(0.0);
        this.regionPanel.setScrollY(0.0);
    }

    public int getRegionButtonSize() {
        return this.zoom * 2;
    }

    public void addZoom(double up) {
        int z = this.zoom;
        this.zoom = up > 0.0 ? (this.zoom *= 2) : (this.zoom /= 2);
        this.zoom = MathHelper.func_76125_a((int)this.zoom, (int)1, (int)1024);
        if (this.zoom != z) {
            this.grabbed = 0;
            double sx = this.regionPanel.regionX;
            double sy = this.regionPanel.regionZ;
            this.regionPanel.resetScroll();
            this.regionPanel.scrollTo(sx, sy);
            ((MouseHandlerFTBC)Minecraft.func_71410_x().field_71417_B).setMouseGrabbedFTBC(true);
            Minecraft.func_71410_x().field_71417_B.func_198032_j();
        }
    }

    public void addWidgets() {
        this.add((Widget)this.regionPanel);
        this.claimChunksButton = new SimpleButton((Panel)this, (ITextComponent)new TranslationTextComponent("ftbchunks.gui.claimed_chunks"), Icons.MAP, (b, m) -> new ChunkScreen().openGui());
        this.add((Widget)this.claimChunksButton);
        this.waypointsButton = new SimpleButton((Panel)this, (ITextComponent)new TranslationTextComponent("ftbchunks.gui.add_waypoint"), Icons.ADD, (b, m) -> {
            StringConfig name = new StringConfig();
            new EditConfigFromStringScreen((ConfigFromString)name, set -> {
                if (set) {
                    ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
                    Waypoint w = new Waypoint(this.dimension);
                    w.name = (String)name.value;
                    w.color = Color4I.hsb((float)MathUtils.RAND.nextFloat(), (float)1.0f, (float)1.0f).rgba();
                    w.x = MathHelper.func_76128_c((double)player.func_226277_ct_());
                    w.y = MathHelper.func_76128_c((double)player.func_226278_cu_());
                    w.z = MathHelper.func_76128_c((double)player.func_226281_cx_());
                    this.dimension.getWaypoints().add(w);
                    w.update();
                    this.dimension.saveData = true;
                    RefreshMinimapIconsEvent.trigger();
                    this.refreshWidgets();
                }
                this.openGui();
            }).openGui();
        });
        this.add((Widget)this.waypointsButton);
        this.dimensionButton = new SimpleButton((Panel)this, (ITextComponent)new StringTextComponent(this.dimension.dimension.func_240901_a_().func_110623_a().replace('_', ' ')), Icons.GLOBE, (b, m) -> {
            try {
                ArrayList<MapDimension> list = new ArrayList<MapDimension>(this.dimension.manager.getDimensions().values());
                int i = list.indexOf(this.dimension);
                if (i != -1) {
                    this.dimension = (MapDimension)list.get(MathUtils.mod((int)(i + (m.isLeft() ? 1 : -1)), (int)list.size()));
                    this.refreshWidgets();
                    this.movedToPlayer = false;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.add((Widget)this.dimensionButton);
        this.settingsButton = new SimpleButton((Panel)this, (ITextComponent)new TranslationTextComponent("ftbchunks.gui.settings"), Icons.SETTINGS, (b, m) -> FTBChunksClientConfig.openSettings((Screen)new ScreenWrapper((BaseScreen)this)));
        this.add((Widget)this.settingsButton);
    }

    public void alignWidgets() {
        this.claimChunksButton.setPosAndSize(1, 1, 16, 16);
        this.waypointsButton.setPosAndSize(1, 19, 16, 16);
        this.dimensionButton.setPosAndSize(1, this.height - 36, 16, 16);
        this.settingsButton.setPosAndSize(1, this.height - 18, 16, 16);
    }

    public boolean onInit() {
        return this.setFullscreen();
    }

    public boolean mousePressed(MouseButton button) {
        if (super.mousePressed(button)) {
            return true;
        }
        if (button.isLeft()) {
            this.prevMouseX = this.getMouseX();
            this.prevMouseY = this.getMouseY();
            return true;
        }
        if (button.isRight()) {
            int clickBlockX = this.regionPanel.blockX;
            int clickBlockZ = this.regionPanel.blockZ;
            ArrayList<ContextMenuItem> list = new ArrayList<ContextMenuItem>();
            list.add(new ContextMenuItem((ITextComponent)new TranslationTextComponent("ftbchunks.gui.add_waypoint"), Icons.ADD, () -> {
                StringConfig name = new StringConfig();
                new EditConfigFromStringScreen((ConfigFromString)name, set -> {
                    if (set) {
                        Waypoint w = new Waypoint(this.dimension);
                        w.name = (String)name.value;
                        w.color = Color4I.hsb((float)MathUtils.RAND.nextFloat(), (float)1.0f, (float)1.0f).rgba();
                        w.x = clickBlockX;
                        w.y = this.regionPanel.blockY;
                        w.z = clickBlockZ;
                        this.dimension.getWaypoints().add(w);
                        w.update();
                        this.dimension.saveData = true;
                        RefreshMinimapIconsEvent.trigger();
                        this.refreshWidgets();
                    }
                    this.openGui();
                }).openGui();
            }));
            this.openContextMenu(list);
            return true;
        }
        return false;
    }

    public boolean keyPressed(Key key) {
        if (FTBChunksClient.openMapKey.func_197976_a(key.keyCode, key.scanCode)) {
            this.closeGui(true);
            return true;
        }
        if (key.is(32)) {
            this.movedToPlayer = false;
            return true;
        }
        if (super.keyPressed(key)) {
            return true;
        }
        if (key.is(84)) {
            new TeleportFromMapPacket(this.regionPanel.blockX, this.regionPanel.blockY + 1, this.regionPanel.blockZ, this.regionPanel.blockY == -32767, this.dimension.dimension).sendToServer();
            this.closeGui(false);
            return true;
        }
        if (key.is(71) && InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)292)) {
            FTBChunksClientConfig.CHUNK_GRID.toggle();
            FTBChunksClientConfig.saveConfig();
            this.dimension.manager.updateAllRegions(false);
            return true;
        }
        return false;
    }

    public boolean drawDefaultBackground(MatrixStack matrixStack) {
        if (!this.movedToPlayer) {
            ClientPlayerEntity p = Minecraft.func_71410_x().field_71439_g;
            this.regionPanel.resetScroll();
            this.regionPanel.scrollTo(p.func_226277_ct_() / 512.0, p.func_226281_cx_() / 512.0);
            this.movedToPlayer = true;
        }
        this.backgroundColor.draw(matrixStack, 0, 0, this.width, this.height);
        return false;
    }

    public void drawBackground(MatrixStack matrixStack, Theme theme, int x, int y, int w, int h) {
        if (this.grabbed != 0) {
            int mx = this.getMouseX();
            int my = this.getMouseY();
            if (this.scrollWidth > this.regionPanel.width) {
                this.regionPanel.setScrollX(Math.max(Math.min(this.regionPanel.getScrollX() + (double)(this.prevMouseX - mx), (double)(this.scrollWidth - this.regionPanel.width)), 0.0));
            }
            if (this.scrollHeight > this.regionPanel.height) {
                this.regionPanel.setScrollY(Math.max(Math.min(this.regionPanel.getScrollY() + (double)(this.prevMouseY - my), (double)(this.scrollHeight - this.regionPanel.height)), 0.0));
            }
            this.prevMouseX = mx;
            this.prevMouseY = my;
        }
        if (this.scrollWidth <= this.regionPanel.width) {
            this.regionPanel.setScrollX((double)(this.scrollWidth - this.regionPanel.width) / 2.0);
        }
        if (this.scrollHeight <= this.regionPanel.height) {
            this.regionPanel.setScrollY((double)(this.scrollHeight - this.regionPanel.height) / 2.0);
        }
        RenderSystem.disableTexture();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        int r = 70;
        int g = 70;
        int b = 70;
        int a = 100;
        buffer.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        int s = this.getRegionButtonSize();
        double ox = -this.regionPanel.getScrollX() % (double)s;
        double oy = -this.regionPanel.getScrollY() % (double)s;
        for (int gx = 0; gx <= w / s + 1; ++gx) {
            buffer.func_225582_a_((double)x + ox + (double)(gx * s), (double)y, 0.0).func_225586_a_(r, g, b, a).func_181675_d();
            buffer.func_225582_a_((double)x + ox + (double)(gx * s), (double)(y + h), 0.0).func_225586_a_(r, g, b, a).func_181675_d();
        }
        for (int gy = 0; gy <= h / s + 1; ++gy) {
            buffer.func_225582_a_((double)x, (double)y + oy + (double)(gy * s), 0.0).func_225586_a_(r, g, b, a).func_181675_d();
            buffer.func_225582_a_((double)(x + w), (double)y + oy + (double)(gy * s), 0.0).func_225586_a_(r, g, b, a).func_181675_d();
        }
        tessellator.func_78381_a();
        RenderSystem.enableTexture();
    }

    public void drawForeground(MatrixStack matrixStack, Theme theme, int x, int y, int w, int h) {
        MapRegion region;
        MapRegionData data;
        String coords = "X: " + this.regionPanel.blockX + ", Y: " + (this.regionPanel.blockY == -32767 ? "??" : Integer.valueOf(this.regionPanel.blockY)) + ", Z: " + this.regionPanel.blockZ;
        if (this.regionPanel.blockY != -32767 && (data = (region = this.dimension.getRegion(XZ.regionFromBlock((int)this.regionPanel.blockX, (int)this.regionPanel.blockZ))).getData()) != null) {
            int waterLightAndBiome = data.waterLightAndBiome[this.regionPanel.blockIndex] & 0xFFFF;
            RegistryKey<Biome> biome = this.dimension.manager.getBiomeKey(waterLightAndBiome);
            Block block = this.dimension.manager.getBlock(data.getBlockIndex(this.regionPanel.blockIndex));
            coords = coords + " | " + I18n.func_135052_a((String)("biome." + biome.func_240901_a_().func_110624_b() + "." + biome.func_240901_a_().func_110623_a()), (Object[])new Object[0]) + " | " + I18n.func_135052_a((String)block.func_149739_a(), (Object[])new Object[0]);
            if ((waterLightAndBiome & 0x8000) != 0) {
                coords = coords + " (in water)";
            }
        }
        int coordsw = theme.getStringWidth(coords) / 2;
        this.backgroundColor.withAlpha(150).draw(matrixStack, x + (w - coordsw) / 2, y + h - 6, coordsw + 4, 6);
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_((double)((float)x + (float)(w - coordsw) / 2.0f + 2.0f), (double)(y + h - 5), 0.0);
        matrixStack.func_227862_a_(0.5f, 0.5f, 1.0f);
        theme.drawString(matrixStack, (Object)coords, 0, 0, 2);
        matrixStack.func_227865_b_();
        if (((Boolean)FTBChunksClientConfig.DEBUG_INFO.get()).booleanValue()) {
            long memory = 0L;
            for (MapDimension dim : this.dimension.manager.getDimensions().values()) {
                for (MapRegion region2 : dim.getLoadedRegions()) {
                    if (!region2.isDataLoaded()) continue;
                    memory += 0x100000L;
                    memory += 0x300000L;
                }
            }
            String memoryUsage = "Estimated Memory Usage: " + StringUtils.formatDouble00((double)((double)memory / 1024.0 / 1024.0)) + " MB";
            int memoryUsagew = theme.getStringWidth(memoryUsage) / 2;
            this.backgroundColor.withAlpha(150).draw(matrixStack, x + (w - memoryUsagew) - 2, y, memoryUsagew + 4, 6);
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_((double)((float)(x + (w - memoryUsagew)) - 1.0f), (double)(y + 1), 0.0);
            matrixStack.func_227862_a_(0.5f, 0.5f, 1.0f);
            theme.drawString(matrixStack, (Object)memoryUsage, 0, 0, 2);
            matrixStack.func_227865_b_();
        }
    }
}

