/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.task;

import com.mojang.brigadier.StringReader;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.NameMap;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.BooleanTask;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import dev.ftb.mods.ftbquests.quest.task.TaskTypes;
import me.shedaniel.architectury.registry.Registries;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.command.arguments.BlockStateInput;
import net.minecraft.command.arguments.BlockStateParser;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.CachedBlockInfo;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ObservationTask
extends BooleanTask {
    public long timer = 0L;
    public ObserveType observeType = ObserveType.BLOCK;
    public String toObserve = "minecraft:dirt";

    public ObservationTask(Quest quest) {
        super(quest);
    }

    @Override
    public TaskType getType() {
        return TaskTypes.OBSERVATION;
    }

    @Override
    public void writeData(CompoundNBT nbt) {
        super.writeData(nbt);
        nbt.func_74772_a("timer", this.timer);
        nbt.func_74768_a("observe_type", this.observeType.ordinal());
        nbt.func_74778_a("to_observe", this.toObserve);
    }

    @Override
    public void readData(CompoundNBT nbt) {
        super.readData(nbt);
        this.timer = nbt.func_74763_f("timer");
        this.observeType = ObserveType.values()[nbt.func_74762_e("observe_type")];
        this.toObserve = nbt.func_74779_i("to_observe");
    }

    @Override
    public void writeNetData(PacketBuffer buffer) {
        super.writeNetData(buffer);
        buffer.func_179254_b(this.timer);
        buffer.func_179249_a((Enum)this.observeType);
        buffer.func_180714_a(this.toObserve);
    }

    @Override
    public void readNetData(PacketBuffer buffer) {
        super.readNetData(buffer);
        this.timer = buffer.func_179260_f();
        this.observeType = (ObserveType)buffer.func_179257_a(ObserveType.class);
        this.toObserve = buffer.func_150789_c(Short.MAX_VALUE);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addLong("timer", this.timer, v -> {
            this.timer = v;
        }, 0L, 0L, 1200L);
        config.addEnum("observe_type", (Object)this.observeType, v -> {
            this.observeType = v;
        }, ObserveType.NAME_MAP);
        config.addString("to_observe", this.toObserve, v -> {
            this.toObserve = v;
        }, "minecraft:dirt");
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onButtonClicked(Button button, boolean canClick) {
    }

    @Override
    public boolean canSubmit(TeamData teamData, ServerPlayerEntity player) {
        return true;
    }

    @Override
    public boolean checkOnLogin() {
        return false;
    }

    public boolean observe(PlayerEntity player, RayTraceResult result) {
        if (this.toObserve.isEmpty()) {
            return false;
        }
        if (result instanceof BlockRayTraceResult) {
            BlockRayTraceResult blockResult = (BlockRayTraceResult)result;
            CachedBlockInfo blockInWorld = new CachedBlockInfo((IWorldReader)player.field_70170_p, blockResult.func_216350_a(), false);
            BlockState state = blockInWorld.func_177509_a();
            Block block = state.func_177230_c();
            TileEntity blockEntity = blockInWorld.func_177507_b();
            switch (this.observeType) {
                case BLOCK: {
                    return String.valueOf(Registries.getId((Object)block, (RegistryKey)Registry.field_239711_l_)).equals(this.toObserve);
                }
                case BLOCK_TAG: {
                    return state.func_235714_a_(BlockTags.func_199896_a().func_241834_b(new ResourceLocation(this.toObserve)));
                }
                case BLOCK_STATE: {
                    BlockStateInput stateMatch = this.tryMatchBlock(this.toObserve, false);
                    return stateMatch != null && stateMatch.test(blockInWorld);
                }
                case BLOCK_ENTITY: {
                    BlockStateInput stateNbtMatch = this.tryMatchBlock(this.toObserve, true);
                    return stateNbtMatch != null && stateNbtMatch.test(blockInWorld);
                }
                case BLOCK_ENTITY_TYPE: {
                    return blockEntity != null && this.toObserve.equals(String.valueOf(Registries.getId((Object)blockEntity.func_200662_C(), (RegistryKey)Registry.field_239667_E_)));
                }
            }
            return false;
        }
        if (result instanceof EntityRayTraceResult) {
            EntityRayTraceResult entityResult = (EntityRayTraceResult)result;
            if (this.observeType == ObserveType.ENTITY_TYPE) {
                return this.toObserve.equals(String.valueOf(Registries.getId((Object)entityResult.func_216348_a().func_200600_R(), (RegistryKey)Registry.field_239713_n_)));
            }
            if (this.observeType == ObserveType.ENTITY_TYPE_TAG) {
                return entityResult.func_216348_a().func_200600_R().func_220341_a(EntityTypeTags.func_219762_a().func_241834_b(new ResourceLocation(this.toObserve)));
            }
        }
        return false;
    }

    private BlockStateInput tryMatchBlock(String string, boolean parseNbt) {
        try {
            BlockStateParser blockStateParser = new BlockStateParser(new StringReader(string), false).func_197243_a(parseNbt);
            return new BlockStateInput(blockStateParser.func_197249_b(), blockStateParser.func_197254_a().keySet(), blockStateParser.func_197241_c());
        }
        catch (Exception ex) {
            return null;
        }
    }

    static enum ObserveType {
        BLOCK,
        BLOCK_TAG,
        BLOCK_STATE,
        BLOCK_ENTITY,
        BLOCK_ENTITY_TYPE,
        ENTITY_TYPE,
        ENTITY_TYPE_TAG;

        public static final NameMap<ObserveType> NAME_MAP;

        static {
            NAME_MAP = NameMap.of((Object)((Object)BLOCK), (Object[])ObserveType.values()).id(v -> v.name().toLowerCase()).create();
        }
    }
}

