/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest;

import dev.ftb.mods.ftblibrary.config.ConfigCallback;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ConfigValue;
import dev.ftb.mods.ftblibrary.config.ListConfig;
import dev.ftb.mods.ftblibrary.config.StringConfig;
import dev.ftb.mods.ftblibrary.config.Tristate;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.IconAnimation;
import dev.ftb.mods.ftblibrary.math.Bits;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.util.ClientTextComponentUtils;
import dev.ftb.mods.ftblibrary.util.ClientUtils;
import dev.ftb.mods.ftbquests.FTBQuests;
import dev.ftb.mods.ftbquests.events.ObjectCompletedEvent;
import dev.ftb.mods.ftbquests.events.ObjectStartedEvent;
import dev.ftb.mods.ftbquests.events.QuestProgressEventData;
import dev.ftb.mods.ftbquests.gui.MultilineTextEditorScreen;
import dev.ftb.mods.ftbquests.gui.quests.QuestScreen;
import dev.ftb.mods.ftbquests.integration.jei.FTBQuestsJEIHelper;
import dev.ftb.mods.ftbquests.net.DisplayCompletionToastMessage;
import dev.ftb.mods.ftbquests.net.MoveQuestMessage;
import dev.ftb.mods.ftbquests.quest.Chapter;
import dev.ftb.mods.ftbquests.quest.ChapterGroup;
import dev.ftb.mods.ftbquests.quest.DependencyDepthException;
import dev.ftb.mods.ftbquests.quest.DependencyLoopException;
import dev.ftb.mods.ftbquests.quest.DependencyRequirement;
import dev.ftb.mods.ftbquests.quest.Movable;
import dev.ftb.mods.ftbquests.quest.QuestFile;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.QuestObjectBase;
import dev.ftb.mods.ftbquests.quest.QuestObjectType;
import dev.ftb.mods.ftbquests.quest.QuestShape;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import dev.ftb.mods.ftbquests.quest.reward.RewardClaimType;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.util.ConfigQuestObject;
import dev.ftb.mods.ftbquests.util.NetUtils;
import dev.ftb.mods.ftbquests.util.ProgressChange;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Predicate;
import me.shedaniel.architectury.event.EventActor;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public final class Quest
extends QuestObject
implements Movable {
    public Chapter chapter;
    public String subtitle;
    public double x;
    public double y;
    public Tristate hide;
    public String shape;
    public final List<String> description;
    public final List<QuestObject> dependencies;
    public final List<Task> tasks;
    public final List<Reward> rewards;
    public DependencyRequirement dependencyRequirement;
    public String guidePage;
    public Tristate hideDependencyLines;
    public int minRequiredDependencies;
    public Tristate hideTextUntilComplete;
    public Tristate disableJEI;
    public double size;
    public boolean optional;
    public int minWidth;
    private ITextComponent cachedSubtitle = null;
    private ITextComponent[] cachedDescription = null;

    public Quest(Chapter c) {
        this.chapter = c;
        this.subtitle = "";
        this.x = 0.0;
        this.y = 0.0;
        this.shape = "";
        this.description = new ArrayList<String>(0);
        this.dependencies = new ArrayList<QuestObject>(0);
        this.tasks = new ArrayList<Task>(1);
        this.rewards = new ArrayList<Reward>(1);
        this.guidePage = "";
        this.hideDependencyLines = Tristate.DEFAULT;
        this.hide = Tristate.DEFAULT;
        this.dependencyRequirement = DependencyRequirement.ALL_COMPLETED;
        this.minRequiredDependencies = 0;
        this.hideTextUntilComplete = Tristate.DEFAULT;
        this.disableJEI = Tristate.DEFAULT;
        this.size = 1.0;
        this.optional = false;
        this.minWidth = 0;
    }

    @Override
    public QuestObjectType getObjectType() {
        return QuestObjectType.QUEST;
    }

    @Override
    public QuestFile getQuestFile() {
        return this.chapter.file;
    }

    @Override
    public Chapter getQuestChapter() {
        return this.chapter;
    }

    @Override
    public long getParentID() {
        return this.chapter.id;
    }

    @Override
    public void writeData(CompoundNBT nbt) {
        super.writeData(nbt);
        nbt.func_74780_a("x", this.x);
        nbt.func_74780_a("y", this.y);
        if (!this.shape.isEmpty()) {
            nbt.func_74778_a("shape", this.shape);
        }
        if (!this.subtitle.isEmpty()) {
            nbt.func_74778_a("subtitle", this.subtitle);
        }
        if (!this.description.isEmpty()) {
            ListNBT array = new ListNBT();
            for (String value : this.description) {
                array.add((Object)StringNBT.func_229705_a_((String)value));
            }
            nbt.func_218657_a("description", (INBT)array);
        }
        if (!this.guidePage.isEmpty()) {
            nbt.func_74778_a("guide_page", this.guidePage);
        }
        if (this.hideDependencyLines != Tristate.DEFAULT) {
            nbt.func_74757_a("hide_dependency_lines", this.hideDependencyLines.isTrue());
        }
        if (this.minRequiredDependencies > 0) {
            nbt.func_74768_a("min_required_dependencies", (int)((byte)this.minRequiredDependencies));
        }
        this.removeInvalidDependencies();
        if (!this.dependencies.isEmpty()) {
            ListNBT deps = new ListNBT();
            for (QuestObject dep : this.dependencies) {
                deps.add((Object)StringNBT.func_229705_a_((String)dep.getCodeString()));
            }
            nbt.func_218657_a("dependencies", (INBT)deps);
        }
        if (this.hide != Tristate.DEFAULT) {
            nbt.func_74757_a("hide", this.hide.isTrue());
        }
        if (this.dependencyRequirement != DependencyRequirement.ALL_COMPLETED) {
            nbt.func_74778_a("dependency_requirement", this.dependencyRequirement.id);
        }
        if (this.hideTextUntilComplete != Tristate.DEFAULT) {
            nbt.func_74757_a("hide_text_until_complete", this.hideTextUntilComplete.isTrue());
        }
        if (this.size != 1.0) {
            nbt.func_74780_a("size", this.size);
        }
        if (this.optional) {
            nbt.func_74757_a("optional", true);
        }
        if (this.minWidth > 0) {
            nbt.func_74768_a("min_width", this.minWidth);
        }
    }

    @Override
    public void readData(CompoundNBT nbt) {
        super.readData(nbt);
        this.subtitle = nbt.func_74779_i("subtitle");
        this.x = nbt.func_74769_h("x");
        this.y = nbt.func_74769_h("y");
        this.shape = nbt.func_74779_i("shape");
        if (this.shape.equals("default")) {
            this.shape = "";
        }
        this.description.clear();
        ListNBT list = nbt.func_150295_c("description", 8);
        for (int k = 0; k < list.size(); ++k) {
            this.description.add(list.func_150307_f(k));
        }
        this.guidePage = nbt.func_74779_i("guide_page");
        this.hideDependencyLines = Tristate.read((CompoundNBT)nbt, (String)"hide_dependency_lines");
        this.minRequiredDependencies = nbt.func_74762_e("min_required_dependencies");
        this.dependencies.clear();
        if (nbt.func_150297_b("dependencies", 11)) {
            for (int i : nbt.func_74759_k("dependencies")) {
                QuestObject object = this.chapter.file.get(i);
                if (object == null) continue;
                this.dependencies.add(object);
            }
        } else {
            ListNBT deps = nbt.func_150295_c("dependencies", 8);
            for (int i = 0; i < deps.size(); ++i) {
                QuestObject object = this.chapter.file.get(this.chapter.file.getID(deps.func_150307_f(i)));
                if (object == null) continue;
                this.dependencies.add(object);
            }
        }
        this.hide = Tristate.read((CompoundNBT)nbt, (String)"hide");
        this.dependencyRequirement = (DependencyRequirement)((Object)DependencyRequirement.NAME_MAP.get(nbt.func_74779_i("dependency_requirement")));
        this.hideTextUntilComplete = Tristate.read((CompoundNBT)nbt, (String)"hide_text_until_complete");
        this.size = nbt.func_74764_b("size") ? nbt.func_74769_h("size") : 1.0;
        this.optional = nbt.func_74767_n("optional");
        this.minWidth = nbt.func_74762_e("min_width");
    }

    @Override
    public void writeNetData(PacketBuffer buffer) {
        super.writeNetData(buffer);
        int flags = 0;
        flags = Bits.setFlag((int)flags, (int)1, (!this.subtitle.isEmpty() ? 1 : 0) != 0);
        flags = Bits.setFlag((int)flags, (int)2, (!this.description.isEmpty() ? 1 : 0) != 0);
        flags = Bits.setFlag((int)flags, (int)4, (this.size != 1.0 ? 1 : 0) != 0);
        flags = Bits.setFlag((int)flags, (int)8, (!this.guidePage.isEmpty() ? 1 : 0) != 0);
        flags = Bits.setFlag((int)flags, (int)256, (boolean)this.optional);
        flags = Bits.setFlag((int)flags, (int)512, (this.minWidth > 0 ? 1 : 0) != 0);
        buffer.func_150787_b(flags);
        this.hide.write(buffer);
        this.hideDependencyLines.write(buffer);
        this.hideTextUntilComplete.write(buffer);
        if (!this.subtitle.isEmpty()) {
            buffer.func_211400_a(this.subtitle, Short.MAX_VALUE);
        }
        buffer.writeDouble(this.x);
        buffer.writeDouble(this.y);
        buffer.func_211400_a(this.shape, Short.MAX_VALUE);
        if (!this.description.isEmpty()) {
            NetUtils.writeStrings(buffer, this.description);
        }
        if (!this.guidePage.isEmpty()) {
            buffer.func_211400_a(this.guidePage, Short.MAX_VALUE);
        }
        buffer.func_150787_b(this.minRequiredDependencies);
        DependencyRequirement.NAME_MAP.write(buffer, (Object)this.dependencyRequirement);
        buffer.func_150787_b(this.dependencies.size());
        for (QuestObject d : this.dependencies) {
            if (d.invalid) {
                buffer.writeLong(0L);
                continue;
            }
            buffer.writeLong(d.id);
        }
        if (this.size != 1.0) {
            buffer.writeDouble(this.size);
        }
        if (this.minWidth > 0) {
            buffer.func_150787_b(this.minWidth);
        }
    }

    @Override
    public void readNetData(PacketBuffer buffer) {
        super.readNetData(buffer);
        int flags = buffer.func_150792_a();
        this.hide = Tristate.read((PacketBuffer)buffer);
        this.hideDependencyLines = Tristate.read((PacketBuffer)buffer);
        this.hideTextUntilComplete = Tristate.read((PacketBuffer)buffer);
        this.subtitle = Bits.getFlag((int)flags, (int)1) ? buffer.func_150789_c(Short.MAX_VALUE) : "";
        this.x = buffer.readDouble();
        this.y = buffer.readDouble();
        this.shape = buffer.func_150789_c(Short.MAX_VALUE);
        if (Bits.getFlag((int)flags, (int)2)) {
            NetUtils.readStrings(buffer, this.description);
        } else {
            this.description.clear();
        }
        this.guidePage = Bits.getFlag((int)flags, (int)8) ? buffer.func_150789_c(Short.MAX_VALUE) : "";
        this.optional = Bits.getFlag((int)flags, (int)256);
        this.minRequiredDependencies = buffer.func_150792_a();
        this.dependencyRequirement = (DependencyRequirement)((Object)DependencyRequirement.NAME_MAP.read(buffer));
        this.dependencies.clear();
        int d = buffer.func_150792_a();
        for (int i = 0; i < d; ++i) {
            QuestObject object = this.chapter.file.get(buffer.readLong());
            if (object == null) continue;
            this.dependencies.add(object);
        }
        this.size = Bits.getFlag((int)flags, (int)4) ? buffer.readDouble() : 1.0;
        this.minWidth = Bits.getFlag((int)flags, (int)512) ? buffer.func_150792_a() : 0;
    }

    @Override
    public int getRelativeProgressFromChildren(TeamData data) {
        if (this.tasks.isEmpty()) {
            return data.areDependenciesComplete(this) ? 100 : 0;
        }
        int progress = 0;
        for (Task task : this.tasks) {
            progress += data.getRelativeProgress(task);
        }
        if (progress > 0 && !data.areDependenciesComplete(this)) {
            return 0;
        }
        return Quest.getRelativeProgressFromChildren(progress, this.tasks.size());
    }

    @Override
    public void onStarted(QuestProgressEventData<?> data) {
        data.teamData.setStarted(this.id, data.time);
        ((EventActor)ObjectStartedEvent.QUEST.invoker()).act((Object)new ObjectStartedEvent.QuestEvent(data.withObject(this)));
        if (!data.teamData.isStarted(this.chapter)) {
            this.chapter.onStarted(data.withObject(this.chapter));
        }
    }

    @Override
    public void onCompleted(QuestProgressEventData<?> data) {
        data.teamData.setCompleted(this.id, data.time);
        ((EventActor)ObjectCompletedEvent.QUEST.invoker()).act((Object)new ObjectCompletedEvent.QuestEvent(data.withObject(this)));
        if (!this.disableToast) {
            for (ServerPlayerEntity player : data.notifiedPlayers) {
                new DisplayCompletionToastMessage(this.id).sendTo(player);
            }
        }
        if (this.chapter.isCompletedRaw(data.teamData)) {
            this.chapter.onCompleted(data.withObject(this.chapter));
        }
        data.teamData.checkAutoCompletion(this);
        for (ChapterGroup group : this.chapter.file.chapterGroups) {
            for (Chapter chapter : group.chapters) {
                for (Quest quest : chapter.quests) {
                    if (!quest.dependencies.contains(this)) continue;
                    data.teamData.checkAutoCompletion(quest);
                }
            }
        }
    }

    @Override
    public void forceProgress(TeamData teamData, ProgressChange progressChange) {
        super.forceProgress(teamData, progressChange);
        for (Reward r : this.rewards) {
            r.forceProgress(teamData, progressChange);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ITextComponent getAltTitle() {
        if (!this.tasks.isEmpty()) {
            return this.tasks.get(0).getTitle();
        }
        return new TranslationTextComponent("ftbquests.unnamed");
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Icon getAltIcon() {
        ArrayList<Icon> list = new ArrayList<Icon>();
        for (Task task : this.tasks) {
            list.add(task.getIcon());
        }
        return IconAnimation.fromList(list, (boolean)false);
    }

    @Override
    public void deleteSelf() {
        super.deleteSelf();
        this.chapter.quests.remove(this);
    }

    @Override
    public void deleteChildren() {
        for (Task task : this.tasks) {
            task.deleteChildren();
            task.invalid = true;
        }
        for (Reward reward : this.rewards) {
            reward.deleteChildren();
            reward.invalid = true;
        }
        this.tasks.clear();
        this.rewards.clear();
    }

    @Override
    public void onCreated() {
        this.chapter.quests.add(this);
        if (!this.tasks.isEmpty()) {
            ArrayList<Task> l = new ArrayList<Task>(this.tasks);
            this.tasks.clear();
            for (Task task : l) {
                task.onCreated();
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addString("subtitle", this.subtitle, v -> {
            this.subtitle = v;
        }, "");
        StringConfig descType = new StringConfig();
        descType.defaultValue = "";
        config.add("description", (ConfigValue)new ListConfig<String, StringConfig>(descType){

            public void onClicked(MouseButton button, ConfigCallback callback) {
                new MultilineTextEditorScreen(this, callback).openGui();
            }
        }, this.description, t -> {
            this.description.clear();
            this.description.addAll((Collection<String>)t);
        }, Collections.emptyList());
        config.addEnum("shape", (Object)(this.shape.isEmpty() ? "default" : this.shape), v -> {
            this.shape = v.equals("default") ? "" : v;
        }, QuestShape.idMapWithDefault);
        config.addTristate("hide", this.hide, v -> {
            this.hide = v;
        });
        config.addDouble("size", this.size, v -> {
            this.size = v;
        }, 1.0, 0.0625, 8.0);
        config.addDouble("x", this.x, v -> {
            this.x = v;
        }, 0.0, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        config.addDouble("y", this.y, v -> {
            this.y = v;
        }, 0.0, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        Predicate<QuestObjectBase> depTypes = object -> object != this.chapter.file && object != this.chapter && object instanceof QuestObject;
        this.dependencies.removeIf(Objects::isNull);
        config.addList("dependencies", this.dependencies, new ConfigQuestObject(depTypes), null).setNameKey("ftbquests.dependencies");
        config.addEnum("dependency_requirement", (Object)this.dependencyRequirement, v -> {
            this.dependencyRequirement = v;
        }, DependencyRequirement.NAME_MAP);
        config.addInt("min_required_dependencies", this.minRequiredDependencies, v -> {
            this.minRequiredDependencies = v;
        }, 0, 0, Integer.MAX_VALUE);
        config.addTristate("hide_dependency_lines", this.hideDependencyLines, v -> {
            this.hideDependencyLines = v;
        });
        config.addString("guide_page", this.guidePage, v -> {
            this.guidePage = v;
        }, "");
        config.addTristate("hide_text_until_complete", this.hideTextUntilComplete, v -> {
            this.hideTextUntilComplete = v;
        });
        config.addEnum("disable_jei", (Object)this.disableJEI, v -> {
            this.disableJEI = v;
        }, Tristate.NAME_MAP);
        config.addBool("optional", this.optional, v -> {
            this.optional = v;
        }, false);
        config.addInt("min_width", this.minWidth, v -> {
            this.minWidth = v;
        }, 0, 0, 3000);
    }

    public boolean getHideDependencyLines() {
        return this.hideDependencyLines.get(this.chapter.defaultHideDependencyLines);
    }

    @Override
    public Chapter getChapter() {
        return this.chapter;
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    public double getWidth() {
        return this.size;
    }

    @Override
    public double getHeight() {
        return this.size;
    }

    @Override
    public String getShape() {
        return this.shape.isEmpty() ? this.chapter.getDefaultQuestShape() : this.shape;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void move(Chapter to, double x, double y) {
        new MoveQuestMessage(this.id, to.id, x, y).sendToServer();
    }

    @Override
    public boolean isVisible(TeamData data) {
        if (this.dependencies.isEmpty()) {
            return true;
        }
        if (this.hide.get(false)) {
            return data.areDependenciesComplete(this);
        }
        for (QuestObject object : this.dependencies) {
            if (!object.isVisible(data)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clearCachedData() {
        super.clearCachedData();
        this.cachedSubtitle = null;
        this.cachedDescription = null;
        for (Task task : this.tasks) {
            task.clearCachedData();
        }
        for (Reward reward : this.rewards) {
            reward.clearCachedData();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public ITextComponent getSubtitle() {
        if (this.cachedSubtitle != null) {
            return this.cachedSubtitle;
        }
        this.cachedSubtitle = ClientTextComponentUtils.parse((String)this.subtitle);
        return this.cachedSubtitle;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ITextComponent[] getDescription() {
        if (this.cachedDescription != null) {
            return this.cachedDescription;
        }
        this.cachedDescription = new ITextComponent[this.description.size()];
        for (int i = 0; i < this.cachedDescription.length; ++i) {
            this.cachedDescription[i] = ClientTextComponentUtils.parse((String)this.description.get(i));
        }
        return this.cachedDescription;
    }

    public boolean hasDependency(QuestObject object) {
        if (object.invalid) {
            return false;
        }
        for (QuestObject dependency : this.dependencies) {
            if (dependency != object) continue;
            return true;
        }
        return false;
    }

    public void removeInvalidDependencies() {
        if (!this.dependencies.isEmpty()) {
            this.dependencies.removeIf(o -> o == null || o.invalid || o == this);
        }
    }

    public boolean verifyDependencies(boolean autofix) {
        try {
            this.verifyDependenciesInternal(this.id, 0);
            return true;
        }
        catch (DependencyDepthException ex) {
            if (autofix) {
                FTBQuests.LOGGER.error("Too deep dependencies found in " + this + " (referenced in " + ex.object + ")! Deleting all dependencies...");
                this.dependencies.clear();
                this.chapter.file.save();
            } else {
                FTBQuests.LOGGER.error("Too deep dependencies found in " + this + " (referenced in " + ex.object + ")!");
            }
            return false;
        }
        catch (DependencyLoopException ex) {
            if (autofix) {
                FTBQuests.LOGGER.error("Looping dependencies found in " + this + " (referenced in " + ex.object + ")! Deleting all dependencies...");
                this.dependencies.clear();
                this.chapter.file.save();
            } else {
                FTBQuests.LOGGER.error("Looping dependencies found in " + this + " (referenced in " + ex.object + ")!");
            }
            return false;
        }
    }

    @Override
    protected void verifyDependenciesInternal(long original, int depth) {
        if (depth >= 1000) {
            throw new DependencyDepthException(this);
        }
        for (QuestObject dependency : this.dependencies) {
            if (dependency.id == original) {
                throw new DependencyLoopException(this);
            }
            dependency.verifyDependenciesInternal(original, depth + 1);
        }
    }

    @Override
    public int refreshJEI() {
        return FTBQuestsJEIHelper.QUESTS;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void editedFromGUI() {
        QuestScreen gui = (QuestScreen)((Object)ClientUtils.getCurrentGuiAs(QuestScreen.class));
        if (gui != null) {
            gui.questPanel.refreshWidgets();
            gui.viewQuestPanel.refreshWidgets();
        }
    }

    public void moved(double nx, double ny, long nc) {
        QuestFile f;
        Chapter c;
        this.x = nx;
        this.y = ny;
        if (nc != this.chapter.id && (c = (f = this.getQuestFile()).getChapter(nc)) != null) {
            this.chapter.quests.remove(this);
            c.quests.add(this);
            this.chapter = c;
        }
    }

    public List<QuestObject> getDependants() {
        ArrayList<QuestObject> list = new ArrayList<QuestObject>();
        for (ChapterGroup group : this.chapter.file.chapterGroups) {
            for (Chapter c : group.chapters) {
                for (Quest q : c.quests) {
                    if (!q.dependencies.contains(this)) continue;
                    list.add(q);
                }
            }
        }
        return list;
    }

    @Override
    public Collection<? extends QuestObject> getChildren() {
        return this.tasks;
    }

    @Override
    public boolean isCompletedRaw(TeamData data) {
        return data.canStartTasks(this) && super.isCompletedRaw(data);
    }

    @Override
    public boolean hasUnclaimedRewardsRaw(TeamData teamData, UUID player) {
        if (teamData.isCompleted(this)) {
            for (Reward reward : this.rewards) {
                if (teamData.getClaimType(player, reward) != RewardClaimType.CAN_CLAIM) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean countsTowardParentCompletion() {
        return !this.optional;
    }
}

