/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.net;

import dev.ftb.mods.ftbquests.net.CreateObjectResponseMessage;
import dev.ftb.mods.ftbquests.net.FTBQuestsNetHandler;
import dev.ftb.mods.ftbquests.quest.Chapter;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import dev.ftb.mods.ftbquests.util.NetUtils;
import me.shedaniel.architectury.networking.NetworkManager;
import me.shedaniel.architectury.networking.simple.BaseC2SMessage;
import me.shedaniel.architectury.networking.simple.MessageType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;

public class CreateTaskAtMessage
extends BaseC2SMessage {
    private final long chapter;
    private final double x;
    private final double y;
    private final TaskType type;
    private final CompoundNBT nbt;

    CreateTaskAtMessage(PacketBuffer buffer) {
        this.chapter = buffer.readLong();
        this.x = buffer.readDouble();
        this.y = buffer.readDouble();
        this.type = (TaskType)((Object)ServerQuestFile.INSTANCE.taskTypeIds.get(buffer.func_150792_a()));
        this.nbt = buffer.func_150793_b();
    }

    public CreateTaskAtMessage(Chapter c, double _x, double _y, Task task) {
        this.chapter = c.id;
        this.x = _x;
        this.y = _y;
        this.type = task.getType();
        this.nbt = new CompoundNBT();
        task.writeData(this.nbt);
    }

    public MessageType getType() {
        return FTBQuestsNetHandler.CREATE_TASK_AT;
    }

    public void write(PacketBuffer buffer) {
        buffer.writeLong(this.chapter);
        buffer.writeDouble(this.x);
        buffer.writeDouble(this.y);
        buffer.func_150787_b(this.type.intId);
        buffer.func_150786_a(this.nbt);
    }

    public void handle(NetworkManager.PacketContext context) {
        Chapter c;
        if (NetUtils.canEdit(context) && (c = ServerQuestFile.INSTANCE.getChapter(this.chapter)) != null) {
            Quest quest = new Quest(c);
            quest.x = this.x;
            quest.y = this.y;
            quest.id = ServerQuestFile.INSTANCE.newID();
            quest.onCreated();
            new CreateObjectResponseMessage(quest, null).sendToAll(context.getPlayer().func_184102_h());
            Task task = this.type.provider.create(quest);
            task.id = ServerQuestFile.INSTANCE.newID();
            task.readData(this.nbt);
            task.onCreated();
            CompoundNBT extra = new CompoundNBT();
            extra.func_74778_a("type", this.type.getTypeForNBT());
            new CreateObjectResponseMessage(task, extra).sendToAll(context.getPlayer().func_184102_h());
            ServerQuestFile.INSTANCE.refreshIDMap();
            ServerQuestFile.INSTANCE.clearCachedData();
            ServerQuestFile.INSTANCE.save();
        }
    }
}

