/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.item;

import dev.ftb.mods.ftbquests.FTBQuests;
import dev.ftb.mods.ftbquests.client.ClientQuestFile;
import dev.ftb.mods.ftbquests.gui.RewardNotificationsScreen;
import dev.ftb.mods.ftbquests.quest.loot.LootCrate;
import dev.ftb.mods.ftbquests.quest.loot.WeightedReward;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class LootCrateItem
extends Item {
    public LootCrateItem() {
        super(new Item.Properties().func_200916_a(FTBQuests.ITEM_GROUP));
    }

    @Nullable
    public static LootCrate getCrate(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77973_b() instanceof LootCrateItem) {
            return LootCrate.LOOT_CRATES.get(stack.func_77978_p().func_74779_i("type"));
        }
        return null;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        int size;
        ItemStack stack = player.func_184586_b(hand);
        LootCrate crate = LootCrateItem.getCrate(stack);
        if (crate == null) {
            return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
        }
        int n = size = player.func_213453_ef() ? stack.func_190916_E() : 1;
        if (!world.field_72995_K) {
            for (WeightedReward reward : crate.table.rewards) {
                if (reward.weight != 0) continue;
                reward.reward.claim((ServerPlayerEntity)player, true);
            }
            int totalWeight = crate.table.getTotalWeight(true);
            if (totalWeight > 0) {
                block1: for (int j = 0; j < size * crate.table.lootSize; ++j) {
                    int currentWeight = crate.table.emptyWeight;
                    int number = player.field_70170_p.field_73012_v.nextInt(totalWeight) + 1;
                    if (currentWeight >= number) continue;
                    for (WeightedReward reward : crate.table.rewards) {
                        if ((currentWeight += reward.weight) < number) continue;
                        reward.reward.claim((ServerPlayerEntity)player, true);
                        continue block1;
                    }
                }
            }
            world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187635_cQ, SoundCategory.PLAYERS, 0.8f, 0.8f + world.field_73012_v.nextFloat() * 0.4f);
        } else {
            new RewardNotificationsScreen().openGui();
            for (int i = 0; i < 5; ++i) {
                Vector3d vec3d = new Vector3d(((double)world.field_73012_v.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
                vec3d = vec3d.func_178789_a(-player.field_70125_A * ((float)Math.PI / 180));
                vec3d = vec3d.func_178785_b(-player.field_70177_z * ((float)Math.PI / 180));
                double d0 = (double)(-world.field_73012_v.nextFloat()) * 0.6 - 0.3;
                Vector3d vec3d1 = new Vector3d(((double)world.field_73012_v.nextFloat() - 0.5) * 0.3, d0, 0.6);
                vec3d1 = vec3d1.func_178789_a(-player.field_70125_A * ((float)Math.PI / 180));
                vec3d1 = vec3d1.func_178785_b(-player.field_70177_z * ((float)Math.PI / 180));
                vec3d1 = vec3d1.func_72441_c(player.func_226277_ct_(), player.func_226278_cu_() + (double)player.func_70047_e(), player.func_226281_cx_());
                world.func_195594_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, stack), vec3d1.field_72450_a, vec3d1.field_72448_b, vec3d1.field_72449_c, vec3d.field_72450_a, vec3d.field_72448_b + 0.05, vec3d.field_72449_c);
            }
        }
        stack.func_190918_g(size);
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    public boolean func_77636_d(ItemStack stack) {
        LootCrate crate = LootCrateItem.getCrate(stack);
        return crate != null && crate.glow;
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        LootCrate crate = LootCrateItem.getCrate(stack);
        return crate != null && !crate.itemName.isEmpty() ? new StringTextComponent(crate.itemName) : super.func_200295_i(stack);
    }

    public Rarity func_77613_e(ItemStack stack) {
        return Rarity.UNCOMMON;
    }

    public void func_150895_a(ItemGroup tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            for (LootCrate lootCrate : LootCrate.LOOT_CRATES.values()) {
                items.add((Object)lootCrate.createStack());
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        tooltip.add((ITextComponent)new TranslationTextComponent("item.ftbquests.lootcrate.tooltip_1").func_240699_a_(TextFormatting.GRAY));
        tooltip.add((ITextComponent)new TranslationTextComponent("item.ftbquests.lootcrate.tooltip_2").func_240699_a_(TextFormatting.GRAY));
        if (world == null || !ClientQuestFile.exists()) {
            return;
        }
        LootCrate crate = LootCrateItem.getCrate(stack);
        if (crate != null) {
            if (crate.itemName.isEmpty()) {
                tooltip.add(StringTextComponent.field_240750_d_);
                tooltip.add((ITextComponent)crate.table.getMutableTitle().func_240699_a_(TextFormatting.GRAY));
            }
        } else if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("type")) {
            tooltip.add(StringTextComponent.field_240750_d_);
            tooltip.add((ITextComponent)new StringTextComponent(stack.func_77978_p().func_74779_i("type")).func_240699_a_(TextFormatting.GRAY));
        }
    }
}

