/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.gui.quests;

import com.mojang.blaze3d.matrix.MatrixStack;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.SimpleTextButton;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.WidgetLayout;
import dev.ftb.mods.ftblibrary.ui.WidgetType;
import dev.ftb.mods.ftblibrary.ui.input.Key;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.ui.misc.CompactGridLayout;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import dev.ftb.mods.ftblibrary.util.WrappedIngredient;
import dev.ftb.mods.ftbquests.gui.FTBQuestsTheme;
import dev.ftb.mods.ftbquests.integration.jei.FTBQuestsJEIHelper;
import dev.ftb.mods.ftbquests.net.SubmitTaskMessage;
import dev.ftb.mods.ftbquests.quest.task.ItemTask;
import java.util.List;
import me.shedaniel.architectury.platform.Platform;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.jetbrains.annotations.Nullable;

public class ValidItemsScreen
extends BaseScreen {
    public final ItemTask task;
    public final List<ItemStack> validItems;
    public String title = "";
    public final boolean canClick;
    public final Panel itemPanel;
    public final Button backButton;
    public final Button submitButton;

    public ValidItemsScreen(ItemTask t, List<ItemStack> v, boolean c) {
        this.task = t;
        this.validItems = v;
        this.canClick = c;
        this.itemPanel = new Panel((Panel)this){

            public void addWidgets() {
                for (ItemStack validItem : ValidItemsScreen.this.validItems) {
                    this.add((Widget)new ValidItemButton(this, validItem));
                }
            }

            public void alignWidgets() {
                this.align((WidgetLayout)new CompactGridLayout(36));
                this.setHeight(Math.min(160, this.getContentHeight()));
                this.parent.setHeight(this.height + 53);
                int off = (this.width - this.getContentWidth()) / 2;
                for (Widget widget : this.widgets) {
                    widget.setX(widget.posX + off);
                }
                ValidItemsScreen.this.itemPanel.setX((this.parent.width - this.width) / 2);
                ValidItemsScreen.this.backButton.setPosAndSize(ValidItemsScreen.this.itemPanel.posX - 1, this.height + 28, 70, 20);
                ValidItemsScreen.this.submitButton.setPosAndSize(ValidItemsScreen.this.itemPanel.posX + 75, this.height + 28, 70, 20);
            }

            public void drawBackground(MatrixStack matrixStack, Theme theme, int x, int y, int w, int h) {
                theme.drawButton(matrixStack, x - 1, y - 1, w + 2, h + 2, WidgetType.NORMAL);
            }
        };
        this.itemPanel.setPosAndSize(0, 22, 144, 0);
        this.backButton = new SimpleTextButton((Panel)this, (ITextComponent)new TranslationTextComponent("gui.back"), (Icon)Icon.EMPTY){

            public void onClicked(MouseButton button) {
                this.playClickSound();
                ValidItemsScreen.this.onBack();
            }

            public boolean renderTitleInCenter() {
                return true;
            }
        };
        this.submitButton = new SimpleTextButton((Panel)this, (ITextComponent)new StringTextComponent("Submit"), (Icon)Icon.EMPTY){

            public void onClicked(MouseButton button) {
                this.playClickSound();
                new SubmitTaskMessage(ValidItemsScreen.this.task.id).sendToServer();
                ValidItemsScreen.this.onBack();
            }

            public void addMouseOverText(TooltipList list) {
                if (ValidItemsScreen.this.canClick && !ValidItemsScreen.this.task.consumesResources()) {
                    list.translate("ftbquests.task.auto_detected", new Object[0]);
                }
            }

            public WidgetType getWidgetType() {
                return ValidItemsScreen.this.canClick && ValidItemsScreen.this.task.consumesResources() ? super.getWidgetType() : WidgetType.DISABLED;
            }

            public boolean renderTitleInCenter() {
                return true;
            }
        };
    }

    public void addWidgets() {
        this.title = new TranslationTextComponent("ftbquests.task.ftbquests.item.valid_for", new Object[]{this.task.getTitle()}).getString();
        this.setWidth(Math.max(156, this.getTheme().getStringWidth(this.title) + 12));
        this.add((Widget)this.itemPanel);
        this.add((Widget)this.backButton);
        this.add((Widget)this.submitButton);
    }

    public Theme getTheme() {
        return FTBQuestsTheme.INSTANCE;
    }

    public void drawBackground(MatrixStack matrixStack, Theme theme, int x, int y, int w, int h) {
        super.drawBackground(matrixStack, theme, x, y, w, h);
        theme.drawString(matrixStack, (Object)this.title, (float)x + (float)w / 2.0f, (float)(y + 6), Color4I.WHITE, 4);
    }

    public boolean onClosedByKey(Key key) {
        if (super.onClosedByKey(key)) {
            this.onBack();
        }
        return false;
    }

    public static class ValidItemButton
    extends Button {
        public final ItemStack stack;

        public ValidItemButton(Panel panel, ItemStack is) {
            super(panel, StringTextComponent.field_240750_d_, ItemIcon.getItemIcon((ItemStack)is));
            this.stack = is;
        }

        public void onClicked(MouseButton button) {
            if (Platform.isModLoaded((String)"jei")) {
                this.showJEIRecipe();
            }
        }

        private void showJEIRecipe() {
            FTBQuestsJEIHelper.showRecipes(this.stack);
        }

        @Nullable
        public Object getIngredientUnderMouse() {
            return new WrappedIngredient((Object)this.stack).tooltip();
        }

        public void draw(MatrixStack matrixStack, Theme theme, int x, int y, int w, int h) {
            if (this.isMouseOver()) {
                Color4I.WHITE.withAlpha(33).draw(matrixStack, x, y, w, h);
            }
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(0.0, 0.0, 10.0);
            GuiHelper.drawItem((MatrixStack)matrixStack, (ItemStack)this.stack, (double)(x + 2), (double)(y + 2), (float)2.0f, (float)2.0f, (boolean)true, null);
            matrixStack.func_227865_b_();
        }
    }
}

