/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.gui.quests;

import com.mojang.blaze3d.matrix.MatrixStack;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftblibrary.ui.ContextMenuItem;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftbquests.net.CreateObjectMessage;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestObjectBase;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import dev.ftb.mods.ftbquests.quest.task.TaskTypes;
import dev.ftb.mods.ftbquests.quest.theme.property.ThemeProperties;
import java.util.ArrayList;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class AddTaskButton
extends Button {
    public final Quest quest;

    public AddTaskButton(Panel panel, Quest q) {
        super(panel, (ITextComponent)new TranslationTextComponent("gui.add"), (Icon)ThemeProperties.ADD_ICON.get());
        this.quest = q;
        this.setSize(18, 18);
    }

    public void onClicked(MouseButton button) {
        this.playClickSound();
        ArrayList<ContextMenuItem> contextMenu = new ArrayList<ContextMenuItem>();
        for (TaskType type : TaskTypes.TYPES.values()) {
            contextMenu.add(new ContextMenuItem(type.getDisplayName(), type.getIcon(), () -> {
                this.playClickSound();
                type.getGuiProvider().openCreationGui((Runnable)((Object)this), this.quest, task -> {
                    CompoundNBT extra = new CompoundNBT();
                    extra.func_74778_a("type", type.getTypeForNBT());
                    new CreateObjectMessage((QuestObjectBase)task, extra).sendToServer();
                });
            }));
        }
        this.getGui().openContextMenu(contextMenu);
    }

    public void drawBackground(MatrixStack matrixStack, Theme theme, int x, int y, int w, int h) {
        if (this.isMouseOver()) {
            super.drawBackground(matrixStack, theme, x, y, w, h);
        }
    }
}

