/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.SimpleTextButton;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.WidgetLayout;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.util.TimeUtils;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import dev.ftb.mods.ftbquests.client.ClientQuestFile;
import dev.ftb.mods.ftbquests.gui.FTBQuestsTheme;
import dev.ftb.mods.ftbquests.net.GetEmergencyItemsMessage;
import dev.ftb.mods.ftbquests.quest.QuestShape;
import java.util.ArrayList;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.jetbrains.annotations.Nullable;

public class EmergencyItemsScreen
extends BaseScreen {
    private final long endTime;
    private boolean done;
    private final SimpleTextButton cancelButton;
    private final Panel itemPanel;

    public EmergencyItemsScreen() {
        this.endTime = System.currentTimeMillis() + (long)ClientQuestFile.INSTANCE.emergencyItemsCooldown * 1000L;
        this.done = false;
        this.cancelButton = new SimpleTextButton((Panel)this, (ITextComponent)new TranslationTextComponent("gui.cancel"), (Icon)Icon.EMPTY){

            public void onClicked(MouseButton button) {
                this.playClickSound();
                this.getGui().closeGui();
            }
        };
        this.itemPanel = new Panel((Panel)this){

            public void addWidgets() {
                for (ItemStack stack : ClientQuestFile.INSTANCE.emergencyItems) {
                    this.add(new EmergencyItem(this, stack));
                }
            }

            public void alignWidgets() {
                this.setWidth(this.align((WidgetLayout)new WidgetLayout.Horizontal(3, 7, 3)));
                this.setHeight(22);
                this.setPos((EmergencyItemsScreen.this.width - ((EmergencyItemsScreen)EmergencyItemsScreen.this).itemPanel.width) / 2, EmergencyItemsScreen.this.height * 2 / 3 - 10);
            }
        };
    }

    public void addWidgets() {
        this.add((Widget)this.itemPanel);
        this.add((Widget)this.cancelButton);
        this.cancelButton.setPos((this.width - this.cancelButton.width) / 2, this.height * 2 / 3 + 16);
    }

    public boolean onInit() {
        return this.setFullscreen();
    }

    public void drawBackground(MatrixStack matrixStack, Theme theme, int x, int y, int w, int h) {
        long left = this.endTime - System.currentTimeMillis();
        if (left <= 0L) {
            if (!this.done) {
                this.done = true;
                this.cancelButton.setTitle((ITextComponent)new TranslationTextComponent("gui.close"));
                new GetEmergencyItemsMessage().sendToServer();
            }
            left = 0L;
        }
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_((double)((int)((double)w / 2.0)), (double)((int)((double)h / 5.0)), 0.0);
        matrixStack.func_227862_a_(2.0f, 2.0f, 1.0f);
        String s = I18n.func_135052_a((String)"ftbquests.file.emergency_items", (Object[])new Object[0]);
        theme.drawString(matrixStack, (Object)s, (float)(-theme.getStringWidth(s)) / 2.0f, 0.0f, Color4I.WHITE, 0);
        matrixStack.func_227865_b_();
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_((double)((int)((double)w / 2.0)), (double)((int)((double)h / 2.5)), 0.0);
        matrixStack.func_227862_a_(4.0f, 4.0f, 1.0f);
        s = left <= 0L ? "00:00" : TimeUtils.getTimeString((long)(left / 1000L * 1000L + 1000L));
        int x1 = -theme.getStringWidth(s) / 2;
        theme.drawString(matrixStack, (Object)s, (float)(x1 - 1), 0.0f, Color4I.BLACK, 0);
        theme.drawString(matrixStack, (Object)s, (float)(x1 + 1), 0.0f, Color4I.BLACK, 0);
        theme.drawString(matrixStack, (Object)s, (float)x1, 1.0f, Color4I.BLACK, 0);
        theme.drawString(matrixStack, (Object)s, (float)x1, -1.0f, Color4I.BLACK, 0);
        theme.drawString(matrixStack, (Object)s, (float)x1, 0.0f, Color4I.WHITE, 0);
        matrixStack.func_227865_b_();
    }

    public Theme getTheme() {
        return FTBQuestsTheme.INSTANCE;
    }

    private static class EmergencyItem
    extends Widget {
        private final ItemStack stack;

        public EmergencyItem(Panel p, ItemStack is) {
            super(p);
            this.setY(3);
            this.stack = is;
            this.setSize(16, 16);
        }

        public void addMouseOverText(TooltipList list) {
            ArrayList list1 = new ArrayList();
            GuiHelper.addStackTooltip((ItemStack)this.stack, list1);
            for (ITextComponent t : list1) {
                list.add(t);
            }
        }

        public void draw(MatrixStack matrixStack, Theme theme, int x, int y, int w, int h) {
            GuiHelper.setupDrawing();
            QuestShape.get((String)"rsquare").outline.draw(matrixStack, x - 3, y - 3, w + 6, h + 6);
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(0.0, 0.0, 100.0);
            GuiHelper.drawItem((MatrixStack)matrixStack, (ItemStack)this.stack, (double)x, (double)y, (float)1.0f, (float)1.0f, (boolean)true, null);
            matrixStack.func_227865_b_();
        }

        @Nullable
        public Object getIngredientUnderMouse() {
            return this.stack;
        }
    }
}

