/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests;

import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftbquests.FTBQuests;
import dev.ftb.mods.ftbquests.integration.StageHelper;
import dev.ftb.mods.ftbquests.integration.gamestages.GameStagesIntegration;
import dev.ftb.mods.ftbquests.item.FTBQuestsItems;
import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import dev.ftb.mods.ftbquests.quest.loot.LootCrate;
import dev.ftb.mods.ftbquests.quest.task.TaskTypes;
import dev.ftb.mods.ftbquests.quest.task.forge.ForgeEnergyTask;
import dev.ftb.mods.ftbquests.quest.task.forge.ForgeFluidTask;
import java.util.Iterator;
import java.util.Optional;
import me.shedaniel.architectury.hooks.FluidStackHooks;
import me.shedaniel.architectury.platform.Platform;
import me.shedaniel.architectury.platform.forge.EventBuses;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.util.LazyValue;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.GameRules;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="ftbquests")
public class FTBQuestsForge {
    public FTBQuestsForge() {
        EventBuses.registerModEventBus((String)"ftbquests", (IEventBus)FMLJavaModLoadingContext.get().getModEventBus());
        FTBQuests quests = new FTBQuests();
        ForgeFluidTask.TYPE = TaskTypes.register(new ResourceLocation("ftbquests", "fluid"), ForgeFluidTask::new, () -> Icon.getIcon((String)Optional.ofNullable(FluidStackHooks.getStillTexture((Fluid)Fluids.field_204546_a)).map(TextureAtlasSprite::func_195668_m).map(ResourceLocation::toString).orElse("missingno")).combineWith(Icon.getIcon((String)ForgeFluidTask.TANK_TEXTURE.toString())));
        ForgeEnergyTask.TYPE = TaskTypes.register(new ResourceLocation("ftbquests", "forge_energy"), ForgeEnergyTask::new, () -> Icon.getIcon((String)ForgeEnergyTask.EMPTY_TEXTURE.toString()).combineWith(Icon.getIcon((String)ForgeEnergyTask.FULL_TEXTURE.toString())));
        if (Platform.isModLoaded((String)"gamestages") && !Platform.isModLoaded((String)"kubejs")) {
            StageHelper.instance = new LazyValue(GameStagesIntegration::new);
        }
        FMLJavaModLoadingContext.get().getModEventBus().addListener(event -> quests.setup());
        MinecraftForge.EVENT_BUS.addListener(FTBQuestsForge::livingDrops);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGH, FTBQuestsForge::dropsEvent);
    }

    private static void livingDrops(LivingDropsEvent event) {
        LivingEntity e = event.getEntityLiving();
        if (e.field_70170_p.field_72995_K || e instanceof PlayerEntity) {
            return;
        }
        if (ServerQuestFile.INSTANCE == null || !ServerQuestFile.INSTANCE.dropLootCrates) {
            return;
        }
        LootCrate crate = ServerQuestFile.INSTANCE.getRandomLootCrate((Entity)e, e.field_70170_p.field_73012_v);
        if (crate != null) {
            ItemEntity ei = new ItemEntity(e.field_70170_p, e.func_226277_ct_(), e.func_226278_cu_(), e.func_226281_cx_(), crate.createStack());
            ei.func_174867_a(10);
            event.getDrops().add(ei);
        }
    }

    private static void dropsEvent(LivingDropsEvent event) {
        if (!(event.getEntity() instanceof ServerPlayerEntity)) {
            return;
        }
        ServerPlayerEntity player = (ServerPlayerEntity)event.getEntity();
        if (player instanceof FakePlayer || player.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223600_c)) {
            return;
        }
        Iterator iterator = event.getDrops().iterator();
        while (iterator.hasNext()) {
            ItemEntity drop = (ItemEntity)iterator.next();
            ItemStack stack = drop.func_92059_d();
            if (stack.func_77973_b() != FTBQuestsItems.BOOK.get() || !player.func_191521_c(stack)) continue;
            iterator.remove();
        }
    }
}

