/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.entity.EntityHydra;
import com.github.alexthe666.iceandfire.entity.EntityHydraHead;
import com.github.alexthe666.iceandfire.entity.IafEntityRegistry;
import com.github.alexthe666.iceandfire.entity.util.IDragonProjectile;
import com.github.alexthe666.iceandfire.enums.EnumParticles;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.AbstractFireballEntity;
import net.minecraft.entity.projectile.DamagingProjectileEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.network.IPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;

public class EntityHydraBreath
extends AbstractFireballEntity
implements IDragonProjectile {
    public EntityHydraBreath(EntityType<? extends AbstractFireballEntity> t, World worldIn) {
        super(t, worldIn);
    }

    public EntityHydraBreath(EntityType<? extends AbstractFireballEntity> t, World worldIn, double posX, double posY, double posZ, double accelX, double accelY, double accelZ) {
        super(t, posX, posY, posZ, accelX, accelY, accelZ, worldIn);
    }

    public EntityHydraBreath(FMLPlayMessages.SpawnEntity spawnEntity, World worldIn) {
        this((EntityType<? extends AbstractFireballEntity>)((EntityType)IafEntityRegistry.HYDRA_BREATH.get()), worldIn);
    }

    public EntityHydraBreath(EntityType<? extends AbstractFireballEntity> t, World worldIn, EntityHydra shooter, double accelX, double accelY, double accelZ) {
        super(t, (LivingEntity)shooter, accelX, accelY, accelZ, worldIn);
        double d0 = MathHelper.func_76133_a((double)(accelX * accelX + accelY * accelY + accelZ * accelZ));
        this.field_70232_b = accelX / d0 * 0.02;
        this.field_70233_c = accelY / d0 * 0.02;
        this.field_70230_d = accelZ / d0 * 0.02;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected boolean func_184564_k() {
        return false;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        return false;
    }

    public float func_70111_Y() {
        return 0.0f;
    }

    public boolean func_70067_L() {
        return false;
    }

    public void func_70071_h_() {
        this.func_70066_B();
        if (this.field_70173_aa > 30) {
            this.func_70106_y();
        }
        Entity shootingEntity = this.func_234616_v_();
        if (this.field_70170_p.field_72995_K || (shootingEntity == null || shootingEntity.func_70089_S()) && this.field_70170_p.func_175667_e(this.func_233580_cy_())) {
            int i;
            RayTraceResult raytraceresult;
            this.func_70030_z();
            if (this.func_184564_k()) {
                this.func_70015_d(1);
            }
            if ((raytraceresult = ProjectileHelper.func_234618_a_((Entity)this, arg_0 -> ((EntityHydraBreath)this).func_230298_a_(arg_0))).func_216346_c() != RayTraceResult.Type.MISS && !ForgeEventFactory.onProjectileImpact((DamagingProjectileEntity)this, (RayTraceResult)raytraceresult)) {
                this.func_70227_a(raytraceresult);
            }
            Vector3d Vector3d2 = this.func_213322_ci();
            double d0 = this.func_226277_ct_() + Vector3d2.field_72450_a;
            double d1 = this.func_226278_cu_() + Vector3d2.field_72448_b;
            double d2 = this.func_226281_cx_() + Vector3d2.field_72449_c;
            ProjectileHelper.func_188803_a((Entity)this, (float)0.2f);
            float f = this.func_82341_c();
            if (this.field_70170_p.field_72995_K) {
                for (i = 0; i < 15; ++i) {
                    IceAndFire.PROXY.spawnParticle(EnumParticles.Hydra, this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf()) - (double)this.func_213311_cf() * 0.5, this.func_226278_cu_() - 0.5, this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf()) - (double)this.func_213311_cf() * 0.5, 0.1, 1.0, 0.1);
                }
            }
            this.func_213317_d(Vector3d2.func_72441_c(this.field_70232_b, this.field_70233_c, this.field_70230_d).func_186678_a((double)f));
            this.field_70232_b *= (double)0.95f;
            this.field_70233_c *= (double)0.95f;
            this.field_70230_d *= (double)0.95f;
            this.func_70024_g(this.field_70232_b, this.field_70233_c, this.field_70230_d);
            if (this.func_70090_H()) {
                for (i = 0; i < 4; ++i) {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197612_e, this.func_226277_ct_() - this.func_213322_ci().field_72450_a * 0.25, this.func_226278_cu_() - this.func_213322_ci().field_72448_b * 0.25, this.func_226281_cx_() - this.func_213322_ci().field_72449_c * 0.25, this.func_213322_ci().field_72450_a, this.func_213322_ci().field_72448_b, this.func_213322_ci().field_72449_c);
                }
            }
            this.func_70107_b(d0, d1, d2);
            this.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        }
    }

    public boolean handleWaterMovement() {
        return true;
    }

    protected void func_70227_a(RayTraceResult movingObject) {
        this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223599_b);
        Entity shootingEntity = this.func_234616_v_();
        if (!this.field_70170_p.field_72995_K && movingObject.func_216346_c() == RayTraceResult.Type.ENTITY) {
            Entity entity = ((EntityRayTraceResult)movingObject).func_216348_a();
            if (entity != null && entity instanceof EntityHydraHead) {
                return;
            }
            if (shootingEntity != null && shootingEntity instanceof EntityHydra) {
                EntityHydra dragon = (EntityHydra)shootingEntity;
                if (dragon.func_184191_r(entity) || dragon.func_70028_i(entity)) {
                    return;
                }
                entity.func_70097_a(DamageSource.func_76358_a((LivingEntity)dragon), 2.0f);
                if (entity instanceof LivingEntity) {
                    ((LivingEntity)entity).func_195064_c(new EffectInstance(Effects.field_76436_u, 60, 0));
                }
            }
        }
    }
}

