/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.gui.quests;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.icon.ImageIcon;
import dev.ftb.mods.ftblibrary.math.MathUtils;
import dev.ftb.mods.ftblibrary.ui.ContextMenuItem;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.input.Key;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.util.StringUtils;
import dev.ftb.mods.ftbquests.gui.quests.ChapterImageButton;
import dev.ftb.mods.ftbquests.gui.quests.QuestButton;
import dev.ftb.mods.ftbquests.gui.quests.QuestScreen;
import dev.ftb.mods.ftbquests.net.CreateTaskAtMessage;
import dev.ftb.mods.ftbquests.net.EditObjectMessage;
import dev.ftb.mods.ftbquests.quest.ChapterImage;
import dev.ftb.mods.ftbquests.quest.Movable;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestShape;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import dev.ftb.mods.ftbquests.quest.task.TaskTypes;
import dev.ftb.mods.ftbquests.quest.theme.property.ThemeProperties;
import java.util.ArrayList;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class QuestPanel
extends Panel {
    private static final ImageIcon DEFAULT_DEPENDENCY_LINE_TEXTURE = (ImageIcon)Icon.getIcon((String)"ftbquests:textures/gui/dependency.png");
    public final QuestScreen questScreen;
    public double questX = 0.0;
    public double questY = 0.0;
    public double centerQuestX = 0.0;
    public double centerQuestY = 0.0;
    public QuestButton mouseOverQuest = null;
    public double questMinX;
    public double questMinY;
    public double questMaxX;
    public double questMaxY;

    public QuestPanel(Panel panel) {
        super(panel);
        this.questScreen = (QuestScreen)panel.getGui();
    }

    public void updateMinMax() {
        this.questMinX = Double.POSITIVE_INFINITY;
        this.questMinY = Double.POSITIVE_INFINITY;
        this.questMaxX = Double.NEGATIVE_INFINITY;
        this.questMaxY = Double.NEGATIVE_INFINITY;
        for (Widget w : this.widgets) {
            double qh;
            double qw;
            double qy;
            double qx;
            Movable q;
            if (w instanceof QuestButton) {
                q = ((QuestButton)w).quest;
                qx = q.x;
                qy = q.y;
                qw = q.size;
                qh = q.size;
            } else {
                if (!(w instanceof ChapterImageButton)) continue;
                q = ((ChapterImageButton)w).chapterImage;
                qx = ((ChapterImage)q).x;
                qy = ((ChapterImage)q).y;
                qw = ((ChapterImage)q).width;
                qh = ((ChapterImage)q).height;
            }
            this.questMinX = Math.min(this.questMinX, qx - qw / 2.0);
            this.questMinY = Math.min(this.questMinY, qy - qh / 2.0);
            this.questMaxX = Math.max(this.questMaxX, qx + qw / 2.0);
            this.questMaxY = Math.max(this.questMaxY, qy + qh / 2.0);
        }
        if (this.questMinX == Double.POSITIVE_INFINITY) {
            this.questMaxY = 0.0;
            this.questMaxX = 0.0;
            this.questMinY = 0.0;
            this.questMinX = 0.0;
        }
        this.questMinX -= 40.0;
        this.questMinY -= 30.0;
        this.questMaxX += 40.0;
        this.questMaxY += 30.0;
    }

    public void scrollTo(double x, double y) {
        this.updateMinMax();
        double dx = this.questMaxX - this.questMinX;
        double dy = this.questMaxY - this.questMinY;
        this.setScrollX((x - this.questMinX) / dx * this.questScreen.scrollWidth - (double)this.width / 2.0);
        this.setScrollY((y - this.questMinY) / dy * this.questScreen.scrollHeight - (double)this.height / 2.0);
    }

    public void resetScroll() {
        this.alignWidgets();
        this.setScrollX((this.questScreen.scrollWidth - (double)this.width) / 2.0);
        this.setScrollY((this.questScreen.scrollHeight - (double)this.height) / 2.0);
    }

    public void addWidgets() {
        if (this.questScreen.selectedChapter == null) {
            return;
        }
        for (ChapterImage image : this.questScreen.selectedChapter.images) {
            if (!this.questScreen.file.canEdit() && (image.dev || image.dependency != null && !this.questScreen.file.self.isCompleted(image.dependency))) continue;
            this.add((Widget)new ChapterImageButton(this, image));
        }
        for (Quest quest : this.questScreen.selectedChapter.quests) {
            if (!this.questScreen.file.canEdit() && !quest.isVisible(this.questScreen.file.self)) continue;
            this.add((Widget)new QuestButton(this, quest));
        }
        this.alignWidgets();
    }

    public void alignWidgets() {
        if (this.questScreen.selectedChapter == null) {
            return;
        }
        this.questScreen.scrollWidth = 0.0;
        this.questScreen.scrollHeight = 0.0;
        this.updateMinMax();
        double bs = this.questScreen.getQuestButtonSize();
        double bp = this.questScreen.getQuestButtonSpacing();
        this.questScreen.scrollWidth = (this.questMaxX - this.questMinX) * (bs + bp);
        this.questScreen.scrollHeight = (this.questMaxY - this.questMinY) * (bs + bp);
        for (Widget w : this.widgets) {
            double qh;
            double qw;
            double qy;
            double qx;
            Movable q;
            if (w instanceof QuestButton) {
                q = ((QuestButton)w).quest;
                qx = q.x;
                qy = q.y;
                qw = q.size;
                qh = q.size;
            } else {
                if (!(w instanceof ChapterImageButton)) continue;
                q = ((ChapterImageButton)w).chapterImage;
                qx = ((ChapterImage)q).x;
                qy = ((ChapterImage)q).y;
                qw = ((ChapterImage)q).width;
                qh = ((ChapterImage)q).height;
            }
            double x = (qx - this.questMinX - qw / 2.0) * (bs + bp) + bp / 2.0 + bp * (qw - 1.0) / 2.0;
            double y = (qy - this.questMinY - qh / 2.0) * (bs + bp) + bp / 2.0 + bp * (qh - 1.0) / 2.0;
            w.setPosAndSize((int)x, (int)y, (int)(bs * qw), (int)(bs * qh));
        }
        this.setPosAndSize(20, 1, this.questScreen.width - 40, this.questScreen.height - 2);
    }

    public void drawOffsetBackground(MatrixStack matrixStack, Theme theme, int x, int y, int w, int h) {
        Quest wquest;
        if (this.questScreen.selectedChapter == null) {
            return;
        }
        GuiHelper.setupDrawing();
        for (Widget widget : this.widgets) {
            if (!(widget instanceof ChapterImageButton)) continue;
            widget.draw(matrixStack, theme, widget.getX(), widget.getY(), widget.width, widget.height);
        }
        Tessellator tesselator = Tessellator.func_178181_a();
        BufferBuilder buffer = tesselator.func_178180_c();
        Icon icon = (Icon)ThemeProperties.DEPENDENCY_LINE_TEXTURE.get(this.questScreen.selectedChapter);
        if (icon instanceof ImageIcon) {
            ((ImageIcon)icon).bindTexture();
        } else {
            DEFAULT_DEPENDENCY_LINE_TEXTURE.bindTexture();
        }
        Quest selectedQuest = this.questScreen.getViewedQuest();
        GuiHelper.setupDrawing();
        RenderSystem.enableDepthTest();
        RenderSystem.shadeModel((int)7425);
        double mt = -((double)System.currentTimeMillis() * 0.001);
        float mu = (float)(mt * (Double)ThemeProperties.DEPENDENCY_LINE_UNSELECTED_SPEED.get(this.questScreen.selectedChapter) % 1.0);
        float ms = (float)(mt * (Double)ThemeProperties.DEPENDENCY_LINE_SELECTED_SPEED.get(this.questScreen.selectedChapter) % 1.0);
        float s = (float)((double)this.questScreen.getZoom() * (Double)ThemeProperties.DEPENDENCY_LINE_THICKNESS.get(this.questScreen.selectedChapter) / 4.0 * 3.0);
        for (Widget widget : this.widgets) {
            if (!(widget instanceof QuestButton) || (wquest = ((QuestButton)widget).quest).getHideDependencyLines()) continue;
            boolean unavailable = this.questScreen.file.self == null || !this.questScreen.file.self.canStartTasks(wquest);
            boolean complete = !unavailable && this.questScreen.file.self != null && this.questScreen.file.self.isCompleted(wquest);
            for (QuestButton button : ((QuestButton)widget).getDependencies()) {
                int a;
                int b;
                int g;
                int r;
                Color4I c;
                if (button.quest == selectedQuest || wquest == selectedQuest) continue;
                if (complete) {
                    c = (Color4I)ThemeProperties.DEPENDENCY_LINE_COMPLETED_COLOR.get(this.questScreen.selectedChapter);
                    r = c.redi();
                    g = c.greeni();
                    b = c.bluei();
                    a = c.alphai();
                } else {
                    c = Color4I.hsb((float)((float)button.quest.id / 1000.0f), (float)0.2f, (float)(unavailable ? 0.3f : 0.8f));
                    r = c.redi();
                    g = c.greeni();
                    b = c.bluei();
                    a = 180;
                }
                int sx = widget.getX() + widget.width / 2;
                int sy = widget.getY() + widget.height / 2;
                int ex = button.getX() + button.width / 2;
                int ey = button.getY() + button.height / 2;
                float len = (float)MathUtils.dist((double)sx, (double)sy, (double)ex, (double)ey);
                matrixStack.func_227860_a_();
                matrixStack.func_227861_a_((double)sx, (double)sy, 0.0);
                matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229193_c_((float)Math.atan2(ey - sy, ex - sx)));
                Matrix4f m = matrixStack.func_227866_c_().func_227870_a_();
                buffer.func_181668_a(7, DefaultVertexFormats.field_227851_o_);
                buffer.func_227888_a_(m, 0.0f, -s, 0.0f).func_225586_a_(r, g, b, a).func_225583_a_(len / s / 2.0f + mu, 0.0f).func_181675_d();
                buffer.func_227888_a_(m, 0.0f, s, 0.0f).func_225586_a_(r, g, b, a).func_225583_a_(len / s / 2.0f + mu, 1.0f).func_181675_d();
                buffer.func_227888_a_(m, len, s, 0.0f).func_225586_a_(r * 3 / 4, g * 3 / 4, b * 3 / 4, a).func_225583_a_(mu, 1.0f).func_181675_d();
                buffer.func_227888_a_(m, len, -s, 0.0f).func_225586_a_(r * 3 / 4, g * 3 / 4, b * 3 / 4, a).func_225583_a_(mu, 0.0f).func_181675_d();
                tesselator.func_78381_a();
                matrixStack.func_227865_b_();
            }
        }
        for (Widget widget : this.widgets) {
            if (!(widget instanceof QuestButton) || (wquest = ((QuestButton)widget).quest).getHideDependencyLines()) continue;
            for (QuestButton button : ((QuestButton)widget).getDependencies()) {
                int a;
                int b;
                int g;
                int r;
                Color4I c;
                if (button.quest == selectedQuest) {
                    c = (Color4I)ThemeProperties.DEPENDENCY_LINE_REQUIRED_FOR_COLOR.get(this.questScreen.selectedChapter);
                    r = c.redi();
                    g = c.greeni();
                    b = c.bluei();
                    a = c.alphai();
                } else {
                    if (wquest != selectedQuest) continue;
                    c = (Color4I)ThemeProperties.DEPENDENCY_LINE_REQUIRES_COLOR.get(this.questScreen.selectedChapter);
                    r = c.redi();
                    g = c.greeni();
                    b = c.bluei();
                    a = c.alphai();
                }
                int sx = widget.getX() + widget.width / 2;
                int sy = widget.getY() + widget.height / 2;
                int ex = button.getX() + button.width / 2;
                int ey = button.getY() + button.height / 2;
                float len = (float)MathUtils.dist((double)sx, (double)sy, (double)ex, (double)ey);
                matrixStack.func_227860_a_();
                matrixStack.func_227861_a_((double)sx, (double)sy, 0.0);
                matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229193_c_((float)Math.atan2(ey - sy, ex - sx)));
                Matrix4f m = matrixStack.func_227866_c_().func_227870_a_();
                buffer.func_181668_a(7, DefaultVertexFormats.field_227851_o_);
                buffer.func_227888_a_(m, 0.0f, -s, 0.0f).func_225586_a_(r, g, b, a).func_225583_a_(len / s / 2.0f + ms, 0.0f).func_181675_d();
                buffer.func_227888_a_(m, 0.0f, s, 0.0f).func_225586_a_(r, g, b, a).func_225583_a_(len / s / 2.0f + ms, 1.0f).func_181675_d();
                buffer.func_227888_a_(m, len, s, 0.0f).func_225586_a_(r * 3 / 4, g * 3 / 4, b * 3 / 4, a).func_225583_a_(ms, 1.0f).func_181675_d();
                buffer.func_227888_a_(m, len, -s, 0.0f).func_225586_a_(r * 3 / 4, g * 3 / 4, b * 3 / 4, a).func_225583_a_(ms, 0.0f).func_181675_d();
                tesselator.func_78381_a();
                matrixStack.func_227865_b_();
            }
        }
        RenderSystem.shadeModel((int)7424);
    }

    public void draw(MatrixStack matrixStack, Theme theme, int x, int y, int w, int h) {
        super.draw(matrixStack, theme, x, y, w, h);
        if (this.questScreen.selectedChapter != null && this.isMouseOver()) {
            double dx = this.questMaxX - this.questMinX;
            double dy = this.questMaxY - this.questMinY;
            double px = (double)this.getX() - this.getScrollX();
            double py = (double)this.getY() - this.getScrollY();
            double qx = ((double)this.questScreen.getMouseX() - px) / this.questScreen.scrollWidth * dx + this.questMinX;
            double qy = ((double)this.questScreen.getMouseY() - py) / this.questScreen.scrollHeight * dy + this.questMinY;
            this.centerQuestX = ((double)this.questScreen.width / 2.0 - px) / this.questScreen.scrollWidth * dx + this.questMinX;
            this.centerQuestY = ((double)this.questScreen.height / 2.0 - py) / this.questScreen.scrollHeight * dy + this.questMinY;
            if (QuestPanel.isShiftKeyDown()) {
                this.questX = qx;
                this.questY = qy;
            } else if (this.questScreen.selectedObjects.size() == 1 && this.questScreen.selectedObjects.get(0) instanceof Quest) {
                Quest q = (Quest)this.questScreen.selectedObjects.get(0);
                double s = 1.0 / this.questScreen.file.gridScale / q.size;
                this.questX = (double)MathHelper.func_76128_c((double)(qx * s + 0.5)) / s;
                this.questY = (double)MathHelper.func_76128_c((double)(qy * s + 0.5)) / s;
            } else {
                double s = 1.0 / this.questScreen.file.gridScale;
                this.questX = (double)MathHelper.func_76128_c((double)(qx * s + 0.5)) / s;
                this.questY = (double)MathHelper.func_76128_c((double)(qy * s + 0.5)) / s;
            }
            if (this.questScreen.file.canEdit()) {
                matrixStack.func_227860_a_();
                matrixStack.func_227861_a_(0.0, 0.0, 600.0);
                theme.drawString(matrixStack, (Object)("X:" + (this.questX < 0.0 ? "" : " ") + StringUtils.DOUBLE_FORMATTER_00.format(this.questX)), x + 3, y + h - 18, 2);
                theme.drawString(matrixStack, (Object)("Y:" + (this.questY < 0.0 ? "" : " ") + StringUtils.DOUBLE_FORMATTER_00.format(this.questY)), x + 3, y + h - 10, 2);
                if (!this.questScreen.selectedObjects.isEmpty()) {
                    theme.drawString(matrixStack, (Object)("Selected: " + this.questScreen.selectedObjects.size()), x + 3, y + h - 26, 2);
                }
                theme.drawString(matrixStack, (Object)("CX:" + (this.centerQuestX < 0.0 ? "" : " ") + StringUtils.DOUBLE_FORMATTER_00.format(this.centerQuestX)), x + w - 42, y + h - 18, 2);
                theme.drawString(matrixStack, (Object)("CY:" + (this.centerQuestY < 0.0 ? "" : " ") + StringUtils.DOUBLE_FORMATTER_00.format(this.centerQuestY)), x + w - 42, y + h - 10, 2);
                matrixStack.func_227865_b_();
                double bs = this.questScreen.getQuestButtonSize();
                if (this.questScreen.movingObjects && !this.questScreen.selectedObjects.isEmpty()) {
                    double ominX = Double.POSITIVE_INFINITY;
                    double ominY = Double.POSITIVE_INFINITY;
                    double omaxX = Double.NEGATIVE_INFINITY;
                    double omaxY = Double.NEGATIVE_INFINITY;
                    for (Movable q : this.questScreen.selectedObjects) {
                        ominX = Math.min(ominX, q.getX());
                        ominY = Math.min(ominY, q.getY());
                        omaxX = Math.max(omaxX, q.getX());
                        omaxY = Math.max(omaxY, q.getY());
                    }
                    for (Movable m : this.questScreen.selectedObjects) {
                        double ox = m.getX() - ominX;
                        double oy = m.getY() - ominY;
                        double sx = (this.questX + ox - this.questMinX) / dx * this.questScreen.scrollWidth + px;
                        double sy = (this.questY + oy - this.questMinY) / dy * this.questScreen.scrollHeight + py;
                        matrixStack.func_227860_a_();
                        matrixStack.func_227861_a_(sx - bs * m.getWidth() / 2.0, sy - bs * m.getHeight() / 2.0, 0.0);
                        matrixStack.func_227862_a_((float)(bs * m.getWidth()), (float)(bs * m.getHeight()), 1.0f);
                        GuiHelper.setupDrawing();
                        RenderSystem.enableDepthTest();
                        m.drawMoved(matrixStack);
                        matrixStack.func_227865_b_();
                    }
                    if (QuestScreen.grid && this.questScreen.viewQuestPanel.quest == null) {
                        double boxX = ominX / dx * this.questScreen.scrollWidth + px;
                        double boxY = ominY / dy * this.questScreen.scrollHeight + py;
                        double boxW = omaxX / dx * this.questScreen.scrollWidth + px - boxX;
                        double boxH = omaxY / dy * this.questScreen.scrollHeight + py - boxY;
                        matrixStack.func_227860_a_();
                        matrixStack.func_227861_a_(0.0, 0.0, 1000.0);
                        GuiHelper.drawHollowRect((MatrixStack)matrixStack, (int)((int)boxX), (int)((int)boxY), (int)((int)boxW), (int)((int)boxH), (Color4I)Color4I.WHITE.withAlpha(30), (boolean)false);
                        matrixStack.func_227865_b_();
                    }
                } else if (this.questScreen.viewQuestPanel.quest == null || !this.questScreen.viewQuestPanel.isMouseOver()) {
                    double sx = (this.questX - this.questMinX) / dx * this.questScreen.scrollWidth + px;
                    double sy = (this.questY - this.questMinY) / dy * this.questScreen.scrollHeight + py;
                    matrixStack.func_227860_a_();
                    matrixStack.func_227861_a_(sx - bs / 2.0, sy - bs / 2.0, 0.0);
                    matrixStack.func_227862_a_((float)bs, (float)bs, 1.0f);
                    GuiHelper.setupDrawing();
                    RenderSystem.enableDepthTest();
                    RenderSystem.alphaFunc((int)516, (float)0.01f);
                    QuestShape.get((String)this.questScreen.selectedChapter.getDefaultQuestShape()).shape.withColor(Color4I.WHITE.withAlpha(10)).draw(matrixStack, 0, 0, 1, 1);
                    RenderSystem.defaultAlphaFunc();
                    matrixStack.func_227865_b_();
                    if (QuestScreen.grid && this.questScreen.viewQuestPanel.quest == null) {
                        matrixStack.func_227860_a_();
                        matrixStack.func_227861_a_(0.0, 0.0, 1000.0);
                        Color4I.WHITE.draw(matrixStack, (int)sx, (int)sy, 1, 1);
                        Color4I.WHITE.withAlpha(30).draw(matrixStack, this.getX(), (int)sy, this.width, 1);
                        Color4I.WHITE.withAlpha(30).draw(matrixStack, (int)sx, this.getY(), 1, this.height);
                        matrixStack.func_227865_b_();
                    }
                }
            }
        }
    }

    public boolean mousePressed(MouseButton button) {
        if (this.questScreen.selectedChapter == null || this.questScreen.chapterPanel.isMouseOver()) {
            return false;
        }
        if (this.questScreen.movingObjects && this.questScreen.file.canEdit()) {
            if (this.questScreen.selectedChapter != null && !button.isRight() && !this.questScreen.selectedObjects.isEmpty()) {
                this.playClickSound();
                double minX = Double.POSITIVE_INFINITY;
                double minY = Double.POSITIVE_INFINITY;
                for (Movable q : this.questScreen.selectedObjects) {
                    minX = Math.min(minX, q.getX());
                    minY = Math.min(minY, q.getY());
                }
                for (Movable q : new ArrayList<Movable>(this.questScreen.selectedObjects)) {
                    q.move(this.questScreen.selectedChapter, this.questX + (q.getX() - minX), this.questY + (q.getY() - minY));
                }
            }
            this.questScreen.movingObjects = false;
            this.questScreen.selectedObjects.clear();
            return true;
        }
        if (super.mousePressed(button)) {
            return true;
        }
        if (!this.questScreen.viewQuestPanel.hidePanel && this.questScreen.isViewingQuest()) {
            this.questScreen.closeQuest();
            return true;
        }
        if (button.isLeft() && this.isMouseOver() && (this.questScreen.viewQuestPanel.hidePanel || !this.questScreen.isViewingQuest())) {
            this.questScreen.prevMouseX = this.getMouseX();
            this.questScreen.prevMouseY = this.getMouseY();
            this.questScreen.grabbed = 1;
            return true;
        }
        if (button.isRight() && this.questScreen.file.canEdit()) {
            this.playClickSound();
            ArrayList<ContextMenuItem> contextMenu = new ArrayList<ContextMenuItem>();
            double qx = this.questX;
            double qy = this.questY;
            for (TaskType type : TaskTypes.TYPES.values()) {
                contextMenu.add(new ContextMenuItem(type.getDisplayName(), type.getIcon(), () -> {
                    this.playClickSound();
                    type.getGuiProvider().openCreationGui((Runnable)((Object)this), new Quest(this.questScreen.selectedChapter), task -> new CreateTaskAtMessage(this.questScreen.selectedChapter, qx, qy, (Task)task).sendToServer());
                }));
            }
            contextMenu.add(new ContextMenuItem((ITextComponent)new TranslationTextComponent("ftbquests.chapter.image"), Icons.ART, () -> {
                this.playClickSound();
                ChapterImage image = new ChapterImage(this.questScreen.selectedChapter);
                image.x = qx;
                image.y = qy;
                this.questScreen.selectedChapter.images.add(image);
                new EditObjectMessage(this.questScreen.selectedChapter).sendToServer();
            }));
            this.questScreen.openContextMenu(contextMenu);
            return true;
        }
        return false;
    }

    public void mouseReleased(MouseButton button) {
        super.mouseReleased(button);
        this.questScreen.grabbed = 0;
    }

    public boolean checkMouseOver(int mouseX, int mouseY) {
        if (this.questScreen.chapterPanel.isMouseOver()) {
            return false;
        }
        return super.checkMouseOver(mouseX, mouseY);
    }

    public void updateMouseOver(int mouseX, int mouseY) {
        this.mouseOverQuest = null;
        super.updateMouseOver(mouseX, mouseY);
        for (Widget widget : this.widgets) {
            if (!widget.isMouseOver() || !(widget instanceof QuestButton)) continue;
            this.mouseOverQuest = (QuestButton)widget;
            break;
        }
    }

    public boolean keyPressed(Key key) {
        if (this.questScreen.selectedChapter != null && !this.questScreen.isViewingQuest() && (key.is(45) || key.is(61))) {
            this.questScreen.addZoom(key.is(45) ? -1.0 : 1.0);
            return true;
        }
        return super.keyPressed(key);
    }

    public boolean scrollPanel(double scroll) {
        if (this.questScreen.selectedChapter != null && !this.questScreen.isViewingQuest() && this.isMouseOver()) {
            this.questScreen.addZoom(scroll);
            return true;
        }
        return false;
    }
}

