/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.property;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftbteams.property.TeamProperty;
import dev.ftb.mods.ftbteams.property.TeamPropertyType;
import dev.ftb.mods.ftbteams.property.TeamPropertyValue;
import java.util.Optional;
import net.minecraft.nbt.ByteNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NumberNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;

public class BooleanProperty
extends TeamProperty<Boolean> {
    private static final Optional<Boolean> TRUE = Optional.of(Boolean.TRUE);
    private static final Optional<Boolean> FALSE = Optional.of(Boolean.FALSE);

    public BooleanProperty(ResourceLocation id, Boolean def) {
        super(id, def);
    }

    public BooleanProperty(ResourceLocation id, PacketBuffer buf) {
        super(id, buf.readBoolean());
    }

    @Override
    public TeamPropertyType<Boolean> getType() {
        return TeamPropertyType.BOOLEAN;
    }

    @Override
    public Optional<Boolean> fromString(String string) {
        if (string.equals("true")) {
            return TRUE;
        }
        if (string.equals("false")) {
            return FALSE;
        }
        return Optional.empty();
    }

    @Override
    public void write(PacketBuffer buf) {
        buf.writeBoolean(((Boolean)this.defaultValue).booleanValue());
    }

    @Override
    public void config(ConfigGroup config, TeamPropertyValue<Boolean> value) {
        config.addBool(this.id.func_110624_b() + "." + this.id.func_110623_a(), ((Boolean)value.value).booleanValue(), value.consumer, ((Boolean)this.defaultValue).booleanValue());
    }

    @Override
    public INBT toNBT(Boolean value) {
        return ByteNBT.func_229672_a_((boolean)value);
    }

    @Override
    public Optional<Boolean> fromNBT(INBT tag) {
        if (tag instanceof NumberNBT) {
            if (((NumberNBT)tag).func_150290_f() == 1) {
                return TRUE;
            }
            return FALSE;
        }
        return Optional.empty();
    }
}

