/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.client.map;

import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import org.jetbrains.annotations.Nullable;

public class PlayerHeadTexture
extends SimpleTexture {
    private final String imageUrl;
    @Nullable
    private CompletableFuture<?> future;
    private boolean textureUploaded;

    public PlayerHeadTexture(String imageUrlIn, ResourceLocation textureResourceLocation) {
        super(textureResourceLocation);
        this.imageUrl = imageUrlIn;
    }

    private void upload(NativeImage imageIn) {
        TextureUtil.func_225680_a_((int)this.func_110552_b(), (int)imageIn.func_195702_a(), (int)imageIn.func_195714_b());
        imageIn.func_195697_a(0, 0, 0, true);
    }

    public void func_195413_a(IResourceManager manager) {
        Minecraft.func_71410_x().execute(() -> {
            if (!this.textureUploaded) {
                try {
                    super.func_195413_a(manager);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.textureUploaded = true;
            }
        });
        if (this.future == null) {
            this.future = CompletableFuture.runAsync(() -> {
                try {
                    HttpURLConnection httpurlconnection = (HttpURLConnection)new URL(this.imageUrl).openConnection(Minecraft.func_71410_x().func_110437_J());
                    httpurlconnection.setDoInput(true);
                    httpurlconnection.setDoOutput(false);
                    httpurlconnection.connect();
                    if (httpurlconnection.getResponseCode() / 100 == 2) {
                        InputStream inputstream = httpurlconnection.getInputStream();
                        Minecraft.func_71410_x().execute(() -> {
                            try {
                                NativeImage img = NativeImage.func_195713_a((InputStream)inputstream);
                                if (img != null) {
                                    this.textureUploaded = true;
                                    if (!RenderSystem.isOnRenderThread()) {
                                        RenderSystem.recordRenderCall(() -> this.upload(img));
                                    } else {
                                        this.upload(img);
                                    }
                                    httpurlconnection.disconnect();
                                }
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        });
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }, Util.func_215072_e());
        }
    }
}

