/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.info;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.LightType;
import net.minecraft.world.biome.Biome;
import xaero.common.minimap.info.InfoDisplay;
import xaero.common.minimap.info.InfoDisplayManager;
import xaero.common.minimap.info.codec.InfoDisplayCommonStateCodecs;
import xaero.common.minimap.info.widget.InfoDisplayCommonWidgetFactories;
import xaero.common.minimap.info.widget.InfoDisplayCycleWidgetFactory;
import xaero.common.minimap.waypoints.WaypointsManager;

public class BuiltInInfoDisplays {
    private static List<InfoDisplay<?>> ALL = new ArrayList();
    public static final InfoDisplay<Boolean> COORDINATES = new InfoDisplay<Boolean>("coords", (TextComponent)new TranslationTextComponent("gui.xaero_infodisplay_coords"), true, InfoDisplayCommonStateCodecs.BOOLEAN, InfoDisplayCommonWidgetFactories.OFF_ON, (displayInfo, compiler, session, processor, x, y, w, h, scale, size, playerBlockX, playerBlockY, playerBlockZ, playerPos) -> {
        if (!((Boolean)displayInfo.getState()).booleanValue()) {
            return;
        }
        int interfaceSize = size;
        String coords = playerBlockX + ", " + playerBlockY + ", " + playerBlockZ;
        if (Minecraft.func_71410_x().field_71466_p.func_78256_a(coords) >= interfaceSize) {
            String stringLevel = "" + playerBlockY;
            coords = playerBlockX + ", " + playerBlockZ;
            compiler.addLine(coords);
            compiler.addLine(stringLevel);
        } else {
            compiler.addLine(coords);
        }
    }, ALL);
    public static final InfoDisplay<Boolean> OVERWORLD_COORDINATES = new InfoDisplay<Boolean>("overworld_coords", (TextComponent)new TranslationTextComponent("gui.xaero_infodisplay_overworld_coords"), false, InfoDisplayCommonStateCodecs.BOOLEAN, InfoDisplayCommonWidgetFactories.OFF_ON, (displayInfo, compiler, session, processor, x, y, w, h, scale, size, playerBlockX, playerBlockY, playerBlockZ, playerPos) -> {
        if (!((Boolean)displayInfo.getState()).booleanValue()) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        double coordinateScale = mc.field_71441_e.func_230315_m_().func_242724_f();
        if (coordinateScale == 1.0) {
            return;
        }
        int overworldPlayerX = MathHelper.func_76128_c((double)((double)playerBlockX * coordinateScale));
        int overworldPlayerZ = MathHelper.func_76128_c((double)((double)playerBlockZ * coordinateScale));
        String coords = "Xo: " + overworldPlayerX + ", Zo: " + overworldPlayerZ;
        compiler.addWords(size, coords);
    }, ALL);
    public static final InfoDisplay<Boolean> CHUNK_COORDINATES = new InfoDisplay<Boolean>("chunk_coords", (TextComponent)new TranslationTextComponent("gui.xaero_infodisplay_chunk_coords"), false, InfoDisplayCommonStateCodecs.BOOLEAN, InfoDisplayCommonWidgetFactories.OFF_ON, (displayInfo, compiler, session, processor, x, y, w, h, scale, size, playerBlockX, playerBlockY, playerBlockZ, playerPos) -> {
        if (!((Boolean)displayInfo.getState()).booleanValue()) {
            return;
        }
        int chunkX = playerBlockX >> 4;
        int chunkZ = playerBlockZ >> 4;
        int insideX = playerBlockX & 0xF;
        int insideZ = playerBlockZ & 0xF;
        String coords = "C " + chunkX + ", " + chunkZ + " (" + insideX + "; " + insideZ + ")";
        compiler.addWords(size, coords);
    }, ALL);
    public static final InfoDisplay<Boolean> ANGLES = new InfoDisplay<Boolean>("angles", (TextComponent)new TranslationTextComponent("gui.xaero_infodisplay_angles"), false, InfoDisplayCommonStateCodecs.BOOLEAN, InfoDisplayCommonWidgetFactories.OFF_ON, (displayInfo, compiler, session, processor, x, y, w, h, scale, size, playerBlockX, playerBlockY, playerBlockZ, playerPos) -> {
        if (!((Boolean)displayInfo.getState()).booleanValue()) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        compiler.addLine((ITextComponent)new StringTextComponent(String.format("%.1f / %.1f", Float.valueOf(MathHelper.func_76142_g((float)mc.func_175606_aa().field_70177_z)), Float.valueOf(MathHelper.func_76142_g((float)mc.func_175606_aa().field_70125_A)))));
    }, ALL);
    public static final InfoDisplay<Boolean> DIMENSION = new InfoDisplay<Boolean>("dimension", (TextComponent)new TranslationTextComponent("gui.xaero_infodisplay_dimension"), false, InfoDisplayCommonStateCodecs.BOOLEAN, InfoDisplayCommonWidgetFactories.OFF_ON, (displayInfo, compiler, session, processor, x, y, w, h, scale, size, playerBlockX, playerBlockY, playerBlockZ, playerPos) -> {
        if (!((Boolean)displayInfo.getState()).booleanValue()) {
            return;
        }
        ResourceLocation dimensionId = Minecraft.func_71410_x().field_71441_e.func_234923_W_().func_240901_a_();
        if (dimensionId != null) {
            String dimensionName = dimensionId.func_110624_b().equals("minecraft") ? dimensionId.func_110623_a() : dimensionId.toString();
            compiler.addLine(dimensionName);
        }
    }, ALL);
    public static final InfoDisplay<Boolean> BIOME = new InfoDisplay<Boolean>("biome", (TextComponent)new TranslationTextComponent("gui.xaero_infodisplay_biome"), false, InfoDisplayCommonStateCodecs.BOOLEAN, InfoDisplayCommonWidgetFactories.OFF_ON, (displayInfo, compiler, session, processor, x, y, w, h, scale, size, playerBlockX, playerBlockY, playerBlockZ, playerPos) -> {
        if (!((Boolean)displayInfo.getState()).booleanValue()) {
            return;
        }
        Biome biome = Minecraft.func_71410_x().field_71441_e.func_226691_t_(playerPos);
        ResourceLocation biomeRL = biome == null ? null : Minecraft.func_71410_x().field_71441_e.func_241828_r().func_243612_b(Registry.field_239720_u_).func_177774_c((Object)biome);
        String biomeText = biomeRL == null ? I18n.func_135052_a((String)"gui.xaero_unknown_biome", (Object[])new Object[0]) : I18n.func_135052_a((String)("biome." + biomeRL.func_110624_b() + "." + biomeRL.func_110623_a()), (Object[])new Object[0]);
        compiler.addWords(size, biomeText);
    }, ALL);
    public static final InfoDisplay<Boolean> WEATHER = new InfoDisplay<Boolean>("weather", (TextComponent)new TranslationTextComponent("gui.xaero_infodisplay_weather"), false, InfoDisplayCommonStateCodecs.BOOLEAN, InfoDisplayCommonWidgetFactories.OFF_ON, (displayInfo, compiler, session, processor, x, y, w, h, scale, size, playerBlockX, playerBlockY, playerBlockZ, playerPos) -> {
        if (!((Boolean)displayInfo.getState()).booleanValue()) {
            return;
        }
        if (Minecraft.func_71410_x().field_71441_e.func_72911_I()) {
            compiler.addLine((ITextComponent)new TranslationTextComponent("gui.xaero_weather_thundering"));
        } else if (Minecraft.func_71410_x().field_71441_e.func_72896_J()) {
            compiler.addLine((ITextComponent)new TranslationTextComponent("gui.xaero_weather_raining"));
        }
    }, ALL);
    public static final InfoDisplay<Integer> LIGHT_LEVEL = new InfoDisplay<Integer>("light_level", (TextComponent)new TranslationTextComponent("gui.xaero_infodisplay_light_level"), 0, InfoDisplayCommonStateCodecs.INTEGER, new InfoDisplayCycleWidgetFactory(Lists.newArrayList((Object[])new Integer[]{0, 1, 2, 3, 4}), Lists.newArrayList((Object[])new ITextComponent[]{new TranslationTextComponent("gui.xaero_off"), new TranslationTextComponent("gui.xaero_light_block"), new TranslationTextComponent("gui.xaero_light_sky"), new TranslationTextComponent("gui.xaero_light_all"), new TranslationTextComponent("gui.xaero_light_both2")})), (displayInfo, compiler, session, processor, x, y, w, h, scale, size, playerBlockX, playerBlockY, playerBlockZ, playerPos) -> {
        int showLightLevel = (Integer)displayInfo.getState();
        if (showLightLevel == 0) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        int blockLight = mc.field_71441_e.func_226658_a_(LightType.BLOCK, playerPos);
        int skyLight = mc.field_71441_e.func_226658_a_(LightType.SKY, playerPos);
        if (showLightLevel == 1) {
            compiler.addLine((ITextComponent)new TranslationTextComponent("gui.xaero_block_light_value", new Object[]{blockLight}));
        } else if (showLightLevel == 2) {
            compiler.addLine((ITextComponent)new TranslationTextComponent("gui.xaero_sky_light_value", new Object[]{skyLight}));
        } else if (showLightLevel == 3) {
            compiler.addLine((ITextComponent)new TranslationTextComponent("gui.xaero_all_light_value", new Object[]{Math.max(blockLight, skyLight)}));
        } else {
            compiler.addLine((ITextComponent)new TranslationTextComponent("gui.xaero_both_light_value", new Object[]{blockLight, skyLight}));
        }
    }, ALL);
    public static final InfoDisplay<Integer> TIME = new InfoDisplay<Integer>("time", (TextComponent)new TranslationTextComponent("gui.xaero_infodisplay_time"), 0, InfoDisplayCommonStateCodecs.INTEGER, new InfoDisplayCycleWidgetFactory(Lists.newArrayList((Object[])new Integer[]{0, 1, 2, 3, 4}), Lists.newArrayList((Object[])new ITextComponent[]{new TranslationTextComponent("gui.xaero_off"), new TranslationTextComponent("%s+%s", new Object[]{new TranslationTextComponent("gui.xaero_day"), new TranslationTextComponent("gui.xaero_24h")}), new TranslationTextComponent("%s+%s", new Object[]{new TranslationTextComponent("gui.xaero_day"), new TranslationTextComponent("gui.xaero_12h")}), new TranslationTextComponent("gui.xaero_24h"), new TranslationTextComponent("gui.xaero_12h")})), (displayInfo, compiler, session, processor, x, y, w, h, scale, size, playerBlockX, playerBlockY, playerBlockZ, playerPos) -> {
        int showTime = (Integer)displayInfo.getState();
        if (showTime <= 0) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        long totalTime = 6000L + mc.field_71441_e.func_72820_D();
        int dayNumber = (int)(totalTime / 24000L) + 1;
        int dayTimeSinceMidnight = (int)(totalTime % 24000L);
        int timeHours = dayTimeSinceMidnight / 1000;
        int minutes = (int)((double)(dayTimeSinceMidnight % 1000) / 1000.0 * 60.0);
        if ((showTime - 1) % 2 == 0) {
            if (showTime < 3) {
                compiler.addWords(size, I18n.func_135052_a((String)"gui.xaero_day", (Object[])new Object[0]) + String.format(" %d, %02d:%02d", dayNumber, timeHours, minutes));
            } else {
                compiler.addWords(size, String.format("%02d:%02d", timeHours, minutes));
            }
        } else {
            String half = "AM";
            if (timeHours >= 12) {
                timeHours -= 12;
                half = "PM";
            }
            if (timeHours == 0) {
                timeHours = 12;
            }
            if (showTime < 3) {
                compiler.addWords(size, I18n.func_135052_a((String)"gui.xaero_day", (Object[])new Object[0]) + String.format(" %d, %02d:%02d %s", dayNumber, timeHours, minutes, half));
            } else {
                compiler.addWords(size, String.format("%02d:%02d %s", timeHours, minutes, half));
            }
        }
    }, ALL);
    private static final Calendar CALENDAR = Calendar.getInstance();
    public static final InfoDisplay<Integer> REAL_TIME = new InfoDisplay<Integer>("real_time", (TextComponent)new TranslationTextComponent("gui.xaero_infodisplay_real_time"), 0, InfoDisplayCommonStateCodecs.INTEGER, new InfoDisplayCycleWidgetFactory(Lists.newArrayList((Object[])new Integer[]{0, 1, 2}), Lists.newArrayList((Object[])new ITextComponent[]{new TranslationTextComponent("gui.xaero_off"), new TranslationTextComponent("gui.xaero_24h"), new TranslationTextComponent("gui.xaero_12h")})), (displayInfo, compiler, session, processor, x, y, w, h, scale, size, playerBlockX, playerBlockY, playerBlockZ, playerPos) -> {
        int showTime = (Integer)displayInfo.getState();
        if (showTime <= 0) {
            return;
        }
        CALENDAR.setTimeInMillis(System.currentTimeMillis());
        int timeHours = CALENDAR.get(11);
        int minutes = CALENDAR.get(12);
        if (showTime == 1) {
            compiler.addWords(size, String.format("%02d:%02d IRL", timeHours, minutes));
        } else {
            String half = "AM";
            if (timeHours >= 12) {
                timeHours -= 12;
                half = "PM";
            }
            if (timeHours == 0) {
                timeHours = 12;
            }
            compiler.addWords(size, String.format("%02d:%02d %s IRL", timeHours, minutes, half));
        }
    }, ALL);
    public static final InfoDisplay<Boolean> HIGHLIGHTS = new InfoDisplay<Boolean>("highlights", (TextComponent)new TranslationTextComponent("gui.xaero_infodisplay_highlights"), true, InfoDisplayCommonStateCodecs.BOOLEAN, InfoDisplayCommonWidgetFactories.ALWAYS_ON, (displayInfo, compiler, session, processor, x, y, w, h, scale, size, playerBlockX, playerBlockY, playerBlockZ, playerPos) -> {
        if (!((Boolean)displayInfo.getState()).booleanValue()) {
            return;
        }
        if (processor.getMinimapWriter().getDimensionHighlightHandler() != null) {
            processor.getMinimapWriter().getDimensionHighlightHandler().addBlockHighlightTooltips(compiler, playerBlockX, playerBlockZ, size, true);
        }
    }, ALL);
    public static final InfoDisplay<Boolean> LIGHT_OVERLAY_INDICATOR = new InfoDisplay<Boolean>("light_overlay_indicator", (TextComponent)new TranslationTextComponent("gui.xaero_infodisplay_light_overlay_indicator"), true, InfoDisplayCommonStateCodecs.BOOLEAN, InfoDisplayCommonWidgetFactories.ALWAYS_ON, (displayInfo, compiler, session, processor, x, y, w, h, scale, size, playerBlockX, playerBlockY, playerBlockZ, playerPos) -> {
        if (!((Boolean)displayInfo.getState()).booleanValue()) {
            return;
        }
        if (session.getModMain().getSettings().lightOverlayType > 0) {
            compiler.addWords(size, I18n.func_135052_a((String)"gui.xaero_light_overlay_status", (Object[])new Object[0]));
        }
    }, ALL);
    public static final InfoDisplay<Boolean> MANUAL_CAVE_MODE_INDICATOR = new InfoDisplay<Boolean>("manual_cave_mode_indicator", (TextComponent)new TranslationTextComponent("gui.xaero_infodisplay_manual_cave_mode_indicator"), true, InfoDisplayCommonStateCodecs.BOOLEAN, InfoDisplayCommonWidgetFactories.ALWAYS_ON, (displayInfo, compiler, session, processor, x, y, w, h, scale, size, playerBlockX, playerBlockY, playerBlockZ, playerPos) -> {
        if (!((Boolean)displayInfo.getState()).booleanValue()) {
            return;
        }
        if (processor.isManualCaveMode()) {
            compiler.addWords(size, I18n.func_135052_a((String)"gui.xaero_manual_cave_mode", (Object[])new Object[0]));
        }
    }, ALL);
    public static final InfoDisplay<Boolean> CUSTOM_SUB_WORLD = new InfoDisplay<Boolean>("custom_sub_world", (TextComponent)new TranslationTextComponent("gui.xaero_infodisplay_custom_sub_world"), true, InfoDisplayCommonStateCodecs.BOOLEAN, InfoDisplayCommonWidgetFactories.ALWAYS_ON, (displayInfo, compiler, session, processor, x, y, w, h, scale, size, playerBlockX, playerBlockY, playerBlockZ, playerPos) -> {
        if (!((Boolean)displayInfo.getState()).booleanValue()) {
            return;
        }
        WaypointsManager waypointsManager = session.getWaypointsManager();
        if (waypointsManager.getCurrentWorld() != null && waypointsManager.getAutoWorld() != waypointsManager.getCurrentWorld()) {
            compiler.addWords(size, I18n.func_135052_a((String)"gui.xaero_using_custom_subworld", (Object[])new Object[]{waypointsManager.getCurrentWorld().getContainer().getSubName()}));
        }
    }, ALL);

    public static void addToManager(InfoDisplayManager manager) {
        ALL.forEach(manager::add);
    }
}

