/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.client;

import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.mrcrayfish.configured.Config;
import com.mrcrayfish.configured.Configured;
import com.mrcrayfish.configured.api.IModConfig;
import com.mrcrayfish.configured.client.screen.IBackgroundTexture;
import com.mrcrayfish.configured.client.screen.ModConfigSelectionScreen;
import com.mrcrayfish.configured.client.util.OptiFineHelper;
import com.mrcrayfish.configured.impl.ForgeConfig;
import com.mrcrayfish.configured.util.ConfigHelper;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.client.gui.screen.ModListScreen;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.config.ConfigTracker;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;
import net.minecraftforge.forgespi.language.IModInfo;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="configured", value={Dist.CLIENT})
public class ClientHandler {
    public static final KeyBinding KEY_OPEN_MOD_LIST = new KeyBinding("key.configured.open_mod_list", -1, "key.categories.configured");

    public static void registerKeyBindings() {
        ClientRegistry.registerKeyBinding((KeyBinding)KEY_OPEN_MOD_LIST);
    }

    public static void generateConfigFactories() {
        Configured.LOGGER.info("Creating config GUI factories...");
        ModList.get().forEachModContainer((modId, container) -> {
            if (container.getCustomExtension(ExtensionPoint.CONFIGGUIFACTORY).isPresent() && !((Boolean)Config.CLIENT.forceConfiguredMenu.get()).booleanValue()) {
                return;
            }
            Map<ModConfig.Type, Set<IModConfig>> modConfigMap = ClientHandler.createConfigMap(container);
            if (!modConfigMap.isEmpty()) {
                Configured.LOGGER.info("Registering config factory for mod {}. Found {} client config(s) and {} common config(s)", modId, (Object)modConfigMap.getOrDefault(ModConfig.Type.CLIENT, Collections.emptySet()).size(), (Object)modConfigMap.getOrDefault(ModConfig.Type.COMMON, Collections.emptySet()).size());
                String displayName = container.getModInfo().getDisplayName();
                ResourceLocation backgroundTexture = ClientHandler.getBackgroundTexture(container.getModInfo());
                container.registerExtensionPoint(ExtensionPoint.CONFIGGUIFACTORY, () -> (mc, screen) -> new ModConfigSelectionScreen((Screen)screen, (ITextComponent)new StringTextComponent(displayName), backgroundTexture, modConfigMap));
            }
        });
    }

    private static EnumMap<ModConfig.Type, Set<ModConfig>> getConfigSets() {
        return (EnumMap)ObfuscationReflectionHelper.getPrivateValue(ConfigTracker.class, (Object)ConfigTracker.INSTANCE, (String)"configSets");
    }

    public static Map<ModConfig.Type, Set<IModConfig>> createConfigMap(ModContainer container) {
        HashMap<ModConfig.Type, Set<IModConfig>> modConfigMap = new HashMap<ModConfig.Type, Set<IModConfig>>();
        ClientHandler.addConfigSetToMap(container, ModConfig.Type.CLIENT, modConfigMap);
        ClientHandler.addConfigSetToMap(container, ModConfig.Type.COMMON, modConfigMap);
        ClientHandler.addConfigSetToMap(container, ModConfig.Type.SERVER, modConfigMap);
        return modConfigMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addConfigSetToMap(ModContainer container, ModConfig.Type type, Map<ModConfig.Type, Set<IModConfig>> configMap) {
        Set<ModConfig> configSet;
        if (type == ModConfig.Type.CLIENT && OptiFineHelper.isLoaded() && container.getModId().equals("forge")) {
            Configured.LOGGER.info("Ignoring Forge's client config since OptiFine was detected");
            return;
        }
        Set<ModConfig> set = configSet = ClientHandler.getConfigSets().get(type);
        synchronized (set) {
            Set filteredConfigSets = configSet.stream().filter(config -> config.getModId().equals(container.getModId())).map(config -> {
                ForgeConfigSpec forgeConfigSpec = ConfigHelper.findForgeConfigSpec((UnmodifiableConfig)config.getSpec());
                if (forgeConfigSpec != null) {
                    return new ForgeConfig((ModConfig)config, forgeConfigSpec);
                }
                return null;
            }).collect(Collectors.toSet());
            if (!filteredConfigSets.isEmpty()) {
                configMap.put(type, filteredConfigSets);
            }
        }
    }

    private static ResourceLocation getBackgroundTexture(IModInfo info) {
        Optional optional;
        String configBackground = (String)info.getModProperties().get("configuredBackground");
        if (configBackground != null) {
            return new ResourceLocation(configBackground);
        }
        if (info instanceof ModInfo && (optional = ((ModInfo)info).getConfigElement(new String[]{"configBackground"})).isPresent()) {
            return new ResourceLocation((String)optional.get());
        }
        return AbstractGui.field_230663_f_;
    }

    public static void updateAbstractListTexture(AbstractList<?> list) {
        if (list instanceof IBackgroundTexture) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(((IBackgroundTexture)list).getBackgroundTexture());
        }
    }

    public static void updateScreenTexture(Screen screen) {
        if (screen instanceof IBackgroundTexture) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(((IBackgroundTexture)screen).getBackgroundTexture());
        }
    }

    @SubscribeEvent
    public static void onKeyPress(InputEvent.KeyInputEvent event) {
        if (event.getAction() == 1 && KEY_OPEN_MOD_LIST.func_151468_f()) {
            Minecraft minecraft = Minecraft.func_71410_x();
            if (minecraft.field_71439_g == null) {
                return;
            }
            Screen oldScreen = minecraft.field_71462_r;
            minecraft.func_147108_a((Screen)new ModListScreen(oldScreen));
        }
    }
}

