/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbmoney.integration;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import dev.ftb.mods.ftbmoney.FTBMoney;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.ISingleLongValueTask;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class MoneyTask
extends Task
implements ISingleLongValueTask {
    public static TaskType TYPE;
    public long value = 1L;

    public MoneyTask(Quest quest) {
        super(quest);
    }

    public TaskType getType() {
        return TYPE;
    }

    public long getMaxProgress() {
        return this.value;
    }

    public String formatMaxProgress() {
        return FTBMoney.moneyString(this.value);
    }

    public String formatProgress(TeamData teamData, long progress) {
        return FTBMoney.moneyString(progress);
    }

    public void writeData(CompoundNBT nbt) {
        super.writeData(nbt);
        nbt.func_74772_a("value", this.value);
    }

    public void readData(CompoundNBT nbt) {
        super.readData(nbt);
        this.value = nbt.func_74763_f("value");
    }

    public void writeNetData(PacketBuffer buf) {
        super.writeNetData(buf);
        buf.func_179254_b(this.value);
    }

    public void readNetData(PacketBuffer buf) {
        super.readNetData(buf);
        this.value = buf.func_179260_f();
    }

    public void setValue(long v) {
        this.value = v;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addLong("value", this.value, v -> {
            this.value = v;
        }, 1L, 1L, Long.MAX_VALUE).setNameKey("ftbquests.task.ftbquests.ftb_money");
    }

    @OnlyIn(value=Dist.CLIENT)
    public ITextComponent getAltTitle() {
        return FTBMoney.moneyComponent(this.value);
    }

    public boolean consumesResources() {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void addMouseOverText(TooltipList list, TeamData teamData) {
        super.addMouseOverText(list, teamData);
        list.add((ITextComponent)new TranslationTextComponent("ftbmoney.balance").func_240702_b_(": ").func_230529_a_(FTBMoney.moneyComponent(FTBMoney.getClientMoney())).func_240699_a_(TextFormatting.GRAY));
    }

    public void submitTask(TeamData teamData, ServerPlayerEntity player, ItemStack craftedItem) {
        long money = FTBMoney.getMoney(player);
        long add = Math.min(money, this.value - teamData.getProgress((Task)this));
        if (add > 0L) {
            FTBMoney.setMoney(player, money - add);
            teamData.addProgress((Task)this, add);
        }
    }
}

