/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbmoney.integration;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftbmoney.FTBMoney;
import dev.ftb.mods.ftbquests.net.DisplayRewardToastMessage;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import dev.ftb.mods.ftbquests.quest.reward.RewardType;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class MoneyReward
extends Reward {
    public static RewardType TYPE;
    public long value = 1L;
    public int randomBonus = 0;

    public MoneyReward(Quest quest) {
        super(quest);
    }

    public RewardType getType() {
        return TYPE;
    }

    public void writeData(CompoundNBT nbt) {
        nbt.func_74772_a("ftb_money", this.value);
        if (this.randomBonus > 0) {
            nbt.func_74768_a("random_bonus", this.randomBonus);
        }
    }

    public void readData(CompoundNBT nbt) {
        this.value = nbt.func_74763_f("ftb_money");
        this.randomBonus = nbt.func_74762_e("random_bonus");
    }

    public void writeNetData(PacketBuffer buf) {
        super.writeNetData(buf);
        buf.func_179254_b(this.value);
        buf.func_150787_b(this.randomBonus);
    }

    public void readNetData(PacketBuffer buf) {
        super.readNetData(buf);
        this.value = buf.func_179260_f();
        this.randomBonus = buf.func_150792_a();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addLong("value", this.value, v -> {
            this.value = v;
        }, 1L, 1L, Long.MAX_VALUE).setNameKey("ftbquests.reward.ftbmoney.money");
        config.addInt("random_bonus", this.randomBonus, v -> {
            this.randomBonus = v;
        }, 0, 0, Integer.MAX_VALUE).setNameKey("ftbquests.reward.random_bonus");
    }

    public void claim(ServerPlayerEntity player, boolean notify) {
        long money = FTBMoney.getMoney(player);
        long added = this.value + (long)player.field_70170_p.field_73012_v.nextInt(this.randomBonus + 1);
        FTBMoney.setMoney(player, money + added);
        if (notify) {
            new DisplayRewardToastMessage(this.id, FTBMoney.moneyComponent(added), Icon.getIcon((String)"ftbmoney:textures/icon.png")).sendTo(player);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public ITextComponent getAltTitle() {
        if (this.randomBonus > 0) {
            return new StringTextComponent(FTBMoney.moneyString(this.value) + " - " + FTBMoney.moneyString(this.value + (long)this.randomBonus)).func_240699_a_(TextFormatting.GOLD);
        }
        return FTBMoney.moneyComponent(this.value);
    }

    @OnlyIn(value=Dist.CLIENT)
    public String getButtonText() {
        if (this.randomBonus > 0) {
            return this.randomBonus + "-" + Long.toUnsignedString(this.value + (long)this.randomBonus);
        }
        return Long.toUnsignedString(this.value);
    }
}

