/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbmoney.gui;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ui.EditConfigScreen;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftblibrary.ui.ContextMenuItem;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.WidgetType;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftbmoney.gui.ShopScreen;
import dev.ftb.mods.ftbmoney.net.EditShopTabMessage;
import dev.ftb.mods.ftbmoney.net.MoveShopTabMessage;
import dev.ftb.mods.ftbmoney.shop.Shop;
import dev.ftb.mods.ftbmoney.shop.ShopTab;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class TabButton
extends Button {
    public final ShopTab tab;

    public TabButton(Panel panel, ShopTab t) {
        super(panel, (ITextComponent)new StringTextComponent(t.title), ItemIcon.getItemIcon((ItemStack)t.icon));
        this.setSize(20, 20);
        this.tab = t;
    }

    public void onClicked(MouseButton button) {
        this.playClickSound();
        ShopScreen gui = (ShopScreen)this.getGui();
        if (button.isLeft()) {
            gui.selectedTab = this.tab;
            gui.refreshWidgets();
        } else if (button.isRight() && this.tab.shop.file.get().canEdit()) {
            ArrayList<ContextMenuItem> contextMenu = new ArrayList<ContextMenuItem>();
            contextMenu.add(new ContextMenuItem((ITextComponent)new TranslationTextComponent("selectServer.edit"), Icons.SETTINGS, () -> {
                ConfigGroup group = new ConfigGroup("ftbmoney").setNameKey("sidebar_button.ftbmoney.shop");
                ConfigGroup g = group.getGroup("shop").getGroup("tab");
                this.tab.getConfig(g);
                g.savedCallback = b -> {
                    this.openGui();
                    if (b) {
                        new EditShopTabMessage(this.tab, false).sendToServer();
                    }
                };
                new EditConfigScreen(group).openGui();
                gui.refreshWidgets();
            }));
            contextMenu.add(new ContextMenuItem((ITextComponent)new TranslationTextComponent("gui.move"), Icons.UP, () -> {
                new MoveShopTabMessage(this.tab, true).sendToServer();
                int id = this.tab.getIndex();
                if (id > 0) {
                    this.tab.shop.tabs.remove(id);
                    this.tab.shop.tabs.add(id - 1, this.tab);
                }
                gui.refreshWidgets();
            }));
            contextMenu.add(new ContextMenuItem((ITextComponent)new TranslationTextComponent("gui.move"), Icons.DOWN, () -> {
                new MoveShopTabMessage(this.tab, false).sendToServer();
                int id = this.tab.getIndex();
                if (id < this.tab.shop.tabs.size() - 1) {
                    this.tab.shop.tabs.remove(id);
                    this.tab.shop.tabs.add(id + 1, this.tab);
                }
                gui.refreshWidgets();
            }));
            contextMenu.add(new ContextMenuItem((ITextComponent)new TranslationTextComponent("selectServer.delete"), Icons.REMOVE, () -> gui.openYesNo((ITextComponent)new TranslationTextComponent("delete_item", new Object[]{this.tab.title}), StringTextComponent.field_240750_d_, () -> {
                new EditShopTabMessage(this.tab, true).sendToServer();
                this.tab.shop.tabs.remove(this.tab);
                if (gui.selectedTab == this.tab) {
                    gui.selectedTab = Shop.CLIENT.tabs.isEmpty() ? null : Shop.CLIENT.tabs.get(0);
                }
                gui.refreshWidgets();
            })));
            gui.openContextMenu(contextMenu);
        }
    }

    public WidgetType getWidgetType() {
        return ((ShopScreen)this.getGui()).selectedTab == this.tab ? WidgetType.MOUSE_OVER : super.getWidgetType();
    }
}

