/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbmoney;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.ftb.mods.ftbmoney.FTBMoney;
import dev.ftb.mods.ftbteams.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.data.PlayerTeam;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.command.arguments.GameProfileArgument;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class FTBMoneyCommands {
    public static void registerCommands(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"ftbmoney").then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"balance").executes(context -> FTBMoneyCommands.balance((CommandSource)context.getSource(), Collections.singleton(((CommandSource)context.getSource()).func_197035_h().func_146103_bH())))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"player", (ArgumentType)GameProfileArgument.func_197108_a()).requires(source -> source.func_197034_c(2))).executes(context -> FTBMoneyCommands.balance((CommandSource)context.getSource(), GameProfileArgument.func_197109_a((CommandContext)context, (String)"player")))))).then(Commands.func_197057_a((String)"pay").then(Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).then(Commands.func_197056_a((String)"money", (ArgumentType)LongArgumentType.longArg((long)1L)).executes(context -> FTBMoneyCommands.pay((CommandSource)context.getSource(), ((CommandSource)context.getSource()).func_197035_h(), EntityArgument.func_197089_d((CommandContext)context, (String)"player"), LongArgumentType.getLong((CommandContext)context, (String)"money"))))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"set").requires(source -> source.func_197034_c(2))).then(Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197094_d()).then(Commands.func_197056_a((String)"money", (ArgumentType)LongArgumentType.longArg((long)0L)).executes(context -> FTBMoneyCommands.set((CommandSource)context.getSource(), EntityArgument.func_197090_e((CommandContext)context, (String)"player"), LongArgumentType.getLong((CommandContext)context, (String)"money"))))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"add").requires(source -> source.func_197034_c(2))).then(Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197094_d()).then(Commands.func_197056_a((String)"money", (ArgumentType)LongArgumentType.longArg()).executes(context -> FTBMoneyCommands.add((CommandSource)context.getSource(), EntityArgument.func_197090_e((CommandContext)context, (String)"player"), LongArgumentType.getLong((CommandContext)context, (String)"money")))))));
    }

    private static int balance(CommandSource source, Collection<GameProfile> profiles) {
        for (GameProfile profile : profiles) {
            PlayerTeam team = FTBTeamsAPI.getManager().getInternalPlayerTeam(profile.getId());
            source.func_197030_a((ITextComponent)new StringTextComponent(profile.getName() + ": ").func_230529_a_(FTBMoney.moneyComponent(team.getExtraData().func_74763_f("Money"))), false);
        }
        return profiles.size();
    }

    private static int pay(CommandSource source, ServerPlayerEntity from, ServerPlayerEntity to, long money) {
        source.func_197021_a((ITextComponent)new StringTextComponent("WIP!"));
        return 1;
    }

    private static int set(CommandSource source, Collection<ServerPlayerEntity> players, long money) {
        for (ServerPlayerEntity player : players) {
            source.func_197030_a((ITextComponent)new StringTextComponent(player.func_195047_I_() + ": ").func_230529_a_(FTBMoney.moneyComponent(money)), false);
            FTBMoney.setMoney(player, money);
        }
        return players.size();
    }

    private static int add(CommandSource source, Collection<ServerPlayerEntity> players, long money) {
        if (money == 0L) {
            return 0;
        }
        for (ServerPlayerEntity player : players) {
            source.func_197030_a((ITextComponent)new StringTextComponent(player.func_195047_I_() + (money > 0L ? ": +" : ": -")).func_230529_a_(FTBMoney.moneyComponent(Math.abs(money))), false);
            FTBMoney.addMoney(player, money);
        }
        return players.size();
    }
}

