/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbmoney;

import com.mojang.brigadier.CommandDispatcher;
import dev.ftb.mods.ftblibrary.config.StringConfig;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.snbt.SNBT;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftbmoney.FTBMoneyClient;
import dev.ftb.mods.ftbmoney.FTBMoneyCommands;
import dev.ftb.mods.ftbmoney.FTBMoneyCommon;
import dev.ftb.mods.ftbmoney.integration.MoneyReward;
import dev.ftb.mods.ftbmoney.integration.MoneyTask;
import dev.ftb.mods.ftbmoney.net.FTBMoneyNetHandler;
import dev.ftb.mods.ftbmoney.net.SyncShopMessage;
import dev.ftb.mods.ftbmoney.net.UpdateMoneyMessage;
import dev.ftb.mods.ftbmoney.shop.Shop;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import dev.ftb.mods.ftbquests.quest.reward.RewardType;
import dev.ftb.mods.ftbquests.quest.reward.RewardTypes;
import dev.ftb.mods.ftbquests.quest.task.TaskTypes;
import dev.ftb.mods.ftbteams.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.data.ClientTeamManager;
import dev.ftb.mods.ftbteams.data.KnownClientPlayer;
import dev.ftb.mods.ftbteams.data.PlayerTeam;
import java.nio.file.Path;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="ftbmoney")
@Mod.EventBusSubscriber(modid="ftbmoney")
public class FTBMoney {
    public static final String MOD_ID = "ftbmoney";
    public static final Logger LOGGER = LogManager.getLogger((String)"FTB Money");

    public FTBMoney() {
        FTBMoneyNetHandler.init();
        ((FTBMoneyCommon)DistExecutor.safeRunForDist(() -> FTBMoneyClient::new, () -> FTBMoneyCommon::new)).preInit();
        MinecraftForge.EVENT_BUS.addListener(this::registerCommands);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
    }

    private void setup(FMLCommonSetupEvent event) {
        MoneyTask.TYPE = TaskTypes.register((ResourceLocation)new ResourceLocation(MOD_ID, "money"), MoneyTask::new, () -> Icon.getIcon((String)"ftbmoney:textures/icon.png"));
        MoneyReward.TYPE = RewardTypes.register((ResourceLocation)new ResourceLocation(MOD_ID, "money"), MoneyReward::new, () -> Icon.getIcon((String)"ftbmoney:textures/icon.png"));
        MoneyReward.TYPE.setGuiProvider(new RewardType.GuiProvider(){

            @OnlyIn(value=Dist.CLIENT)
            public void openCreationGui(Runnable gui, Quest quest, Consumer<Reward> callback) {
                StringConfig money = new StringConfig(Pattern.compile("^\\d+(?:-\\d+)?$"));
                money.onClicked(MouseButton.LEFT, set -> {
                    gui.run();
                    if (set) {
                        try {
                            long max;
                            String[] s = ((String)money.value).split("-", 2);
                            MoneyReward reward = new MoneyReward(quest);
                            reward.value = Long.parseLong(s[0].trim());
                            if (s.length == 2 && (max = Long.parseLong(s[1].trim())) - reward.value <= Integer.MAX_VALUE) {
                                reward.randomBonus = (int)(max - reward.value);
                            }
                            callback.accept(reward);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
            }
        });
    }

    public static Path getFile() {
        return FMLPaths.CONFIGDIR.get().resolve("ftbmoneyshop.snbt");
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onWorldLoaded(WorldEvent.Load event) {
        if (event.getWorld() instanceof World && !event.getWorld().func_201670_d() && ((World)event.getWorld()).func_234923_W_() == World.field_234918_g_) {
            Shop.SERVER = new Shop(() -> ServerQuestFile.INSTANCE);
            SNBTCompoundTag nbt = SNBT.read((Path)FTBMoney.getFile());
            if (nbt != null) {
                Shop.SERVER.deserializeNBT((CompoundNBT)nbt);
            }
        }
    }

    @SubscribeEvent
    public static void onWorldSaved(WorldEvent.Save event) {
        if (event.getWorld() instanceof World && Shop.SERVER != null && Shop.SERVER.shouldSave && !event.getWorld().func_201670_d() && ((World)event.getWorld()).func_234923_W_() == World.field_234918_g_) {
            Shop.SERVER.shouldSave = false;
            SNBT.write((Path)FTBMoney.getFile(), (CompoundNBT)Shop.SERVER.serializeNBT());
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getPlayer() instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)event.getPlayer();
            new SyncShopMessage((CompoundNBT)Shop.SERVER.serializeNBT()).sendTo(player);
        }
    }

    public static long getMoney(ServerPlayerEntity player) {
        PlayerTeam team = FTBTeamsAPI.getManager().getInternalPlayerTeam(player.func_110124_au());
        return team.getExtraData().func_74763_f("Money");
    }

    public static void setMoney(ServerPlayerEntity player, long money) {
        PlayerTeam team = FTBTeamsAPI.getManager().getInternalPlayerTeam(player.func_110124_au());
        if (money != team.getExtraData().func_74763_f("Money")) {
            team.getExtraData().func_74772_a("Money", money);
            team.save();
            new UpdateMoneyMessage(player.func_110124_au(), money).sendToAll(player.field_71133_b);
        }
    }

    public static void addMoney(ServerPlayerEntity player, long money) {
        PlayerTeam team = FTBTeamsAPI.getManager().getInternalPlayerTeam(player.func_110124_au());
        long balance = team.getExtraData().func_74763_f("Money");
        long current = balance + money;
        team.getExtraData().func_74772_a("Money", current);
        team.save();
        new UpdateMoneyMessage(player.func_110124_au(), current).sendToAll(player.field_71133_b);
    }

    public static long getMoney(KnownClientPlayer player) {
        return player.getExtraData().func_74763_f("Money");
    }

    public static void setMoney(KnownClientPlayer player, long money) {
        player.getExtraData().func_74772_a("Money", money);
    }

    public static void addMoney(KnownClientPlayer player, long money) {
        player.getExtraData().func_74772_a("Money", player.getExtraData().func_74763_f("Money") + money);
    }

    public static long getClientMoney() {
        return ClientTeamManager.INSTANCE.selfKnownPlayer.getExtraData().func_74763_f("Money");
    }

    private void registerCommands(RegisterCommandsEvent event) {
        FTBMoneyCommands.registerCommands((CommandDispatcher<CommandSource>)event.getDispatcher());
    }

    public static String moneyString(long money) {
        return String.format("\u25ce %,d", money);
    }

    public static ITextComponent moneyComponent(long money) {
        return new StringTextComponent(FTBMoney.moneyString(money)).func_240699_a_(TextFormatting.GOLD);
    }
}

