/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.networking;

import com.simibubi.create.foundation.networking.SimplePacketBase;
import com.simibubi.create.foundation.tileEntity.SyncedTileEntity;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;

public abstract class TileEntityDataPacket<TE extends SyncedTileEntity>
extends SimplePacketBase {
    protected BlockPos tilePos;

    public TileEntityDataPacket(PacketBuffer buffer) {
        this.tilePos = buffer.func_179259_c();
    }

    public TileEntityDataPacket(BlockPos pos) {
        this.tilePos = pos;
    }

    @Override
    public void write(PacketBuffer buffer) {
        buffer.func_179255_a(this.tilePos);
        this.writeData(buffer);
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> {
            ClientWorld world = Minecraft.func_71410_x().field_71441_e;
            if (world == null) {
                return;
            }
            TileEntity tile = world.func_175625_s(this.tilePos);
            if (tile instanceof SyncedTileEntity) {
                this.handlePacket((SyncedTileEntity)tile);
            }
        });
        ctx.setPacketHandled(true);
    }

    protected abstract void writeData(PacketBuffer var1);

    protected abstract void handlePacket(TE var1);
}

