/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.config;

import com.simibubi.create.foundation.config.AllConfigs;
import java.util.Collection;
import java.util.HashMap;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraftforge.common.extensions.IForgeBlock;

public enum ContraptionMovementSetting {
    MOVABLE,
    NO_PICKUP,
    UNMOVABLE;

    private static HashMap<ResourceLocation, Supplier<ContraptionMovementSetting>> registry;

    public static void register(ResourceLocation id, Supplier<ContraptionMovementSetting> setting) {
        registry.put(id, setting);
    }

    @Nullable
    public static ContraptionMovementSetting get(Block block) {
        if (block instanceof IMovementSettingProvider) {
            return ((IMovementSettingProvider)block).getContraptionMovementSetting();
        }
        return ContraptionMovementSetting.get(block.getRegistryName());
    }

    @Nullable
    public static ContraptionMovementSetting get(ResourceLocation id) {
        Supplier<ContraptionMovementSetting> supplier = registry.get(id);
        return supplier == null ? null : supplier.get();
    }

    protected static boolean allAre(Collection<Template.BlockInfo> blocks, ContraptionMovementSetting are) {
        return blocks.stream().anyMatch(b -> ContraptionMovementSetting.get(b.field_186243_b.func_177230_c()) == are);
    }

    public static boolean isNoPickup(Collection<Template.BlockInfo> blocks) {
        return ContraptionMovementSetting.allAre(blocks, NO_PICKUP);
    }

    static {
        registry = new HashMap();
        ContraptionMovementSetting.register(Blocks.field_150474_ac.getRegistryName(), () -> (ContraptionMovementSetting)((Object)((Object)AllConfigs.SERVER.kinetics.spawnerMovement.get())));
        ContraptionMovementSetting.register(Blocks.field_150343_Z.getRegistryName(), () -> (ContraptionMovementSetting)((Object)((Object)AllConfigs.SERVER.kinetics.obsidianMovement.get())));
        ContraptionMovementSetting.register(Blocks.field_235399_ni_.getRegistryName(), () -> (ContraptionMovementSetting)((Object)((Object)AllConfigs.SERVER.kinetics.obsidianMovement.get())));
    }

    public static interface IMovementSettingProvider
    extends IForgeBlock {
        public ContraptionMovementSetting getContraptionMovementSetting();
    }
}

