/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.gui.widgets;

import com.simibubi.create.AllKeys;
import com.simibubi.create.foundation.gui.widgets.AbstractSimiWidget;
import com.simibubi.create.foundation.gui.widgets.Label;
import com.simibubi.create.foundation.tileEntity.behaviour.scrollvalue.ScrollValueBehaviour;
import com.simibubi.create.foundation.utility.Lang;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;

public class ScrollInput
extends AbstractSimiWidget {
    protected Consumer<Integer> onScroll;
    protected int state = 0;
    protected ITextComponent title = Lang.translate("gui.scrollInput.defaultTitle", new Object[0]);
    protected final ITextComponent scrollToModify = Lang.translate("gui.scrollInput.scrollToModify", new Object[0]);
    protected final ITextComponent shiftScrollsFaster = Lang.translate("gui.scrollInput.shiftScrollsFaster", new Object[0]);
    protected Label displayLabel;
    protected int min = 0;
    protected int max = 1;
    protected int shiftStep = 5;
    Function<ScrollValueBehaviour.StepContext, Integer> step = this.standardStep();

    public ScrollInput(int xIn, int yIn, int widthIn, int heightIn) {
        super(xIn, yIn, widthIn, heightIn);
    }

    public Function<ScrollValueBehaviour.StepContext, Integer> standardStep() {
        return c -> c.shift ? this.shiftStep : 1;
    }

    public ScrollInput withRange(int min, int max) {
        this.min = min;
        this.max = max;
        return this;
    }

    public ScrollInput calling(Consumer<Integer> onScroll) {
        this.onScroll = onScroll;
        return this;
    }

    public ScrollInput removeCallback() {
        this.onScroll = null;
        return this;
    }

    public ScrollInput titled(IFormattableTextComponent title) {
        this.title = title;
        this.updateTooltip();
        return this;
    }

    public ScrollInput withStepFunction(Function<ScrollValueBehaviour.StepContext, Integer> step) {
        this.step = step;
        return this;
    }

    public ScrollInput writingTo(Label label) {
        this.displayLabel = label;
        this.writeToLabel();
        return this;
    }

    public int getState() {
        return this.state;
    }

    public ScrollInput setState(int state) {
        this.state = state;
        this.clampState();
        this.updateTooltip();
        if (this.displayLabel != null) {
            this.writeToLabel();
        }
        return this;
    }

    public ScrollInput withShiftStep(int step) {
        this.shiftStep = step;
        return this;
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double delta) {
        if (!this.field_230692_n_) {
            return false;
        }
        ScrollValueBehaviour.StepContext context = new ScrollValueBehaviour.StepContext();
        context.control = AllKeys.ctrlDown();
        context.shift = AllKeys.shiftDown();
        context.currentValue = this.state;
        context.forward = delta > 0.0;
        int priorState = this.state;
        boolean shifted = AllKeys.shiftDown();
        int step = (int)Math.signum(delta) * this.step.apply(context);
        this.state += step;
        if (shifted) {
            this.state -= this.state % this.shiftStep;
        }
        this.clampState();
        if (priorState != this.state) {
            this.onChanged();
        }
        return priorState != this.state;
    }

    protected void clampState() {
        if (this.state >= this.max) {
            this.state = this.max - 1;
        }
        if (this.state < this.min) {
            this.state = this.min;
        }
    }

    public void onChanged() {
        if (this.displayLabel != null) {
            this.writeToLabel();
        }
        if (this.onScroll != null) {
            this.onScroll.accept(this.state);
        }
        this.updateTooltip();
    }

    protected void writeToLabel() {
        this.displayLabel.text = new StringTextComponent(String.valueOf(this.state));
    }

    protected void updateTooltip() {
        this.toolTip.clear();
        this.toolTip.add(this.title.func_230531_f_().func_240699_a_(TextFormatting.BLUE));
        this.toolTip.add(this.scrollToModify.func_230531_f_().func_240701_a_(new TextFormatting[]{TextFormatting.ITALIC, TextFormatting.DARK_GRAY}));
        this.toolTip.add(this.shiftScrollsFaster.func_230531_f_().func_240701_a_(new TextFormatting[]{TextFormatting.ITALIC, TextFormatting.DARK_GRAY}));
    }
}

