/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.redstone;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllShapes;
import com.simibubi.create.AllTileEntities;
import com.simibubi.create.content.contraptions.wrench.IWrenchable;
import com.simibubi.create.content.logistics.block.redstone.NixieTubeTileEntity;
import com.simibubi.create.content.schematics.ISpecialBlockItemRequirement;
import com.simibubi.create.content.schematics.ItemRequirement;
import com.simibubi.create.foundation.block.ITE;
import com.simibubi.create.foundation.utility.Iterate;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class NixieTubeBlock
extends HorizontalBlock
implements ITE<NixieTubeTileEntity>,
IWrenchable,
ISpecialBlockItemRequirement {
    public static final BooleanProperty CEILING = BooleanProperty.func_177716_a((String)"ceiling");
    protected final DyeColor color;

    public NixieTubeBlock(AbstractBlock.Properties properties, DyeColor color) {
        super(properties);
        this.color = color;
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)CEILING, (Comparable)Boolean.valueOf(false)));
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult ray) {
        BlockPos nextPos;
        if (player.func_225608_bj_()) {
            return ActionResultType.PASS;
        }
        ItemStack heldItem = player.func_184586_b(hand);
        NixieTubeTileEntity nixie = (NixieTubeTileEntity)this.getTileEntity((IBlockReader)world, pos);
        if (nixie == null) {
            return ActionResultType.PASS;
        }
        if (heldItem.func_190926_b()) {
            if (nixie.reactsToRedstone()) {
                return ActionResultType.PASS;
            }
            nixie.clearCustomText();
            this.updateDisplayedRedstoneValue(state, world, pos);
            return ActionResultType.SUCCESS;
        }
        boolean display = heldItem.func_77973_b() == Items.field_151057_cb && heldItem.func_82837_s();
        DyeColor dye = DyeColor.getColor((ItemStack)heldItem);
        if (!display && dye == null) {
            return ActionResultType.PASS;
        }
        Direction left = ((Direction)state.func_177229_b((Property)field_185512_D)).func_176746_e();
        Direction right = left.func_176734_d();
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        BlockPos currentPos = pos;
        while (NixieTubeBlock.areNixieBlocksEqual(world.func_180495_p(nextPos = currentPos.func_177972_a(left)), state)) {
            currentPos = nextPos;
        }
        int index = 0;
        while (true) {
            BlockPos nextPos2;
            int rowPosition = ++index;
            if (display) {
                this.withTileEntityDo((IBlockReader)world, currentPos, te -> te.displayCustomNameOf(heldItem, rowPosition));
            }
            if (dye != null) {
                world.func_175656_a(currentPos, NixieTubeBlock.withColor(state, dye));
            }
            if (!NixieTubeBlock.areNixieBlocksEqual(world.func_180495_p(nextPos2 = currentPos.func_177972_a(right)), state)) break;
            currentPos = nextPos2;
        }
        return ActionResultType.SUCCESS;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder.func_206894_a(new Property[]{CEILING, field_185512_D}));
    }

    public void func_196243_a(BlockState p_196243_1_, World p_196243_2_, BlockPos p_196243_3_, BlockState p_196243_4_, boolean p_196243_5_) {
        if (!(p_196243_4_.func_177230_c() instanceof NixieTubeBlock)) {
            p_196243_2_.func_175713_t(p_196243_3_);
        }
    }

    public ItemStack func_185473_a(IBlockReader p_185473_1_, BlockPos p_185473_2_, BlockState p_185473_3_) {
        return AllBlocks.ORANGE_NIXIE_TUBE.asStack();
    }

    @Override
    public ItemRequirement getRequiredItems(BlockState state, TileEntity te) {
        return new ItemRequirement(ItemRequirement.ItemUseType.CONSUME, ((NixieTubeBlock)AllBlocks.ORANGE_NIXIE_TUBE.get()).func_199767_j());
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader p_220053_2_, BlockPos p_220053_3_, ISelectionContext p_220053_4_) {
        return ((Boolean)state.func_177229_b((Property)CEILING) != false ? AllShapes.NIXIE_TUBE_CEILING : AllShapes.NIXIE_TUBE).get(((Direction)state.func_177229_b((Property)field_185512_D)).func_176740_k());
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        if (this.color != DyeColor.ORANGE) {
            return ((NixieTubeBlock)AllBlocks.ORANGE_NIXIE_TUBE.get()).getPickBlock(state, target, world, pos, player);
        }
        return super.getPickBlock(state, target, world, pos, player);
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockPos pos = context.func_195995_a();
        boolean ceiling = context.func_196000_l() == Direction.DOWN;
        Vector3d hitVec = context.func_221532_j();
        if (hitVec != null) {
            ceiling = hitVec.field_72448_b - (double)pos.func_177956_o() > 0.5;
        }
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)field_185512_D, (Comparable)context.func_195992_f().func_176734_d())).func_206870_a((Property)CEILING, (Comparable)Boolean.valueOf(ceiling));
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block p_220069_4_, BlockPos p_220069_5_, boolean p_220069_6_) {
        if (worldIn.field_72995_K) {
            return;
        }
        if (!worldIn.func_205220_G_().func_205361_b(pos, (Object)this)) {
            worldIn.func_205220_G_().func_205360_a(pos, (Object)this, 0);
        }
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random r) {
        this.updateDisplayedRedstoneValue(state, (World)worldIn, pos);
    }

    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (state.func_177230_c() == oldState.func_177230_c() || isMoving) {
            return;
        }
        this.updateDisplayedRedstoneValue(state, worldIn, pos);
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new NixieTubeTileEntity((TileEntityType)AllTileEntities.NIXIE_TUBE.get());
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    private void updateDisplayedRedstoneValue(BlockState state, World worldIn, BlockPos pos) {
        if (worldIn.field_72995_K) {
            return;
        }
        this.withTileEntityDo((IBlockReader)worldIn, pos, te -> {
            if (te.reactsToRedstone()) {
                te.updateRedstoneStrength(this.getPower(worldIn, pos));
            }
        });
    }

    static boolean isValidBlock(IBlockReader world, BlockPos pos, boolean above) {
        BlockState state = world.func_180495_p(pos.func_177981_b(above ? 1 : -1));
        return !state.func_196954_c(world, pos).func_197766_b();
    }

    private int getPower(World worldIn, BlockPos pos) {
        int power = 0;
        for (Direction direction : Iterate.directions) {
            power = Math.max(worldIn.func_175651_c(pos.func_177972_a(direction), direction), power);
        }
        for (Direction direction : Iterate.directions) {
            power = Math.max(worldIn.func_175651_c(pos.func_177972_a(direction), Direction.UP), power);
        }
        return power;
    }

    public boolean func_196266_a(BlockState state, IBlockReader reader, BlockPos pos, PathType type) {
        return false;
    }

    public boolean canConnectRedstone(BlockState state, IBlockReader world, BlockPos pos, Direction side) {
        return side != null;
    }

    @Override
    public Class<NixieTubeTileEntity> getTileEntityClass() {
        return NixieTubeTileEntity.class;
    }

    public DyeColor getColor() {
        return this.color;
    }

    public static boolean areNixieBlocksEqual(BlockState blockState, BlockState otherState) {
        if (!(blockState.func_177230_c() instanceof NixieTubeBlock)) {
            return false;
        }
        if (!(otherState.func_177230_c() instanceof NixieTubeBlock)) {
            return false;
        }
        return NixieTubeBlock.withColor(blockState, DyeColor.WHITE) == NixieTubeBlock.withColor(otherState, DyeColor.WHITE);
    }

    public static BlockState withColor(BlockState state, DyeColor color) {
        return (BlockState)((BlockState)(color == DyeColor.ORANGE ? AllBlocks.ORANGE_NIXIE_TUBE : AllBlocks.NIXIE_TUBES.get(color)).getDefaultState().func_206870_a((Property)field_185512_D, state.func_177229_b((Property)field_185512_D))).func_206870_a((Property)CEILING, state.func_177229_b((Property)CEILING));
    }

    public static DyeColor colorOf(BlockState blockState) {
        return blockState.func_177230_c() instanceof NixieTubeBlock ? ((NixieTubeBlock)blockState.func_177230_c()).color : DyeColor.ORANGE;
    }
}

