/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.relays.elementary;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllShapes;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.base.RotatedPillarKineticBlock;
import com.simibubi.create.content.contraptions.relays.elementary.AbstractShaftBlock;
import com.simibubi.create.content.contraptions.relays.encased.EncasedShaftBlock;
import com.simibubi.create.foundation.advancement.AllTriggers;
import com.simibubi.create.foundation.utility.placement.IPlacementHelper;
import com.simibubi.create.foundation.utility.placement.PlacementHelpers;
import com.simibubi.create.foundation.utility.placement.util.PoleHelper;
import java.util.function.Predicate;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class ShaftBlock
extends AbstractShaftBlock {
    private static final int placementHelperId = PlacementHelpers.register(new PlacementHelper());

    public ShaftBlock(AbstractBlock.Properties properties) {
        super(properties);
    }

    public static boolean isShaft(BlockState state) {
        return AllBlocks.SHAFT.has(state);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return AllShapes.SIX_VOXEL_POLE.get((Direction.Axis)state.func_177229_b((Property)AXIS));
    }

    @Override
    public float getParticleTargetRadius() {
        return 0.35f;
    }

    @Override
    public float getParticleInitialRadius() {
        return 0.125f;
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult ray) {
        if (player.func_225608_bj_() || !player.func_175142_cm()) {
            return ActionResultType.PASS;
        }
        ItemStack heldItem = player.func_184586_b(hand);
        for (EncasedShaftBlock encasedShaft : new EncasedShaftBlock[]{(EncasedShaftBlock)AllBlocks.ANDESITE_ENCASED_SHAFT.get(), (EncasedShaftBlock)AllBlocks.BRASS_ENCASED_SHAFT.get()}) {
            if (!encasedShaft.getCasing().isIn(heldItem)) continue;
            if (world.field_72995_K) {
                return ActionResultType.SUCCESS;
            }
            AllTriggers.triggerFor(AllTriggers.CASING_SHAFT, player);
            KineticTileEntity.switchToBlockState(world, pos, (BlockState)encasedShaft.func_176223_P().func_206870_a((Property)AXIS, state.func_177229_b((Property)AXIS)));
            return ActionResultType.SUCCESS;
        }
        IPlacementHelper helper = PlacementHelpers.get(placementHelperId);
        if (helper.matchesItem(heldItem)) {
            return helper.getOffset(player, world, state, pos, ray).placeInWorld(world, (BlockItem)heldItem.func_77973_b(), player, hand, ray);
        }
        return ActionResultType.PASS;
    }

    @MethodsReturnNonnullByDefault
    private static class PlacementHelper
    extends PoleHelper<Direction.Axis> {
        private PlacementHelper() {
            super(state -> state.func_177230_c() instanceof AbstractShaftBlock, state -> (Direction.Axis)state.func_177229_b(RotatedPillarKineticBlock.AXIS), RotatedPillarKineticBlock.AXIS);
        }

        @Override
        public Predicate<ItemStack> getItemPredicate() {
            return i -> i.func_77973_b() instanceof BlockItem && ((BlockItem)i.func_77973_b()).func_179223_d() instanceof AbstractShaftBlock;
        }

        @Override
        public Predicate<BlockState> getStatePredicate() {
            return AllBlocks.SHAFT::has;
        }
    }
}

