/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.sync;

import com.simibubi.create.content.contraptions.components.structureMovement.AbstractContraptionEntity;
import com.simibubi.create.foundation.networking.SimplePacketBase;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.network.NetworkEvent;

public class ContraptionFluidPacket
extends SimplePacketBase {
    private int entityId;
    private BlockPos localPos;
    private FluidStack containedFluid;

    public ContraptionFluidPacket(int entityId, BlockPos localPos, FluidStack containedFluid) {
        this.entityId = entityId;
        this.localPos = localPos;
        this.containedFluid = containedFluid;
    }

    public ContraptionFluidPacket(PacketBuffer buffer) {
        this.entityId = buffer.readInt();
        this.localPos = buffer.func_179259_c();
        this.containedFluid = FluidStack.readFromPacket((PacketBuffer)buffer);
    }

    @Override
    public void write(PacketBuffer buffer) {
        buffer.writeInt(this.entityId);
        buffer.func_179255_a(this.localPos);
        this.containedFluid.writeToPacket(buffer);
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            Entity entityByID = Minecraft.func_71410_x().field_71441_e.func_73045_a(this.entityId);
            if (!(entityByID instanceof AbstractContraptionEntity)) {
                return;
            }
            AbstractContraptionEntity contraptionEntity = (AbstractContraptionEntity)entityByID;
            contraptionEntity.getContraption().updateContainedFluid(this.localPos, this.containedFluid);
        });
        context.get().setPacketHandled(true);
    }
}

