/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity.ai;

import com.github.alexthe666.iceandfire.entity.EntityHippogryph;
import com.github.alexthe666.iceandfire.entity.ai.DragonAITargetItems;
import com.github.alexthe666.iceandfire.util.IAFMath;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.TargetGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Items;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;

public class HippogryphAITargetItems<T extends ItemEntity>
extends TargetGoal {
    protected final DragonAITargetItems.Sorter theNearestAttackableTargetSorter;
    protected final Predicate<? super ItemEntity> targetEntitySelector;
    protected ItemEntity targetEntity;
    protected final int targetChance;
    @Nonnull
    private List<ItemEntity> list = IAFMath.emptyItemEntityList;

    public HippogryphAITargetItems(MobEntity creature, boolean checkSight) {
        this(creature, checkSight, false);
    }

    public HippogryphAITargetItems(MobEntity creature, boolean checkSight, boolean onlyNearby) {
        this(creature, 20, checkSight, onlyNearby, null);
    }

    public HippogryphAITargetItems(MobEntity creature, int chance, boolean checkSight, boolean onlyNearby, @Nullable Predicate<? super T> targetSelector) {
        super(creature, checkSight, onlyNearby);
        this.theNearestAttackableTargetSorter = new DragonAITargetItems.Sorter((Entity)creature);
        this.targetChance = chance;
        this.targetEntitySelector = new Predicate<ItemEntity>(){

            @Override
            public boolean test(ItemEntity item) {
                return item != null && !item.func_92059_d().func_190926_b() && item.func_92059_d().func_77973_b() == Items.field_179556_br;
            }
        };
    }

    public boolean func_75250_a() {
        if (this.targetChance > 0 && this.field_75299_d.func_70681_au().nextInt(this.targetChance) != 0) {
            return false;
        }
        if (!((EntityHippogryph)this.field_75299_d).canMove()) {
            this.list = IAFMath.emptyItemEntityList;
            return false;
        }
        if (this.field_75299_d.field_70170_p.func_82737_E() % 4L == 0L) {
            this.list = this.field_75299_d.field_70170_p.func_175647_a(ItemEntity.class, this.getTargetableArea(this.func_111175_f()), this.targetEntitySelector);
        }
        if (this.list.isEmpty()) {
            return false;
        }
        this.list.sort(this.theNearestAttackableTargetSorter);
        this.targetEntity = this.list.get(0);
        return true;
    }

    protected AxisAlignedBB getTargetableArea(double targetDistance) {
        return this.field_75299_d.func_174813_aQ().func_72314_b(targetDistance, 4.0, targetDistance);
    }

    public void func_75249_e() {
        this.field_75299_d.func_70661_as().func_75492_a(this.targetEntity.func_226277_ct_(), this.targetEntity.func_226278_cu_(), this.targetEntity.func_226281_cx_(), 1.0);
        super.func_75249_e();
    }

    public void func_75246_d() {
        super.func_75246_d();
        if (this.targetEntity == null || !this.targetEntity.func_70089_S()) {
            this.func_75251_c();
        } else if (this.getAttackReachSqr((Entity)this.targetEntity) >= this.field_75299_d.func_70068_e((Entity)this.targetEntity)) {
            PlayerEntity owner;
            EntityHippogryph hippo = (EntityHippogryph)this.field_75299_d;
            this.targetEntity.func_92059_d().func_190918_g(1);
            this.field_75299_d.func_184185_a(SoundEvents.field_187537_bA, 1.0f, 1.0f);
            hippo.setAnimation(EntityHippogryph.ANIMATION_EAT);
            ++hippo.feedings;
            hippo.func_70691_i(4.0f);
            if (!(hippo.feedings <= 3 || hippo.feedings <= 7 && hippo.func_70681_au().nextInt(3) != 0 || hippo.func_70909_n() || this.targetEntity.func_200214_m() == null || this.field_75299_d.field_70170_p.func_217371_b(this.targetEntity.func_200214_m()) == null || (owner = this.field_75299_d.field_70170_p.func_217371_b(this.targetEntity.func_200214_m())) == null)) {
                hippo.func_193101_c(owner);
                hippo.func_70624_b(null);
                hippo.setCommand(1);
                hippo.func_233687_w_(true);
            }
            this.func_75251_c();
        }
    }

    public boolean func_75253_b() {
        return !this.field_75299_d.func_70661_as().func_75500_f();
    }

    protected double getAttackReachSqr(Entity attackTarget) {
        return this.field_75299_d.func_213311_cf() * 2.0f * this.field_75299_d.func_213311_cf() * 2.0f + attackTarget.func_213311_cf();
    }

    public static class Sorter
    implements Comparator<Entity> {
        private final Entity theEntity;

        public Sorter(Entity theEntityIn) {
            this.theEntity = theEntityIn;
        }

        @Override
        public int compare(Entity p_compare_1_, Entity p_compare_2_) {
            double d0 = this.theEntity.func_70068_e(p_compare_1_);
            double d1 = this.theEntity.func_70068_e(p_compare_2_);
            return Double.compare(d0, d1);
        }
    }
}

