/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity.ai;

import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.github.alexthe666.iceandfire.entity.util.DragonUtils;
import java.util.EnumSet;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;

public class DragonAIReturnToRoost
extends Goal {
    private final EntityDragonBase dragon;

    public DragonAIReturnToRoost(EntityDragonBase entityIn, double movementSpeedIn) {
        this.dragon = entityIn;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean func_75250_a() {
        return this.dragon.canMove() && this.dragon.lookingForRoostAIFlag && (this.dragon.func_70638_az() == null || !this.dragon.func_70638_az().func_70089_S()) && this.dragon.func_213384_dI() != null && DragonUtils.isInHomeDimension(this.dragon) && this.dragon.getDistanceSquared(Vector3d.func_237489_a_((Vector3i)this.dragon.func_213384_dI())) > this.dragon.func_213311_cf() * this.dragon.func_213311_cf();
    }

    public void func_75246_d() {
        if (this.dragon.func_213384_dI() != null) {
            double dist = Math.sqrt(this.dragon.getDistanceSquared(Vector3d.func_237489_a_((Vector3i)this.dragon.func_213384_dI())));
            double xDist = Math.abs(this.dragon.func_226277_ct_() - (double)this.dragon.func_213384_dI().func_177958_n() - 0.5);
            double zDist = Math.abs(this.dragon.func_226281_cx_() - (double)this.dragon.func_213384_dI().func_177952_p() - 0.5);
            double xzDist = Math.sqrt(xDist * xDist + zDist * zDist);
            if (dist < (double)this.dragon.func_213311_cf()) {
                this.dragon.setFlying(false);
                this.dragon.setHovering(false);
                this.dragon.func_70661_as().func_75492_a((double)this.dragon.func_213384_dI().func_177958_n(), (double)this.dragon.func_213384_dI().func_177956_o(), (double)this.dragon.func_213384_dI().func_177952_p(), 1.0);
            } else {
                double yAddition = 15 + this.dragon.func_70681_au().nextInt(3);
                if (xzDist < 40.0) {
                    yAddition = 0.0;
                    if (this.dragon.func_233570_aj_()) {
                        this.dragon.setFlying(false);
                        this.dragon.setHovering(false);
                        this.dragon.flightManager.setFlightTarget(Vector3d.func_237490_a_((Vector3i)this.dragon.func_213384_dI(), (double)yAddition));
                        this.dragon.func_70661_as().func_75492_a((double)this.dragon.func_213384_dI().func_177958_n(), (double)this.dragon.func_213384_dI().func_177956_o(), (double)this.dragon.func_213384_dI().func_177952_p(), 1.0);
                        return;
                    }
                }
                if (!this.dragon.isFlying() && !this.dragon.isHovering() && xzDist > 40.0) {
                    this.dragon.setHovering(true);
                }
                if (this.dragon.isFlying()) {
                    this.dragon.flightManager.setFlightTarget(Vector3d.func_237490_a_((Vector3i)this.dragon.func_213384_dI(), (double)yAddition));
                    this.dragon.func_70661_as().func_75492_a((double)this.dragon.func_213384_dI().func_177958_n(), yAddition + (double)this.dragon.func_213384_dI().func_177956_o(), (double)this.dragon.func_213384_dI().func_177952_p(), 1.0);
                }
                this.dragon.flyTicks = 0;
            }
        }
    }

    public boolean func_75253_b() {
        return this.func_75250_a();
    }
}

