/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.client.render.entity;

import com.github.alexthe666.iceandfire.client.model.ModelHippogryph;
import com.github.alexthe666.iceandfire.entity.EntityHippogryph;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.ResourceLocation;

public class RenderHippogryph
extends MobRenderer<EntityHippogryph, ModelHippogryph> {
    public RenderHippogryph(EntityRendererManager renderManager) {
        super(renderManager, (EntityModel)new ModelHippogryph(), 0.8f);
        this.field_177097_h.add(new LayerHippogriffSaddle(this));
    }

    protected void preRenderCallback(EntityHippogryph entity, MatrixStack matrix, float partialTickTime) {
        matrix.func_227862_a_(1.2f, 1.2f, 1.2f);
    }

    @Nullable
    public ResourceLocation getEntityTexture(EntityHippogryph entity) {
        return entity.isBlinking() ? entity.getEnumVariant().TEXTURE_BLINK : entity.getEnumVariant().TEXTURE;
    }

    private class LayerHippogriffSaddle
    extends LayerRenderer<EntityHippogryph, ModelHippogryph> {
        private final RenderHippogryph renderer;
        private final RenderType SADDLE_TEXTURE;
        private final RenderType BRIDLE;
        private final RenderType CHEST;
        private final RenderType TEXTURE_DIAMOND;
        private final RenderType TEXTURE_GOLD;
        private final RenderType TEXTURE_IRON;

        public LayerHippogriffSaddle(RenderHippogryph renderer) {
            super((IEntityRenderer)renderer);
            this.SADDLE_TEXTURE = RenderType.func_228650_h_((ResourceLocation)new ResourceLocation("iceandfire:textures/models/hippogryph/saddle.png"));
            this.BRIDLE = RenderType.func_228650_h_((ResourceLocation)new ResourceLocation("iceandfire:textures/models/hippogryph/bridle.png"));
            this.CHEST = RenderType.func_228644_e_((ResourceLocation)new ResourceLocation("iceandfire:textures/models/hippogryph/chest.png"));
            this.TEXTURE_DIAMOND = RenderType.func_228650_h_((ResourceLocation)new ResourceLocation("iceandfire:textures/models/hippogryph/armor_diamond.png"));
            this.TEXTURE_GOLD = RenderType.func_228650_h_((ResourceLocation)new ResourceLocation("iceandfire:textures/models/hippogryph/armor_gold.png"));
            this.TEXTURE_IRON = RenderType.func_228650_h_((ResourceLocation)new ResourceLocation("iceandfire:textures/models/hippogryph/armor_iron.png"));
            this.renderer = renderer;
        }

        public void render(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, EntityHippogryph hippo, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            IVertexBuilder ivertexbuilder;
            if (hippo.getArmor() != 0) {
                RenderType type = null;
                switch (hippo.getArmor()) {
                    case 1: {
                        type = this.TEXTURE_IRON;
                        break;
                    }
                    case 2: {
                        type = this.TEXTURE_GOLD;
                        break;
                    }
                    case 3: {
                        type = this.TEXTURE_DIAMOND;
                    }
                }
                IVertexBuilder ivertexbuilder2 = bufferIn.getBuffer(type);
                ((ModelHippogryph)this.func_215332_c()).func_225598_a_(matrixStackIn, ivertexbuilder2, packedLightIn, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
            }
            if (hippo.isSaddled()) {
                ivertexbuilder = bufferIn.getBuffer(this.SADDLE_TEXTURE);
                ((ModelHippogryph)this.func_215332_c()).func_225598_a_(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
            }
            if (hippo.isSaddled() && hippo.func_184179_bs() != null) {
                ivertexbuilder = bufferIn.getBuffer(this.BRIDLE);
                ((ModelHippogryph)this.func_215332_c()).func_225598_a_(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
            }
            if (hippo.isChested()) {
                ivertexbuilder = bufferIn.getBuffer(this.CHEST);
                ((ModelHippogryph)this.func_215332_c()).func_225598_a_(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
            }
        }
    }
}

