/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.settings;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.item.DyeColor;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.controls.ButtonBase;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.Dimension;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.GuiHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.Position;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.TranslationHelper;

public class ColorToggleButton
extends ButtonBase {
    private static final DyeColor[] DYE_VALUES = DyeColor.values();
    private static final List<ITextProperties> TOOLTIP = new ImmutableList.Builder().add((Object)new TranslationTextComponent(TranslationHelper.translSettingsButton("toggle_color"))).addAll(TranslationHelper.getTranslatedLines(TranslationHelper.translSettingsButton("toggle_color_detail"), null, TextFormatting.GRAY)).build();
    private final Supplier<DyeColor> getColor;
    private final Consumer<DyeColor> setColor;

    public ColorToggleButton(Position position, Supplier<DyeColor> getColor, Consumer<DyeColor> setColor) {
        super(position, Dimension.SQUARE_18, (int b) -> {});
        this.getColor = getColor;
        this.setColor = setColor;
        this.setOnClick(this::onClick);
    }

    private void onClick(int button) {
        this.toggleColor(button);
    }

    private void toggleColor(int button) {
        if (button == 0) {
            this.setColor.accept(this.nextColor(this.getColor.get()));
        } else if (button == 1) {
            this.setColor.accept(this.previousColor(this.getColor.get()));
        }
    }

    private DyeColor nextColor(DyeColor color) {
        return DYE_VALUES[(color.ordinal() + 1) % DYE_VALUES.length];
    }

    private DyeColor previousColor(DyeColor color) {
        return DYE_VALUES[(color.ordinal() - 1 + DYE_VALUES.length) % DYE_VALUES.length];
    }

    @Override
    protected void renderBg(MatrixStack matrixStack, Minecraft minecraft, int mouseX, int mouseY) {
        if (this.func_231047_b_(mouseX, mouseY)) {
            GuiHelper.blit(minecraft, matrixStack, this.x, this.y, GuiHelper.DEFAULT_BUTTON_HOVERED_BACKGROUND);
        } else {
            GuiHelper.blit(minecraft, matrixStack, this.x, this.y, GuiHelper.DEFAULT_BUTTON_BACKGROUND);
        }
    }

    @Override
    protected void renderWidget(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.disableDepthTest();
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        int color = this.getColor.get().getColorValue() | 0xC8000000;
        this.func_238468_a_(matrixStack, this.x + 3, this.y + 3, this.x + 15, this.y + 15, color, color);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.enableDepthTest();
        if (this.func_231047_b_(mouseX, mouseY)) {
            GuiHelper.setTooltipToRender(TOOLTIP);
        }
    }
}

