/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.network;

import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackStorage;
import net.p3pp3rf1y.sophisticatedbackpacks.network.BackpackContentsMessage;
import net.p3pp3rf1y.sophisticatedbackpacks.network.PacketHandler;

public class RequestBackpackInventoryContentsMessage {
    private final UUID backpackUuid;

    public RequestBackpackInventoryContentsMessage(UUID backpackUuid) {
        this.backpackUuid = backpackUuid;
    }

    public static void encode(RequestBackpackInventoryContentsMessage msg, PacketBuffer packetBuffer) {
        packetBuffer.func_179252_a(msg.backpackUuid);
    }

    public static RequestBackpackInventoryContentsMessage decode(PacketBuffer packetBuffer) {
        return new RequestBackpackInventoryContentsMessage(packetBuffer.func_179253_g());
    }

    static void onMessage(RequestBackpackInventoryContentsMessage msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> RequestBackpackInventoryContentsMessage.handleMessage(context.getSender(), msg));
        context.setPacketHandled(true);
    }

    private static void handleMessage(@Nullable ServerPlayerEntity player, RequestBackpackInventoryContentsMessage msg) {
        INBT upgradeNbt;
        if (player == null) {
            return;
        }
        CompoundNBT backpackContents = BackpackStorage.get().getOrCreateBackpackContents(msg.backpackUuid);
        CompoundNBT inventoryContents = new CompoundNBT();
        INBT inventoryNbt = backpackContents.func_74781_a("inventory");
        if (inventoryNbt != null) {
            inventoryContents.func_218657_a("inventory", inventoryNbt);
        }
        if ((upgradeNbt = backpackContents.func_74781_a("upgradeInventory")) != null) {
            inventoryContents.func_218657_a("upgradeInventory", upgradeNbt);
        }
        PacketHandler.sendToClient(player, new BackpackContentsMessage(msg.backpackUuid, inventoryContents));
    }
}

