/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.crafting;

import java.util.Optional;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.ShapedRecipe;
import net.p3pp3rf1y.sophisticatedbackpacks.api.CapabilityBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackItem;
import net.p3pp3rf1y.sophisticatedbackpacks.crafting.IWrapperRecipe;
import net.p3pp3rf1y.sophisticatedbackpacks.crafting.RecipeWrapperSerializer;

public class BackpackUpgradeRecipe
extends ShapedRecipe
implements IWrapperRecipe<ShapedRecipe> {
    public static final Serializer SERIALIZER = new Serializer();
    private final ShapedRecipe compose;

    public BackpackUpgradeRecipe(ShapedRecipe compose) {
        super(compose.func_199560_c(), compose.func_193358_e(), compose.getRecipeWidth(), compose.getRecipeHeight(), compose.func_192400_c(), compose.func_77571_b());
        this.compose = compose;
    }

    @Override
    public ShapedRecipe getCompose() {
        return this.compose;
    }

    public ItemStack func_77572_b(CraftingInventory inv) {
        ItemStack upgradedBackpack = super.func_77572_b(inv);
        this.getBackpack(inv).flatMap(backpack -> Optional.ofNullable(backpack.func_77978_p())).ifPresent(tag -> upgradedBackpack.func_77982_d(tag.func_74737_b()));
        upgradedBackpack.getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).ifPresent(wrapper -> {
            BackpackItem backpackItem = (BackpackItem)upgradedBackpack.func_77973_b();
            wrapper.setSlotNumbers(backpackItem.getNumberOfSlots(), backpackItem.getNumberOfUpgradeSlots());
        });
        return upgradedBackpack;
    }

    private Optional<ItemStack> getBackpack(CraftingInventory inv) {
        for (int slot = 0; slot < inv.func_70302_i_(); ++slot) {
            ItemStack slotStack = inv.func_70301_a(slot);
            if (!(slotStack.func_77973_b() instanceof BackpackItem)) continue;
            return Optional.of(slotStack);
        }
        return Optional.empty();
    }

    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }

    public static class Serializer
    extends RecipeWrapperSerializer<ShapedRecipe, BackpackUpgradeRecipe> {
        public Serializer() {
            super(BackpackUpgradeRecipe::new, IRecipeSerializer.field_222157_a);
        }
    }
}

