/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.ITag;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IBackpackFluidHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.tank.TankUpgradeItem;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.tank.TankUpgradeWrapper;

public class BackpackFluidHandler
implements IBackpackFluidHandler {
    private final IBackpackWrapper backpackWrapper;

    public BackpackFluidHandler(IBackpackWrapper backpackWrapper) {
        this.backpackWrapper = backpackWrapper;
    }

    public int getTanks() {
        return this.getAllTanks().size();
    }

    public FluidStack getFluidInTank(int tank) {
        return this.isInvalidTank(tank) ? FluidStack.EMPTY : this.getAllTanks().get(tank).getContents();
    }

    @Nonnull
    private List<TankUpgradeWrapper> getAllTanks() {
        return this.backpackWrapper.getUpgradeHandler().getTypeWrappers(TankUpgradeItem.TYPE);
    }

    public int getTankCapacity(int tank) {
        return this.isInvalidTank(tank) ? 0 : this.getAllTanks().get(tank).getTankCapacity();
    }

    public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
        if (this.isInvalidTank(tank)) {
            return false;
        }
        FluidStack contents = this.getAllTanks().get(tank).getContents();
        return contents.isEmpty() || contents.getFluid() == stack.getFluid();
    }

    @Override
    public int fill(FluidStack resource, IFluidHandler.FluidAction action, boolean ignoreInOutLimit) {
        int filled = 0;
        FluidStack toFill = resource;
        for (TankUpgradeWrapper tank : this.getAllTanks()) {
            if ((filled += tank.fill(toFill, action, ignoreInOutLimit)) == resource.getAmount()) {
                return resource.getAmount();
            }
            toFill = new FluidStack(toFill.getFluid(), resource.getAmount() - filled);
        }
        return filled;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        return this.fill(resource, action, false);
    }

    @Override
    public FluidStack drain(ITag<Fluid> resourceTag, int maxDrain, IFluidHandler.FluidAction action, boolean ignoreInOutLimit) {
        FluidStack drained = FluidStack.EMPTY;
        int toDrain = maxDrain;
        for (TankUpgradeWrapper tank : this.getAllTanks()) {
            Fluid tankFluid = tank.getContents().getFluid();
            if ((!drained.isEmpty() || !tankFluid.func_207185_a(resourceTag)) && tankFluid != drained.getFluid()) continue;
            if (drained.isEmpty()) {
                drained = tank.drain(toDrain, action, ignoreInOutLimit);
            } else {
                drained.grow(tank.drain(toDrain, action, ignoreInOutLimit).getAmount());
            }
            if (drained.getAmount() == maxDrain) {
                return drained;
            }
            toDrain = maxDrain - drained.getAmount();
        }
        return drained;
    }

    @Override
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action, boolean ignoreInOutLimit) {
        int drained = 0;
        int toDrain = resource.getAmount();
        for (TankUpgradeWrapper tank : this.getAllTanks()) {
            if (tank.getContents().getFluid() != resource.getFluid()) continue;
            if ((drained += tank.drain(toDrain, action, ignoreInOutLimit).getAmount()) == resource.getAmount()) {
                return resource;
            }
            toDrain = resource.getAmount() - drained;
        }
        return drained == 0 ? FluidStack.EMPTY : new FluidStack(resource.getFluid(), drained);
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        return this.drain(resource, action, false);
    }

    @Override
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action, boolean ignoreInOutLimit) {
        for (TankUpgradeWrapper tank : this.getAllTanks()) {
            FluidStack drained = tank.drain(maxDrain, action, ignoreInOutLimit);
            if (drained.isEmpty()) continue;
            return drained;
        }
        return FluidStack.EMPTY;
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        return this.drain(maxDrain, action, false);
    }

    private boolean isInvalidTank(int tank) {
        return tank < 0 || tank >= this.getTanks();
    }

    public ItemStack getContainer() {
        return this.backpackWrapper.getBackpack();
    }
}

