/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.util;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackItem;
import net.p3pp3rf1y.sophisticatedbackpacks.util.PlayerInventoryHandler;

public class PlayerInventoryProvider {
    public static final String MAIN_INVENTORY = "main";
    public static final String OFFHAND_INVENTORY = "offhand";
    public static final String ARMOR_INVENTORY = "armor";
    private final Map<String, PlayerInventoryHandler> playerInventoryHandlers = new LinkedHashMap<String, PlayerInventoryHandler>();
    private final List<String> renderedHandlers = new ArrayList<String>();

    public PlayerInventoryProvider() {
        this.addPlayerInventoryHandler(MAIN_INVENTORY, gameTime -> PlayerInventoryHandler.SINGLE_IDENTIFIER, (player, identifier) -> player.field_71071_by.field_70462_a.size(), (player, identifier, slot) -> (ItemStack)player.field_71071_by.field_70462_a.get(slot), true, false, false);
        this.addPlayerInventoryHandler(OFFHAND_INVENTORY, gameTime -> PlayerInventoryHandler.SINGLE_IDENTIFIER, (player, identifier) -> player.field_71071_by.field_184439_c.size(), (player, identifier, slot) -> (ItemStack)player.field_71071_by.field_184439_c.get(slot), false, false, false);
        this.addPlayerInventoryHandler(ARMOR_INVENTORY, gameTime -> PlayerInventoryHandler.SINGLE_IDENTIFIER, (player, identifier) -> 1, (player, identifier, slot) -> (ItemStack)player.field_71071_by.field_70460_b.get(EquipmentSlotType.CHEST.func_188454_b()), false, true, false);
    }

    public void addPlayerInventoryHandler(String name, Function<Long, Set<String>> identifiersGetter, PlayerInventoryHandler.SlotCountGetter slotCountGetter, PlayerInventoryHandler.SlotStackGetter slotStackGetter, boolean visibleInGui, boolean rendered, boolean ownRenderer) {
        LinkedHashMap<String, PlayerInventoryHandler> temp = new LinkedHashMap<String, PlayerInventoryHandler>(this.playerInventoryHandlers);
        this.playerInventoryHandlers.clear();
        this.playerInventoryHandlers.put(name, new PlayerInventoryHandler(identifiersGetter, slotCountGetter, slotStackGetter, visibleInGui, ownRenderer));
        this.playerInventoryHandlers.putAll(temp);
        if (rendered) {
            ArrayList<String> tempRendered = new ArrayList<String>(this.renderedHandlers);
            this.renderedHandlers.clear();
            this.renderedHandlers.add(name);
            this.renderedHandlers.addAll(tempRendered);
        }
    }

    public Optional<RenderInfo> getBackpackFromRendered(PlayerEntity player) {
        for (String handlerName : this.renderedHandlers) {
            PlayerInventoryHandler invHandler = this.playerInventoryHandlers.get(handlerName);
            if (invHandler == null) {
                return Optional.empty();
            }
            for (String identifier : invHandler.getIdentifiers(player.field_70170_p.func_82737_E())) {
                for (int slot = 0; slot < invHandler.getSlotCount(player, identifier); ++slot) {
                    ItemStack slotStack = invHandler.getStackInSlot(player, identifier, slot);
                    if (!(slotStack.func_77973_b() instanceof BackpackItem)) continue;
                    return invHandler.hasItsOwnRenderer() ? Optional.empty() : Optional.of(new RenderInfo(slotStack, handlerName.equals(ARMOR_INVENTORY)));
                }
            }
        }
        return Optional.empty();
    }

    private Map<String, PlayerInventoryHandler> getPlayerInventoryHandlers() {
        return this.playerInventoryHandlers;
    }

    public Optional<PlayerInventoryHandler> getPlayerInventoryHandler(String name) {
        return Optional.ofNullable(this.getPlayerInventoryHandlers().get(name));
    }

    public void runOnBackpacks(PlayerEntity player, BackpackInventorySlotConsumer backpackInventorySlotConsumer) {
        for (Map.Entry<String, PlayerInventoryHandler> entry : this.getPlayerInventoryHandlers().entrySet()) {
            PlayerInventoryHandler invHandler = entry.getValue();
            for (String identifier : invHandler.getIdentifiers(player.field_70170_p.func_82737_E())) {
                for (int slot = 0; slot < invHandler.getSlotCount(player, identifier); ++slot) {
                    ItemStack slotStack = invHandler.getStackInSlot(player, identifier, slot);
                    if (!(slotStack.func_77973_b() instanceof BackpackItem) || !backpackInventorySlotConsumer.accept(slotStack, entry.getKey(), identifier, slot)) continue;
                    return;
                }
            }
        }
    }

    public static class RenderInfo {
        private final ItemStack backpack;
        private final boolean isArmorSlot;

        public RenderInfo(ItemStack backpack, boolean isArmorSlot) {
            this.backpack = backpack;
            this.isArmorSlot = isArmorSlot;
        }

        public ItemStack getBackpack() {
            return this.backpack;
        }

        public boolean isArmorSlot() {
            return this.isArmorSlot;
        }
    }

    public static interface BackpackInventorySlotConsumer {
        public boolean accept(ItemStack var1, String var2, String var3, int var4);
    }
}

