/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades.xppump;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.UpgradeContainerBase;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.UpgradeContainerType;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.xppump.AutomationDirection;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.xppump.XpPumpUpgradeWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.util.NBTHelper;

public class XpPumpUpgradeContainer
extends UpgradeContainerBase<XpPumpUpgradeWrapper, XpPumpUpgradeContainer> {
    private static final String DATA_LEVEL = "level";
    private static final String DATA_DIRECTION = "direction";
    private static final String DATA_ACTION = "action";
    private static final String ACTION_TAKE_LEVELS = "take";
    private static final String ACTION_STORE_LEVELS_FROM_PLAYER = "store";
    private static final String ACTION_STORE_ALL_PLAYERS_EXPERIENCE = "storeAll";
    private static final String ACTION_TAKE_ALL_LEVELS = "takeAll";
    private static final String DATA_LEVELS_TO_STORE = "levelsToStore";
    private static final String DATA_LEVELS_TO_TAKE = "levelsToTake";
    private static final String DATA_MEND_ITEMS = "mendItems";

    public XpPumpUpgradeContainer(PlayerEntity player, int upgradeContainerId, XpPumpUpgradeWrapper upgradeWrapper, UpgradeContainerType<XpPumpUpgradeWrapper, XpPumpUpgradeContainer> type) {
        super(player, upgradeContainerId, upgradeWrapper, type);
    }

    public void setDirection(AutomationDirection direction) {
        ((XpPumpUpgradeWrapper)this.upgradeWrapper).setDirection(direction);
        this.sendDataToServer(() -> NBTHelper.putEnumConstant(new CompoundNBT(), DATA_DIRECTION, direction));
    }

    public AutomationDirection getDirection() {
        return ((XpPumpUpgradeWrapper)this.upgradeWrapper).getDirection();
    }

    public int getLevel() {
        return ((XpPumpUpgradeWrapper)this.upgradeWrapper).getLevel();
    }

    public void setLevel(int level) {
        if (level < 0) {
            return;
        }
        ((XpPumpUpgradeWrapper)this.upgradeWrapper).setLevel(level);
        this.sendDataToServer(() -> NBTHelper.putInt(new CompoundNBT(), DATA_LEVEL, level));
    }

    public void setLevelsToStore(int levelsToStore) {
        if (levelsToStore < 1) {
            return;
        }
        ((XpPumpUpgradeWrapper)this.upgradeWrapper).setLevelsToStore(levelsToStore);
        this.sendDataToServer(() -> NBTHelper.putInt(new CompoundNBT(), DATA_LEVELS_TO_STORE, levelsToStore));
    }

    public void setLevelsToTake(int levelsToTake) {
        if (levelsToTake < 1) {
            return;
        }
        ((XpPumpUpgradeWrapper)this.upgradeWrapper).setLevelsToTake(levelsToTake);
        this.sendDataToServer(() -> NBTHelper.putInt(new CompoundNBT(), DATA_LEVELS_TO_TAKE, levelsToTake));
    }

    public void takeLevels() {
        this.triggerAction(ACTION_TAKE_LEVELS);
    }

    public void storeLevels() {
        this.triggerAction(ACTION_STORE_LEVELS_FROM_PLAYER);
    }

    public void storeAllExperience() {
        this.triggerAction(ACTION_STORE_ALL_PLAYERS_EXPERIENCE);
    }

    public void takeAllExperience() {
        this.triggerAction(ACTION_TAKE_ALL_LEVELS);
    }

    private void triggerAction(String actionName) {
        this.sendDataToServer(() -> NBTHelper.putString(new CompoundNBT(), DATA_ACTION, actionName));
    }

    public int getLevelsToStore() {
        return ((XpPumpUpgradeWrapper)this.upgradeWrapper).getLevelsToStore();
    }

    public int getLevelsToTake() {
        return ((XpPumpUpgradeWrapper)this.upgradeWrapper).getLevelsToTake();
    }

    public void setMendItems(boolean mendItems) {
        ((XpPumpUpgradeWrapper)this.upgradeWrapper).setMendItems(mendItems);
        this.sendBooleanToServer(DATA_MEND_ITEMS, mendItems);
    }

    public boolean shouldMendItems() {
        return ((XpPumpUpgradeWrapper)this.upgradeWrapper).shouldMendItems();
    }

    @Override
    public void handleMessage(CompoundNBT data) {
        if (data.func_74764_b(DATA_DIRECTION)) {
            this.setDirection(AutomationDirection.fromName(data.func_74779_i(DATA_DIRECTION)));
        } else if (data.func_74764_b(DATA_LEVEL)) {
            this.setLevel(data.func_74762_e(DATA_LEVEL));
        } else if (data.func_74764_b(DATA_LEVELS_TO_STORE)) {
            this.setLevelsToStore(data.func_74762_e(DATA_LEVELS_TO_STORE));
        } else if (data.func_74764_b(DATA_LEVELS_TO_TAKE)) {
            this.setLevelsToTake(data.func_74762_e(DATA_LEVELS_TO_TAKE));
        } else if (data.func_74764_b(DATA_MEND_ITEMS)) {
            this.setMendItems(data.func_74767_n(DATA_MEND_ITEMS));
        } else if (data.func_74764_b(DATA_ACTION)) {
            switch (data.func_74779_i(DATA_ACTION)) {
                case "take": {
                    ((XpPumpUpgradeWrapper)this.upgradeWrapper).giveLevelsToPlayer(this.player);
                    break;
                }
                case "store": {
                    ((XpPumpUpgradeWrapper)this.upgradeWrapper).takeLevelsFromPlayer(this.player);
                    break;
                }
                case "takeAll": {
                    ((XpPumpUpgradeWrapper)this.upgradeWrapper).giveAllExperienceToPlayer(this.player);
                    break;
                }
                case "storeAll": {
                    ((XpPumpUpgradeWrapper)this.upgradeWrapper).takeAllExperienceFromPlayer(this.player);
                    break;
                }
            }
        }
    }
}

