/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades.inception;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IUpgradeWrapperAccessor;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.inception.SubBackpacksHandler;

public class InceptionWrapperAccessor
implements IUpgradeWrapperAccessor {
    private final Map<Class<?>, List<?>> interfaceWrappers = new HashMap();
    private final Map<Class<?>, List<?>> mainBackpackInterfaceWrappers = new HashMap();
    private final IBackpackWrapper backpackWrapper;
    private final SubBackpacksHandler subBackpacksHandler;

    public InceptionWrapperAccessor(IBackpackWrapper backpackWrapper, SubBackpacksHandler subBackpacksHandler) {
        this.backpackWrapper = backpackWrapper;
        this.subBackpacksHandler = subBackpacksHandler;
        this.addRefreshCallbacks(subBackpacksHandler.getSubBackpacks());
        subBackpacksHandler.addBeforeRefreshListener(this::removeCallBacks);
        subBackpacksHandler.addRefreshListener(this::clearCacheAndAddCallBacks);
    }

    private void clearCacheAndAddCallBacks(Collection<IBackpackWrapper> subbackpacks) {
        this.clearCache();
        this.addRefreshCallbacks(subbackpacks);
    }

    private void addRefreshCallbacks(Collection<IBackpackWrapper> subbackpacks) {
        subbackpacks.forEach(sb -> sb.getUpgradeHandler().setRefreshCallBack(this::clearCache));
    }

    @Override
    public <T> List<T> getWrappersThatImplement(Class<T> upgradeClass) {
        return this.interfaceWrappers.computeIfAbsent(upgradeClass, this::collectListOfWrappersThatImplement);
    }

    @Override
    public <T> List<T> getWrappersThatImplementFromMainBackpack(Class<T> upgradeClass) {
        return this.mainBackpackInterfaceWrappers.computeIfAbsent(upgradeClass, this.backpackWrapper.getUpgradeHandler()::getListOfWrappersThatImplement);
    }

    @Override
    public void onBeforeDeconstruct() {
        this.removeCallBacks(this.subBackpacksHandler.getSubBackpacks());
    }

    private <T> List<T> collectListOfWrappersThatImplement(Class<T> upgradeClass) {
        ArrayList ret = new ArrayList(this.backpackWrapper.getUpgradeHandler().getListOfWrappersThatImplement(upgradeClass));
        this.subBackpacksHandler.getSubBackpacks().forEach(sbp -> ret.addAll(sbp.getUpgradeHandler().getWrappersThatImplement(upgradeClass)));
        return ret;
    }

    private void removeCallBacks(Collection<IBackpackWrapper> subBackpacksHandler) {
        subBackpacksHandler.forEach(sb -> sb.getUpgradeHandler().removeRefreshCallback());
    }

    @Override
    public void clearCache() {
        this.interfaceWrappers.clear();
    }
}

