/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades.deposit;

import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.inventory.container.Slot;
import net.minecraft.nbt.CompoundNBT;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.FilterLogicContainer;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.IServerUpdater;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.deposit.DepositFilterLogic;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.deposit.DepositFilterType;
import net.p3pp3rf1y.sophisticatedbackpacks.util.NBTHelper;

public class DepositFilterLogicContainer
extends FilterLogicContainer<DepositFilterLogic> {
    private static final String DATA_DEPOSIT_FILTER_TYPE = "depositFilterType";

    public DepositFilterLogicContainer(Supplier<DepositFilterLogic> filterLogic, IServerUpdater serverUpdater, Consumer<Slot> addSlot) {
        super(filterLogic, serverUpdater, addSlot);
        if (this.getDepositFilterType() == DepositFilterType.INVENTORY) {
            this.getFilterSlots().forEach(s -> s.setEnabled(false));
        }
    }

    public void setDepositFilterType(DepositFilterType depositFilterType) {
        ((DepositFilterLogic)this.filterLogic.get()).setDepositFilterType(depositFilterType);
        this.serverUpdater.sendDataToServer(() -> NBTHelper.putEnumConstant(new CompoundNBT(), DATA_DEPOSIT_FILTER_TYPE, depositFilterType));
    }

    @Override
    public boolean handleMessage(CompoundNBT data) {
        if (data.func_74764_b(DATA_DEPOSIT_FILTER_TYPE)) {
            this.setDepositFilterType(DepositFilterType.fromName(data.func_74779_i(DATA_DEPOSIT_FILTER_TYPE)));
        }
        return super.handleMessage(data);
    }

    public DepositFilterType getDepositFilterType() {
        return ((DepositFilterLogic)this.filterLogic.get()).getDepositFilterType();
    }
}

