/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades.crafting;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.CraftResultInventory;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.CraftingResultSlot;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.BackpackContainer;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.ICraftingContainer;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.SlotSuppliedHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.UpgradeContainerBase;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.UpgradeContainerType;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.crafting.CraftingItemHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.crafting.CraftingUpgradeWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.util.NBTHelper;

public class CraftingUpgradeContainer
extends UpgradeContainerBase<CraftingUpgradeWrapper, CraftingUpgradeContainer>
implements ICraftingContainer {
    private static final String DATA_SHIFT_CLICK_INTO_BACKPACK = "shiftClickIntoBackpack";
    private final CraftResultInventory craftResult = new CraftResultInventory();
    private final CraftingItemHandler craftMatrix;
    private final CraftingResultSlot craftingResultSlot;
    @Nullable
    private ICraftingRecipe lastRecipe = null;

    public CraftingUpgradeContainer(final PlayerEntity player, int upgradeContainerId, CraftingUpgradeWrapper upgradeWrapper, UpgradeContainerType<CraftingUpgradeWrapper, CraftingUpgradeContainer> type) {
        super(player, upgradeContainerId, upgradeWrapper, type);
        int slot;
        for (slot = 0; slot < upgradeWrapper.getInventory().getSlots(); ++slot) {
            this.slots.add(new SlotSuppliedHandler(upgradeWrapper::getInventory, slot, -100, -100){

                public void func_75218_e() {
                    super.func_75218_e();
                    CraftingUpgradeContainer.this.updateCraftingResult(player.field_70170_p, player, CraftingUpgradeContainer.this.craftMatrix, CraftingUpgradeContainer.this.craftResult, CraftingUpgradeContainer.this.craftingResultSlot);
                }
            });
        }
        this.craftMatrix = new CraftingItemHandler(upgradeWrapper::getInventory, this::onCraftMatrixChanged);
        this.craftingResultSlot = new CraftingResultSlot(player, this.craftMatrix, (IInventory)this.craftResult, slot, -100, -100){

            public ItemStack func_190901_a(PlayerEntity thePlayer, ItemStack stack) {
                ItemStack remainingStack = this.func_75211_c();
                this.func_75208_c(stack);
                ForgeHooks.setCraftingPlayer((PlayerEntity)thePlayer);
                NonNullList nonnulllist = CraftingUpgradeContainer.this.lastRecipe != null && CraftingUpgradeContainer.this.lastRecipe.func_77569_a((IInventory)CraftingUpgradeContainer.this.craftMatrix, player.field_70170_p) ? CraftingUpgradeContainer.this.lastRecipe.func_179532_b((IInventory)CraftingUpgradeContainer.this.craftMatrix) : ((CraftingUpgradeContainer)CraftingUpgradeContainer.this).craftMatrix.field_70466_a;
                ForgeHooks.setCraftingPlayer(null);
                for (int i = 0; i < nonnulllist.size(); ++i) {
                    ItemStack itemstack = CraftingUpgradeContainer.this.craftMatrix.func_70301_a(i);
                    ItemStack itemstack1 = (ItemStack)nonnulllist.get(i);
                    if (!itemstack.func_190926_b()) {
                        CraftingUpgradeContainer.this.craftMatrix.func_70298_a(i, 1);
                        itemstack = CraftingUpgradeContainer.this.craftMatrix.func_70301_a(i);
                    }
                    if (!itemstack1.func_190926_b()) {
                        if (itemstack.func_190926_b()) {
                            CraftingUpgradeContainer.this.craftMatrix.func_70299_a(i, itemstack1);
                        } else if (ItemStack.func_179545_c((ItemStack)itemstack, (ItemStack)itemstack1) && ItemStack.func_77970_a((ItemStack)itemstack, (ItemStack)itemstack1)) {
                            itemstack1.func_190917_f(itemstack.func_190916_E());
                            CraftingUpgradeContainer.this.craftMatrix.func_70299_a(i, itemstack1);
                        } else if (!player.field_71071_by.func_70441_a(itemstack1)) {
                            player.func_71019_a(itemstack1, false);
                        }
                    }
                    if (!(thePlayer.field_71070_bA instanceof BackpackContainer)) continue;
                    Slot slot = (Slot)CraftingUpgradeContainer.this.slots.get(i);
                    ((BackpackContainer)thePlayer.field_71070_bA).setSlotStackToUpdate(slot.field_75222_d, slot.func_75211_c());
                }
                if (!remainingStack.func_190926_b()) {
                    player.func_71019_a(remainingStack, false);
                }
                return stack;
            }
        };
        this.slots.add(this.craftingResultSlot);
    }

    @Override
    public void onInit() {
        super.onInit();
        this.onCraftMatrixChanged((IInventory)this.craftMatrix);
    }

    private void onCraftMatrixChanged(IInventory iInventory) {
        this.updateCraftingResult(this.player.field_70170_p, this.player, this.craftMatrix, this.craftResult, this.craftingResultSlot);
    }

    private void updateCraftingResult(World world, PlayerEntity player, CraftingInventory inventory, CraftResultInventory inventoryResult, CraftingResultSlot craftingResultSlot) {
        if (!world.field_72995_K) {
            ServerPlayerEntity serverplayerentity = (ServerPlayerEntity)player;
            ItemStack itemstack = ItemStack.field_190927_a;
            if (this.lastRecipe != null && this.lastRecipe.func_77569_a((IInventory)inventory, world)) {
                itemstack = this.lastRecipe.func_77572_b((IInventory)inventory);
            } else {
                Optional optional = world.func_73046_m().func_199529_aN().func_215371_a(IRecipeType.field_222149_a, (IInventory)inventory, world);
                if (optional.isPresent()) {
                    ICraftingRecipe craftingRecipe = (ICraftingRecipe)optional.get();
                    if (inventoryResult.func_201561_a(world, serverplayerentity, (IRecipe)craftingRecipe)) {
                        this.lastRecipe = craftingRecipe;
                        itemstack = this.lastRecipe.func_77572_b((IInventory)inventory);
                    } else {
                        this.lastRecipe = null;
                    }
                }
            }
            craftingResultSlot.func_75215_d(itemstack);
            if (serverplayerentity.field_71070_bA instanceof BackpackContainer) {
                ((BackpackContainer)serverplayerentity.field_71070_bA).setSlotStackToUpdate(craftingResultSlot.field_75222_d, itemstack);
            }
        }
    }

    @Override
    public void handleMessage(CompoundNBT data) {
        if (data.func_74764_b(DATA_SHIFT_CLICK_INTO_BACKPACK)) {
            this.setShiftClickIntoBackpack(data.func_74767_n(DATA_SHIFT_CLICK_INTO_BACKPACK));
        }
    }

    @Override
    public ItemStack getSlotStackToTransfer(Slot slot) {
        if (slot == this.craftingResultSlot) {
            ItemStack slotStack = slot.func_75211_c();
            slotStack.func_77973_b().func_77622_d(slotStack, this.player.field_70170_p, this.player);
            return slotStack;
        }
        return super.getSlotStackToTransfer(slot);
    }

    @Override
    public List<Slot> getRecipeSlots() {
        return this.slots.subList(0, 9);
    }

    @Override
    public IInventory getCraftMatrix() {
        return this.craftMatrix;
    }

    public boolean shouldShiftClickIntoBackpack() {
        return ((CraftingUpgradeWrapper)this.upgradeWrapper).shouldShiftClickIntoBackpack();
    }

    public void setShiftClickIntoBackpack(boolean shiftClickIntoBackpack) {
        ((CraftingUpgradeWrapper)this.upgradeWrapper).setShiftClickIntoBackpack(shiftClickIntoBackpack);
        this.sendDataToServer(() -> NBTHelper.putBoolean(new CompoundNBT(), DATA_SHIFT_CLICK_INTO_BACKPACK, shiftClickIntoBackpack));
    }

    @Override
    public boolean mergeIntoBackpackFirst(Slot slot) {
        return !(slot instanceof CraftingResultSlot) || this.shouldShiftClickIntoBackpack();
    }

    @Override
    public boolean allowsPickupAll(Slot slot) {
        return slot != this.craftingResultSlot;
    }
}

