/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades;

import java.util.function.Consumer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IUpgradeWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.UpgradeItemBase;
import net.p3pp3rf1y.sophisticatedbackpacks.util.NBTHelper;

public abstract class UpgradeWrapperBase<W extends IUpgradeWrapper, T extends UpgradeItemBase<W>>
implements IUpgradeWrapper {
    protected final IBackpackWrapper backpackWrapper;
    protected final Consumer<ItemStack> upgradeSaveHandler;
    protected ItemStack upgrade;
    protected T upgradeItem;
    private long cooldown = 0L;

    protected UpgradeWrapperBase(IBackpackWrapper backpackWrapper, ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler) {
        this.backpackWrapper = backpackWrapper;
        this.upgrade = upgrade;
        this.upgradeItem = (UpgradeItemBase)upgrade.func_77973_b();
        this.upgradeSaveHandler = upgradeSaveHandler;
    }

    @Override
    public ItemStack getUpgradeStack() {
        return this.upgrade;
    }

    protected void save() {
        this.upgradeSaveHandler.accept(this.upgrade);
    }

    protected void setCooldown(World world, int time) {
        this.cooldown = world.func_82737_E() + (long)time;
    }

    public long getCooldownTime() {
        return this.cooldown;
    }

    public boolean isInCooldown(World world) {
        return this.getCooldownTime() > world.func_82737_E();
    }

    @Override
    public boolean isEnabled() {
        return NBTHelper.getBoolean(this.upgrade, "enabled").orElse(true);
    }

    @Override
    public void setEnabled(boolean enabled) {
        NBTHelper.setBoolean(this.upgrade, "enabled", enabled);
        this.save();
        this.backpackWrapper.getUpgradeHandler().refreshWrappersThatImplementAndTypeWrappers();
    }
}

