/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades;

import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.inventory.container.Slot;
import net.minecraft.nbt.CompoundNBT;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.ContentsFilterLogic;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.ContentsFilterType;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.FilterLogicContainer;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.IServerUpdater;
import net.p3pp3rf1y.sophisticatedbackpacks.util.NBTHelper;

public class ContentsFilterLogicContainer
extends FilterLogicContainer<ContentsFilterLogic> {
    private static final String DATA_CONTENTS_FILTER_TYPE = "contentsFilterType";

    public ContentsFilterLogicContainer(Supplier<ContentsFilterLogic> filterLogic, IServerUpdater serverUpdater, Consumer<Slot> addSlot) {
        super(filterLogic, serverUpdater, addSlot);
        if (this.getFilterType() == ContentsFilterType.BACKPACK) {
            this.getFilterSlots().forEach(s -> s.setEnabled(false));
        }
    }

    public void setFilterType(ContentsFilterType depositFilterType) {
        ((ContentsFilterLogic)this.filterLogic.get()).setDepositFilterType(depositFilterType);
        this.serverUpdater.sendDataToServer(() -> NBTHelper.putEnumConstant(new CompoundNBT(), DATA_CONTENTS_FILTER_TYPE, depositFilterType));
    }

    @Override
    public boolean handleMessage(CompoundNBT data) {
        if (data.func_74764_b(DATA_CONTENTS_FILTER_TYPE)) {
            this.setFilterType(ContentsFilterType.fromName(data.func_74779_i(DATA_CONTENTS_FILTER_TYPE)));
        }
        return super.handleMessage(data);
    }

    public ContentsFilterType getFilterType() {
        return ((ContentsFilterLogic)this.filterLogic.get()).getFilterType();
    }
}

