/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.settings.memory;

import net.minecraft.nbt.CompoundNBT;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.SettingsContainer;
import net.p3pp3rf1y.sophisticatedbackpacks.settings.SettingsContainerBase;
import net.p3pp3rf1y.sophisticatedbackpacks.settings.memory.MemorySettingsCategory;

public class MemorySettingsContainer
extends SettingsContainerBase<MemorySettingsCategory> {
    private static final String ACTION_TAG = "action";
    private static final String SELECT_ALL_ACTION = "selectAll";
    private static final String UNSELECT_ALL_ACTION = "unselectAll";
    private static final String UNSELECT_SLOT_TAG = "unselectSlot";
    private static final String SELECT_SLOT_TAG = "selectSlot";

    public MemorySettingsContainer(SettingsContainer settingsContainer, String categoryName, MemorySettingsCategory category) {
        super(settingsContainer, categoryName, category);
    }

    @Override
    public void handleMessage(CompoundNBT data) {
        if (data.func_74764_b(ACTION_TAG)) {
            switch (data.func_74779_i(ACTION_TAG)) {
                case "selectAll": {
                    this.selectAllSlots();
                    break;
                }
                case "unselectAll": {
                    this.unselectAllSlots();
                    break;
                }
            }
        } else if (data.func_74764_b(SELECT_SLOT_TAG)) {
            this.selectSlot(data.func_74762_e(SELECT_SLOT_TAG));
        } else if (data.func_74764_b(UNSELECT_SLOT_TAG)) {
            this.unselectSlot(data.func_74762_e(UNSELECT_SLOT_TAG));
        }
    }

    public void unselectSlot(int slotNumber) {
        if (!this.isSlotSelected(slotNumber)) {
            return;
        }
        if (this.isServer()) {
            ((MemorySettingsCategory)this.getCategory()).unselectSlot(slotNumber);
        } else {
            this.sendIntToServer(UNSELECT_SLOT_TAG, slotNumber);
        }
    }

    public void selectSlot(int slotNumber) {
        if (this.isSlotSelected(slotNumber)) {
            return;
        }
        if (this.isServer()) {
            ((MemorySettingsCategory)this.getCategory()).selectSlot(slotNumber);
        } else {
            this.sendIntToServer(SELECT_SLOT_TAG, slotNumber);
        }
    }

    public void unselectAllSlots() {
        if (this.isServer()) {
            ((MemorySettingsCategory)this.getCategory()).unselectAllSlots();
        } else {
            this.sendStringToServer(ACTION_TAG, UNSELECT_ALL_ACTION);
        }
    }

    public void selectAllSlots() {
        if (this.isServer()) {
            ((MemorySettingsCategory)this.getCategory()).selectSlots(0, this.getSettingsContainer().getNumberOfSlots());
        } else {
            this.sendStringToServer(ACTION_TAG, SELECT_ALL_ACTION);
        }
    }

    public boolean isSlotSelected(int slotNumber) {
        return ((MemorySettingsCategory)this.getCategory()).isSlotSelected(slotNumber);
    }
}

