/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.settings.backpack;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackSettingsManager;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.SettingsContainer;
import net.p3pp3rf1y.sophisticatedbackpacks.settings.SettingsContainerBase;
import net.p3pp3rf1y.sophisticatedbackpacks.settings.backpack.BackpackSettingsCategory;
import net.p3pp3rf1y.sophisticatedbackpacks.settings.backpack.Context;

public class BackpackSettingsContainer
extends SettingsContainerBase<BackpackSettingsCategory> {
    private static final String CONTEXT_TAG = "context";
    private Context context = Context.PLAYER;

    public BackpackSettingsContainer(SettingsContainer settingsContainer, String categoryName, BackpackSettingsCategory category) {
        super(settingsContainer, categoryName, category);
    }

    @Override
    public void handleMessage(CompoundNBT data) {
        if (data.func_74764_b(CONTEXT_TAG)) {
            this.context = Context.fromId(data.func_74762_e(CONTEXT_TAG));
        } else {
            for (String tagName : data.func_150296_c()) {
                BackpackSettingsManager.getBackpackSetting(tagName).ifPresent(setting -> this.setSettingValue(this.getPlayer(), (BackpackSettingsManager.BackpackSetting)setting, data));
            }
        }
    }

    public void toggleContext() {
        this.context = this.context == Context.PLAYER ? Context.BACKPACK : Context.PLAYER;
        this.sendIntToServer(CONTEXT_TAG, this.context.getId());
    }

    public Context getContext() {
        return this.context;
    }

    private PlayerEntity getPlayer() {
        return this.getSettingsContainer().getPlayer();
    }

    public void toggleShiftClickIntoOpenTab() {
        this.toggleBooleanSetting(this.getPlayer(), BackpackSettingsManager.SHIFT_CLICK_INTO_OPEN_TAB_FIRST);
    }

    public boolean shouldShiftClickIntoOpenTab() {
        return this.getSettingValue(BackpackSettingsManager.SHIFT_CLICK_INTO_OPEN_TAB_FIRST);
    }

    public void toggleKeepTabOpen() {
        this.toggleBooleanSetting(this.getPlayer(), BackpackSettingsManager.KEEP_TAB_OPEN);
    }

    public boolean shouldKeepTabOpen() {
        return this.getSettingValue(BackpackSettingsManager.KEEP_TAB_OPEN);
    }

    private <T> T getSettingValue(BackpackSettingsManager.BackpackSetting<T> setting) {
        if (this.context == Context.PLAYER) {
            return BackpackSettingsManager.getPlayerSettingOrDefault(this.getPlayer(), setting);
        }
        return BackpackSettingsManager.getBackpackSettingValue(this.getPlayer(), (BackpackSettingsCategory)this.getCategory(), setting);
    }

    private <T> void setSettingValue(PlayerEntity player, BackpackSettingsManager.BackpackSetting<T> setting, CompoundNBT data) {
        setting.getValue(data).ifPresent(value -> {
            if (this.context == Context.PLAYER) {
                BackpackSettingsManager.setPlayerSetting(player, setting, value);
            } else {
                BackpackSettingsManager.setBackpackSetting(player, (BackpackSettingsCategory)this.getCategory(), setting, value);
            }
        });
    }

    private void toggleBooleanSetting(PlayerEntity player, BackpackSettingsManager.BackpackSetting<Boolean> setting) {
        if (this.context == Context.PLAYER) {
            boolean value = BackpackSettingsManager.getPlayerSettingOrDefault(player, setting) == false;
            BackpackSettingsManager.setPlayerSetting(player, setting, value);
            this.sendSettingValueToServer(setting, value);
        } else {
            boolean value = BackpackSettingsManager.getBackpackSettingValue(player, (BackpackSettingsCategory)this.getCategory(), setting) == false;
            this.sendSettingValueToServer(setting, value);
        }
    }

    private void sendSettingValueToServer(BackpackSettingsManager.BackpackSetting<Boolean> setting, boolean value) {
        CompoundNBT data = new CompoundNBT();
        setting.setValue(data, value);
        this.sendDataToServer(() -> data);
    }
}

