/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.crafting;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.IRequirementsStrategy;
import net.minecraft.advancements.criterion.RecipeUnlockedTrigger;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.p3pp3rf1y.sophisticatedbackpacks.crafting.ItemEnabledCondition;
import net.p3pp3rf1y.sophisticatedbackpacks.util.RegistryHelper;

public class ShapeBasedRecipeBuilder {
    private final Item itemResult;
    private final List<ICondition> conditions = new ArrayList<ICondition>();
    private final List<String> pattern = new ArrayList<String>();
    private final Map<Character, Ingredient> keyIngredients = Maps.newLinkedHashMap();
    private final IRecipeSerializer<?> serializer;
    private final Advancement.Builder advancementBuilder = Advancement.Builder.func_200278_a();

    public ShapeBasedRecipeBuilder(IItemProvider itemResult, IRecipeSerializer<?> serializer) {
        this.itemResult = itemResult.func_199767_j();
        this.serializer = serializer;
    }

    public static ShapeBasedRecipeBuilder shapedRecipe(IItemProvider itemResult) {
        return ShapeBasedRecipeBuilder.shapedRecipe(itemResult, IRecipeSerializer.field_222157_a);
    }

    public static ShapeBasedRecipeBuilder shapedRecipe(IItemProvider itemResult, IRecipeSerializer<?> serializer) {
        return new ShapeBasedRecipeBuilder(itemResult, serializer);
    }

    public ShapeBasedRecipeBuilder key(Character symbol, ITag<Item> tagIn) {
        return this.key(symbol, Ingredient.func_199805_a(tagIn));
    }

    public ShapeBasedRecipeBuilder key(Character symbol, IItemProvider itemIn) {
        return this.key(symbol, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{itemIn}));
    }

    public ShapeBasedRecipeBuilder key(Character symbol, Ingredient ingredientIn) {
        if (this.keyIngredients.containsKey(symbol)) {
            throw new IllegalArgumentException("Symbol '" + symbol + "' is already defined!");
        }
        if (symbol.charValue() == ' ') {
            throw new IllegalArgumentException("Symbol ' ' (whitespace) is reserved and cannot be defined");
        }
        this.keyIngredients.put(symbol, ingredientIn);
        return this;
    }

    public ShapeBasedRecipeBuilder patternLine(String patternIn) {
        if (!this.pattern.isEmpty() && patternIn.length() != this.pattern.get(0).length()) {
            throw new IllegalArgumentException("Pattern must be the same width on every line!");
        }
        this.pattern.add(patternIn);
        return this;
    }

    public ShapeBasedRecipeBuilder addCriterion(String name, ICriterionInstance criterion) {
        this.advancementBuilder.func_200275_a(name, criterion);
        return this;
    }

    public void build(Consumer<IFinishedRecipe> consumerIn) {
        this.build(consumerIn, RegistryHelper.getItemKey(this.itemResult));
    }

    public void build(Consumer<IFinishedRecipe> consumerIn, ResourceLocation id) {
        this.validate(id);
        this.advancementBuilder.func_200272_a(new ResourceLocation("recipes/root")).func_200275_a("has_the_recipe", (ICriterionInstance)RecipeUnlockedTrigger.func_235675_a_((ResourceLocation)id)).func_200271_a(AdvancementRewards.Builder.func_200280_c((ResourceLocation)id)).func_200270_a(IRequirementsStrategy.field_223215_b_);
        consumerIn.accept(new Result(id, this.conditions, this.itemResult, this.pattern, this.keyIngredients, this.advancementBuilder, new ResourceLocation(id.func_110624_b(), "recipes/" + this.getGroup() + "/" + id.func_110623_a()), this.serializer));
    }

    private String getGroup() {
        return this.itemResult.func_77640_w() == null ? "" : this.itemResult.func_77640_w().func_200300_c();
    }

    private void validate(ResourceLocation id) {
        if (this.pattern.isEmpty()) {
            throw new IllegalStateException("No pattern is defined for shaped recipe " + id + "!");
        }
        HashSet set = Sets.newHashSet(this.keyIngredients.keySet());
        set.remove(Character.valueOf(' '));
        for (String s : this.pattern) {
            for (int i = 0; i < s.length(); ++i) {
                char c0 = s.charAt(i);
                if (!this.keyIngredients.containsKey(Character.valueOf(c0)) && c0 != ' ') {
                    throw new IllegalStateException("Pattern in recipe " + id + " uses undefined symbol '" + c0 + "'");
                }
                set.remove(Character.valueOf(c0));
            }
        }
        if (!set.isEmpty()) {
            throw new IllegalStateException("Ingredients are defined but not used in pattern for recipe " + id);
        }
        if (this.pattern.size() == 1 && this.pattern.get(0).length() == 1) {
            throw new IllegalStateException("Backpack upgrade recipe " + id + " only takes in a single item - should it be a shapeless recipe instead?");
        }
    }

    public static class Result
    implements IFinishedRecipe {
        private final ResourceLocation id;
        private final List<ICondition> conditions;
        private final Item itemResult;
        private final List<String> pattern;
        private final Map<Character, Ingredient> key;
        private final ResourceLocation advancementId;
        private final IRecipeSerializer<?> serializer;
        private final Advancement.Builder advancementBuilder;

        public Result(ResourceLocation id, List<ICondition> conditions, Item itemResult, List<String> pattern, Map<Character, Ingredient> keyIngredients, Advancement.Builder advancementBuilder, ResourceLocation advancementId, IRecipeSerializer<?> serializer) {
            this.id = id;
            this.conditions = conditions;
            this.itemResult = itemResult;
            this.pattern = pattern;
            this.key = keyIngredients;
            this.advancementId = advancementId;
            this.serializer = serializer;
            this.advancementBuilder = advancementBuilder;
            conditions.add(new ItemEnabledCondition(itemResult));
        }

        public void func_218610_a(JsonObject json) {
            JsonArray conditionsArray = new JsonArray();
            this.conditions.forEach(c -> conditionsArray.add((JsonElement)CraftingHelper.serialize((ICondition)c)));
            json.add("conditions", (JsonElement)conditionsArray);
            JsonArray jsonarray = new JsonArray();
            for (String string : this.pattern) {
                jsonarray.add(string);
            }
            json.add("pattern", (JsonElement)jsonarray);
            JsonObject jsonobject = new JsonObject();
            for (Map.Entry<Character, Ingredient> entry : this.key.entrySet()) {
                jsonobject.add(String.valueOf(entry.getKey()), entry.getValue().func_200304_c());
            }
            json.add("key", (JsonElement)jsonobject);
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("item", RegistryHelper.getItemKey(this.itemResult).toString());
            json.add("result", (JsonElement)jsonObject);
        }

        public IRecipeSerializer<?> func_218609_c() {
            return this.serializer;
        }

        public ResourceLocation func_200442_b() {
            return this.id;
        }

        @Nullable
        public JsonObject func_200440_c() {
            return this.advancementBuilder.func_200273_b();
        }

        @Nullable
        public ResourceLocation func_200443_d() {
            return this.advancementId;
        }
    }
}

