/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.backpack;

import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.api.CapabilityBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.api.ITickableUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackBlock;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.BackpackRenderInfo;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.NoopBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.TankPosition;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModBlocks;
import net.p3pp3rf1y.sophisticatedbackpacks.util.WorldHelper;

public class BackpackTileEntity
extends TileEntity
implements ITickableTileEntity {
    private IBackpackWrapper backpackWrapper = NoopBackpackWrapper.INSTANCE;
    private boolean updateBlockRender = true;

    public BackpackTileEntity() {
        super((TileEntityType)ModBlocks.BACKPACK_TILE_TYPE.get());
    }

    public void setBackpack(ItemStack backpack) {
        this.backpackWrapper = (IBackpackWrapper)backpack.getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).orElse((Object)NoopBackpackWrapper.INSTANCE);
        this.backpackWrapper.setBackpackSaveHandler(() -> {
            this.func_70296_d();
            this.updateBlockRender = false;
            WorldHelper.notifyBlockUpdate(this);
        });
        this.backpackWrapper.setInventorySlotChangeHandler(() -> ((BackpackTileEntity)this).func_70296_d());
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.setBackpackFromNbt(nbt);
        WorldHelper.notifyBlockUpdate(this);
    }

    private void setBackpackFromNbt(CompoundNBT nbt) {
        this.setBackpack(ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("backpackData")));
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        CompoundNBT ret = super.func_189515_b(compound);
        this.writeBackpack(ret);
        return ret;
    }

    private void writeBackpack(CompoundNBT ret) {
        ItemStack backpackCopy = this.backpackWrapper.getBackpack().func_77946_l();
        backpackCopy.func_77982_d(backpackCopy.func_77973_b().getShareTag(backpackCopy));
        ret.func_218657_a("backpackData", (INBT)backpackCopy.func_77955_b(new CompoundNBT()));
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT ret = super.func_189517_E_();
        this.writeBackpack(ret);
        return ret;
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT updateTag = this.func_189517_E_();
        updateTag.func_74757_a("updateBlockRender", this.updateBlockRender);
        this.updateBlockRender = true;
        return new SUpdateTileEntityPacket(this.field_174879_c, 1, updateTag);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        CompoundNBT tag = pkt.func_148857_g();
        this.setBackpackFromNbt(tag);
        if (tag.func_74767_n("updateBlockRender")) {
            WorldHelper.notifyBlockUpdate(this);
        }
    }

    public IBackpackWrapper getBackpackWrapper() {
        return this.backpackWrapper;
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.backpackWrapper.getUpgradeHandler().getWrappersThatImplement(ITickableUpgrade.class).forEach(upgrade -> upgrade.tick(null, this.field_145850_b, this.func_174877_v()));
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return LazyOptional.of(() -> this.getBackpackWrapper().getInventoryForInputOutput()).cast();
        }
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.getBackpackWrapper().getFluidHandler().map(handler -> LazyOptional.of(() -> handler).cast()).orElseGet(LazyOptional::empty);
        }
        if (cap == CapabilityEnergy.ENERGY) {
            return this.getBackpackWrapper().getEnergyStorage().map(storage -> LazyOptional.of(() -> storage).cast()).orElseGet(LazyOptional::empty);
        }
        return super.getCapability(cap, side);
    }

    public void refreshRenderState() {
        BlockState state = this.func_195044_w();
        state = (BlockState)state.func_206870_a((Property)BackpackBlock.LEFT_TANK, (Comparable)Boolean.valueOf(false));
        state = (BlockState)state.func_206870_a((Property)BackpackBlock.RIGHT_TANK, (Comparable)Boolean.valueOf(false));
        BackpackRenderInfo renderInfo = this.backpackWrapper.getRenderInfo();
        for (TankPosition pos : renderInfo.getTankRenderInfos().keySet()) {
            if (pos == TankPosition.LEFT) {
                state = (BlockState)state.func_206870_a((Property)BackpackBlock.LEFT_TANK, (Comparable)Boolean.valueOf(true));
                continue;
            }
            if (pos != TankPosition.RIGHT) continue;
            state = (BlockState)state.func_206870_a((Property)BackpackBlock.RIGHT_TANK, (Comparable)Boolean.valueOf(true));
        }
        state = (BlockState)state.func_206870_a((Property)BackpackBlock.BATTERY, (Comparable)Boolean.valueOf(renderInfo.getBatteryRenderInfo().isPresent()));
        this.field_145850_b.func_175656_a(this.field_174879_c, state);
        this.field_145850_b.func_195593_d(this.field_174879_c, state.func_177230_c());
        WorldHelper.notifyBlockUpdate(this);
    }
}

