/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.backpack;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.DimensionSavedDataManager;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.fml.common.thread.SidedThreadGroups;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.AccessLogRecord;

public class BackpackStorage
extends WorldSavedData {
    private static final String SAVED_DATA_NAME = "sophisticatedbackpacks";
    private final Map<UUID, CompoundNBT> backpackContents = new HashMap<UUID, CompoundNBT>();
    private static final BackpackStorage clientStorageCopy = new BackpackStorage();
    private final Map<UUID, AccessLogRecord> accessLogRecords = new HashMap<UUID, AccessLogRecord>();
    private final Set<UUID> updatedBackpackSettingsFlags = new HashSet<UUID>();

    private BackpackStorage() {
        super(SAVED_DATA_NAME);
    }

    public static BackpackStorage get() {
        MinecraftServer server;
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER && (server = ServerLifecycleHooks.getCurrentServer()) != null) {
            ServerWorld overworld = server.func_71218_a(World.field_234918_g_);
            DimensionSavedDataManager storage = overworld.func_217481_x();
            return (BackpackStorage)storage.func_215752_a(BackpackStorage::new, SAVED_DATA_NAME);
        }
        return clientStorageCopy;
    }

    public void func_76184_a(CompoundNBT nbt) {
        this.readBackpackContents(nbt);
        this.readAccessLogs(nbt);
    }

    private void readAccessLogs(CompoundNBT nbt) {
        for (INBT n : nbt.func_150295_c("accessLogRecords", 10)) {
            AccessLogRecord alr = AccessLogRecord.deserializeFromNBT((CompoundNBT)n);
            this.accessLogRecords.put(alr.getBackpackUuid(), alr);
        }
    }

    private void readBackpackContents(CompoundNBT nbt) {
        for (INBT n : nbt.func_150295_c("backpackContents", 10)) {
            CompoundNBT uuidContentsPair = (CompoundNBT)n;
            UUID uuid = NBTUtil.func_186860_b((INBT)Objects.requireNonNull(uuidContentsPair.func_74781_a("uuid")));
            CompoundNBT contents = uuidContentsPair.func_74775_l("contents");
            this.backpackContents.put(uuid, contents);
        }
    }

    public CompoundNBT func_189551_b(CompoundNBT compound) {
        CompoundNBT ret = new CompoundNBT();
        this.writeBackpackContents(ret);
        this.writeAccessLogs(ret);
        return ret;
    }

    private void writeBackpackContents(CompoundNBT ret) {
        ListNBT backpackContentsNbt = new ListNBT();
        for (Map.Entry<UUID, CompoundNBT> entry : this.backpackContents.entrySet()) {
            CompoundNBT uuidContentsPair = new CompoundNBT();
            uuidContentsPair.func_218657_a("uuid", (INBT)NBTUtil.func_240626_a_((UUID)entry.getKey()));
            uuidContentsPair.func_218657_a("contents", (INBT)entry.getValue());
            backpackContentsNbt.add((Object)uuidContentsPair);
        }
        ret.func_218657_a("backpackContents", (INBT)backpackContentsNbt);
    }

    private void writeAccessLogs(CompoundNBT ret) {
        ListNBT accessLogsNbt = new ListNBT();
        for (AccessLogRecord alr : this.accessLogRecords.values()) {
            accessLogsNbt.add((Object)alr.serializeToNBT());
        }
        ret.func_218657_a("accessLogRecords", (INBT)accessLogsNbt);
    }

    public CompoundNBT getOrCreateBackpackContents(UUID backpackUuid) {
        return this.backpackContents.computeIfAbsent(backpackUuid, uuid -> {
            this.func_76185_a();
            return new CompoundNBT();
        });
    }

    public void putAccessLog(AccessLogRecord alr) {
        this.accessLogRecords.put(alr.getBackpackUuid(), alr);
        this.func_76185_a();
    }

    public void removeBackpackContents(UUID backpackUuid) {
        this.backpackContents.remove(backpackUuid);
    }

    public void setBackpackContents(UUID backpackUuid, CompoundNBT contents) {
        if (!this.backpackContents.containsKey(backpackUuid)) {
            this.backpackContents.put(backpackUuid, contents);
            this.updatedBackpackSettingsFlags.add(backpackUuid);
        } else {
            CompoundNBT currentContents = this.backpackContents.get(backpackUuid);
            for (String key : contents.func_150296_c()) {
                currentContents.func_218657_a(key, contents.func_74781_a(key));
                if (!key.equals("settings")) continue;
                this.updatedBackpackSettingsFlags.add(backpackUuid);
            }
        }
    }

    public Map<UUID, AccessLogRecord> getAccessLogs() {
        return this.accessLogRecords;
    }

    public int removeNonPlayerBackpackContents(boolean onlyWithEmptyInventory) {
        AtomicInteger numberRemoved = new AtomicInteger(0);
        this.backpackContents.entrySet().removeIf(entry -> {
            if (!(this.accessLogRecords.containsKey(entry.getKey()) || onlyWithEmptyInventory && ((CompoundNBT)entry.getValue()).func_74764_b("inventory"))) {
                numberRemoved.incrementAndGet();
                return true;
            }
            return false;
        });
        if (numberRemoved.get() > 0) {
            this.func_76185_a();
        }
        return numberRemoved.get();
    }

    public boolean removeUpdatedBackpackSettingsFlag(UUID backpackUuid) {
        return this.updatedBackpackSettingsFlags.remove(backpackUuid);
    }
}

