/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.utility;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.DoubleNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector3i;

public class VecHelper {
    public static final Vector3f ZERO_3F = new Vector3f(0.0f, 0.0f, 0.0f);
    public static final Vector3d CENTER_OF_ORIGIN = new Vector3d(0.5, 0.5, 0.5);

    public static Vector3d rotate(Vector3d vec, Vector3d rotationVec) {
        return VecHelper.rotate(vec, rotationVec.field_72450_a, rotationVec.field_72448_b, rotationVec.field_72449_c);
    }

    public static Vector3d rotate(Vector3d vec, double xRot, double yRot, double zRot) {
        return VecHelper.rotate(VecHelper.rotate(VecHelper.rotate(vec, xRot, Direction.Axis.X), yRot, Direction.Axis.Y), zRot, Direction.Axis.Z);
    }

    public static Vector3d rotateCentered(Vector3d vec, double deg, Direction.Axis axis) {
        Vector3d shift = VecHelper.getCenterOf((Vector3i)BlockPos.field_177992_a);
        return VecHelper.rotate(vec.func_178788_d(shift), deg, axis).func_178787_e(shift);
    }

    public static Vector3d rotate(Vector3d vec, double deg, Direction.Axis axis) {
        if (deg == 0.0) {
            return vec;
        }
        if (vec == Vector3d.field_186680_a) {
            return vec;
        }
        float angle = (float)(deg / 180.0 * Math.PI);
        double sin = MathHelper.func_76126_a((float)angle);
        double cos = MathHelper.func_76134_b((float)angle);
        double x = vec.field_72450_a;
        double y = vec.field_72448_b;
        double z = vec.field_72449_c;
        if (axis == Direction.Axis.X) {
            return new Vector3d(x, y * cos - z * sin, z * cos + y * sin);
        }
        if (axis == Direction.Axis.Y) {
            return new Vector3d(x * cos + z * sin, y, z * cos - x * sin);
        }
        if (axis == Direction.Axis.Z) {
            return new Vector3d(x * cos - y * sin, y * cos + x * sin, z);
        }
        return vec;
    }

    public static Vector3d mirrorCentered(Vector3d vec, Mirror mirror) {
        Vector3d shift = VecHelper.getCenterOf((Vector3i)BlockPos.field_177992_a);
        return VecHelper.mirror(vec.func_178788_d(shift), mirror).func_178787_e(shift);
    }

    public static Vector3d mirror(Vector3d vec, Mirror mirror) {
        if (mirror == null || mirror == Mirror.NONE) {
            return vec;
        }
        if (vec == Vector3d.field_186680_a) {
            return vec;
        }
        double x = vec.field_72450_a;
        double y = vec.field_72448_b;
        double z = vec.field_72449_c;
        if (mirror == Mirror.LEFT_RIGHT) {
            return new Vector3d(x, y, -z);
        }
        if (mirror == Mirror.FRONT_BACK) {
            return new Vector3d(-x, y, z);
        }
        return vec;
    }

    public static Vector3d lookAt(Vector3d vec, Vector3d fwd) {
        Vector3d up;
        double dot = (fwd = fwd.func_72432_b()).func_72430_b(up = new Vector3d(0.0, 1.0, 0.0));
        if (Math.abs(dot) > 0.999) {
            up = new Vector3d(0.0, 0.0, dot > 0.0 ? 1.0 : -1.0);
        }
        Vector3d right = fwd.func_72431_c(up).func_72432_b();
        up = right.func_72431_c(fwd).func_72432_b();
        double x = vec.field_72450_a * right.field_72450_a + vec.field_72448_b * up.field_72450_a + vec.field_72449_c * fwd.field_72450_a;
        double y = vec.field_72450_a * right.field_72448_b + vec.field_72448_b * up.field_72448_b + vec.field_72449_c * fwd.field_72448_b;
        double z = vec.field_72450_a * right.field_72449_c + vec.field_72448_b * up.field_72449_c + vec.field_72449_c * fwd.field_72449_c;
        return new Vector3d(x, y, z);
    }

    public static boolean isVecPointingTowards(Vector3d vec, Direction direction) {
        return Vector3d.func_237491_b_((Vector3i)direction.func_176730_m()).func_72430_b(vec.func_72432_b()) > 0.125;
    }

    public static Vector3d getCenterOf(Vector3i pos) {
        if (pos.equals((Object)Vector3i.field_177959_e)) {
            return CENTER_OF_ORIGIN;
        }
        return Vector3d.func_237491_b_((Vector3i)pos).func_72441_c(0.5, 0.5, 0.5);
    }

    public static Vector3d offsetRandomly(Vector3d vec, Random r, float radius) {
        return new Vector3d(vec.field_72450_a + (double)((r.nextFloat() - 0.5f) * 2.0f * radius), vec.field_72448_b + (double)((r.nextFloat() - 0.5f) * 2.0f * radius), vec.field_72449_c + (double)((r.nextFloat() - 0.5f) * 2.0f * radius));
    }

    public static Vector3d axisAlingedPlaneOf(Vector3d vec) {
        vec = vec.func_72432_b();
        return new Vector3d(1.0, 1.0, 1.0).func_178786_a(Math.abs(vec.field_72450_a), Math.abs(vec.field_72448_b), Math.abs(vec.field_72449_c));
    }

    public static Vector3d axisAlingedPlaneOf(Direction face) {
        return VecHelper.axisAlingedPlaneOf(Vector3d.func_237491_b_((Vector3i)face.func_176730_m()));
    }

    public static ListNBT writeNBT(Vector3d vec) {
        ListNBT listnbt = new ListNBT();
        listnbt.add((Object)DoubleNBT.func_229684_a_((double)vec.field_72450_a));
        listnbt.add((Object)DoubleNBT.func_229684_a_((double)vec.field_72448_b));
        listnbt.add((Object)DoubleNBT.func_229684_a_((double)vec.field_72449_c));
        return listnbt;
    }

    public static Vector3d readNBT(ListNBT list) {
        if (list.isEmpty()) {
            return Vector3d.field_186680_a;
        }
        return new Vector3d(list.func_150309_d(0), list.func_150309_d(1), list.func_150309_d(2));
    }

    public static Vector3d voxelSpace(double x, double y, double z) {
        return new Vector3d(x, y, z).func_186678_a(0.0625);
    }

    public static int getCoordinate(Vector3i pos, Direction.Axis axis) {
        return axis.func_196052_a(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public static float getCoordinate(Vector3d vec, Direction.Axis axis) {
        return (float)axis.func_196051_a(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
    }

    public static boolean onSameAxis(BlockPos pos1, BlockPos pos2, Direction.Axis axis) {
        if (pos1.equals((Object)pos2)) {
            return true;
        }
        for (Direction.Axis otherAxis : Direction.Axis.values()) {
            if (axis == otherAxis || VecHelper.getCoordinate((Vector3i)pos1, otherAxis) == VecHelper.getCoordinate((Vector3i)pos2, otherAxis)) continue;
            return false;
        }
        return true;
    }

    public static Vector3d clamp(Vector3d vec, float maxLength) {
        return vec.func_72433_c() > (double)maxLength ? vec.func_72432_b().func_186678_a((double)maxLength) : vec;
    }

    public static Vector3d lerp(float p, Vector3d from, Vector3d to) {
        return from.func_178787_e(to.func_178788_d(from).func_186678_a((double)p));
    }

    public static Vector3d clampComponentWise(Vector3d vec, float maxLength) {
        return new Vector3d(MathHelper.func_151237_a((double)vec.field_72450_a, (double)(-maxLength), (double)maxLength), MathHelper.func_151237_a((double)vec.field_72448_b, (double)(-maxLength), (double)maxLength), MathHelper.func_151237_a((double)vec.field_72449_c, (double)(-maxLength), (double)maxLength));
    }

    public static Vector3d project(Vector3d vec, Vector3d ontoVec) {
        if (ontoVec.equals((Object)Vector3d.field_186680_a)) {
            return Vector3d.field_186680_a;
        }
        return ontoVec.func_186678_a(vec.func_72430_b(ontoVec) / ontoVec.func_189985_c());
    }

    @Nullable
    public static Vector3d intersectSphere(Vector3d origin, Vector3d lineDirection, Vector3d sphereCenter, double radius) {
        Vector3d diff;
        double lineDotDiff;
        double delta;
        if (lineDirection.equals((Object)Vector3d.field_186680_a)) {
            return null;
        }
        if (lineDirection.func_72433_c() != 1.0) {
            lineDirection = lineDirection.func_72432_b();
        }
        if ((delta = (lineDotDiff = lineDirection.func_72430_b(diff = origin.func_178788_d(sphereCenter))) * lineDotDiff - (diff.func_189985_c() - radius * radius)) < 0.0) {
            return null;
        }
        double t = -lineDotDiff + (double)MathHelper.func_76133_a((double)delta);
        return origin.func_178787_e(lineDirection.func_186678_a(t));
    }

    public static Vector3d projectToPlayerView(Vector3d target, float partialTicks) {
        Entity renderViewEntity;
        ActiveRenderInfo ari = Minecraft.func_71410_x().field_71460_t.func_215316_n();
        Vector3d camera_pos = ari.func_216785_c();
        Quaternion camera_rotation_conj = ari.func_227995_f_().func_227068_g_();
        camera_rotation_conj.func_195892_e();
        Vector3f result3f = new Vector3f((float)(camera_pos.field_72450_a - target.field_72450_a), (float)(camera_pos.field_72448_b - target.field_72448_b), (float)(camera_pos.field_72449_c - target.field_72449_c));
        result3f.func_214905_a(camera_rotation_conj);
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71474_y.field_74336_f && (renderViewEntity = mc.func_175606_aa()) instanceof PlayerEntity) {
            PlayerEntity playerentity = (PlayerEntity)renderViewEntity;
            float distwalked_modified = playerentity.field_70140_Q;
            float f = distwalked_modified - playerentity.field_70141_P;
            float f1 = -(distwalked_modified + f * partialTicks);
            float f2 = MathHelper.func_219799_g((float)partialTicks, (float)playerentity.field_71107_bF, (float)playerentity.field_71109_bG);
            Quaternion q2 = new Quaternion(Vector3f.field_229179_b_, Math.abs(MathHelper.func_76134_b((float)(f1 * (float)Math.PI - 0.2f)) * f2) * 5.0f, true);
            q2.func_195892_e();
            result3f.func_214905_a(q2);
            Quaternion q1 = new Quaternion(Vector3f.field_229183_f_, MathHelper.func_76126_a((float)(f1 * (float)Math.PI)) * f2 * 3.0f, true);
            q1.func_195892_e();
            result3f.func_214905_a(q1);
            Vector3f bob_translation = new Vector3f(MathHelper.func_76126_a((float)(f1 * (float)Math.PI)) * f2 * 0.5f, -Math.abs(MathHelper.func_76134_b((float)(f1 * (float)Math.PI)) * f2), 0.0f);
            bob_translation.setY(-bob_translation.func_195900_b());
            result3f.func_229189_a_(bob_translation);
        }
        float fov = (float)mc.field_71460_t.func_215311_a(ari, partialTicks, true);
        float half_height = (float)mc.func_228018_at_().func_198087_p() / 2.0f;
        float scale_factor = half_height / (result3f.func_195902_c() * (float)Math.tan(Math.toRadians(fov / 2.0f)));
        return new Vector3d((double)(-result3f.func_195899_a() * scale_factor), (double)(result3f.func_195900_b() * scale_factor), (double)result3f.func_195902_c());
    }
}

