/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder.content;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.content.contraptions.base.IRotate;
import com.simibubi.create.content.contraptions.particle.RotationIndicatorParticleData;
import com.simibubi.create.foundation.ponder.ElementLink;
import com.simibubi.create.foundation.ponder.PonderStoryBoardEntry;
import com.simibubi.create.foundation.ponder.SceneBuilder;
import com.simibubi.create.foundation.ponder.SceneBuildingUtil;
import com.simibubi.create.foundation.ponder.Selection;
import com.simibubi.create.foundation.ponder.content.PonderIndex;
import com.simibubi.create.foundation.ponder.content.PonderPalette;
import com.simibubi.create.foundation.ponder.content.PonderTag;
import com.simibubi.create.foundation.ponder.elements.BeltItemElement;
import com.simibubi.create.foundation.ponder.elements.InputWindowElement;
import com.simibubi.create.foundation.ponder.elements.ParrotElement;
import com.simibubi.create.foundation.ponder.elements.WorldSectionElement;
import com.simibubi.create.foundation.ponder.instructions.EmitParticlesInstruction;
import com.simibubi.create.foundation.utility.Pointing;
import com.simibubi.create.repack.registrate.util.entry.ItemEntry;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;

public class DebugScenes {
    private static int index;

    public static void registerAll() {
        index = 1;
        DebugScenes.add(DebugScenes::coordinateScene);
        DebugScenes.add(DebugScenes::blocksScene);
        DebugScenes.add(DebugScenes::fluidsScene);
        DebugScenes.add(DebugScenes::offScreenScene);
        DebugScenes.add(DebugScenes::particleScene);
        DebugScenes.add(DebugScenes::controlsScene);
        DebugScenes.add(DebugScenes::birbScene);
        DebugScenes.add(DebugScenes::sectionsScene);
        DebugScenes.add(DebugScenes::itemScene);
        DebugScenes.add(DebugScenes::pipeScene);
    }

    private static void add(PonderStoryBoardEntry.PonderStoryBoard sb) {
        ItemEntry<Item> item = AllItems.BRASS_HAND;
        String schematicPath = "debug/scene_" + index;
        PonderIndex.HELPER.addStoryBoard(item, schematicPath, sb, new PonderTag[0]).highlightAllTags().chapter(PonderIndex.HELPER.getOrCreateChapter("debug"));
        ++index;
    }

    public static void empty(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("debug_empty", "Missing Content");
        scene.showBasePlate();
        scene.idle(5);
    }

    public static void coordinateScene(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("debug_coords", "Coordinate Space");
        scene.showBasePlate();
        scene.idle(10);
        scene.world.showSection(util.select.layersFrom(1), Direction.DOWN);
        Selection xAxis = util.select.fromTo(2, 1, 1, 4, 1, 1);
        Selection yAxis = util.select.fromTo(1, 2, 1, 1, 4, 1);
        Selection zAxis = util.select.fromTo(1, 1, 2, 1, 1, 4);
        scene.idle(10);
        scene.overlay.showSelectionWithText(xAxis, 20).colored(PonderPalette.RED).text("Das X axis");
        scene.idle(20);
        scene.overlay.showSelectionWithText(yAxis, 20).colored(PonderPalette.GREEN).text("Das Y axis");
        scene.idle(20);
        scene.overlay.showSelectionWithText(zAxis, 20).colored(PonderPalette.BLUE).text("Das Z axis");
    }

    public static void blocksScene(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("debug_blocks", "Changing Blocks");
        scene.showBasePlate();
        scene.idle(10);
        scene.world.showSection(util.select.layersFrom(1), Direction.DOWN);
        scene.idle(10);
        scene.overlay.showText(1000).independent(10).text("Blocks can be modified");
        scene.idle(20);
        scene.world.replaceBlocks(util.select.fromTo(1, 1, 3, 2, 2, 4), AllBlocks.REFINED_RADIANCE_CASING.getDefaultState(), true);
        scene.idle(10);
        scene.world.replaceBlocks(util.select.position(3, 1, 1), Blocks.field_150340_R.func_176223_P(), true);
        scene.rotateCameraY(180.0f);
        scene.markAsFinished();
    }

    public static void fluidsScene(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("debug_fluids", "Showing Fluids");
        scene.showBasePlate();
        scene.idle(10);
        Vector3d parrotPos = util.vector.topOf(1, 0, 1);
        scene.special.createBirb(parrotPos, ParrotElement.FacePointOfInterestPose::new);
        scene.world.showSection(util.select.layersFrom(1), Direction.DOWN);
        scene.overlay.showText(1000).text("Fluid rendering test.").pointAt(new Vector3d(1.0, 2.5, 4.5));
        scene.markAsFinished();
        Object outlineSlot = new Object();
        Vector3d vec1 = util.vector.topOf(1, 0, 0);
        Vector3d vec2 = util.vector.topOf(0, 0, 1);
        AxisAlignedBB boundingBox1 = new AxisAlignedBB(vec1, vec1).func_72321_a(0.0, 2.5, 0.0).func_72314_b(0.15, 0.0, 0.15);
        AxisAlignedBB boundingBox2 = new AxisAlignedBB(vec2, vec2).func_72321_a(0.0, 0.125, 0.0).func_72314_b(0.45, 0.0, 0.45);
        Vector3d poi1 = boundingBox1.func_189972_c();
        Vector3d poi2 = boundingBox2.func_189972_c();
        for (int i = 0; i < 10; ++i) {
            scene.overlay.chaseBoundingBoxOutline(PonderPalette.RED, outlineSlot, i % 2 == 0 ? boundingBox1 : boundingBox2, 15);
            scene.idle(3);
            scene.special.movePointOfInterest(i % 2 == 0 ? poi1 : poi2);
            scene.idle(12);
        }
        scene.idle(12);
        scene.special.movePointOfInterest(util.grid.at(-4, 5, 4));
        scene.overlay.showText(40).colored(PonderPalette.RED).text("wut?").pointAt(parrotPos.func_72441_c(-0.25, 0.25, 0.25));
    }

    public static void offScreenScene(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("debug_baseplate", "Out of bounds / configureBasePlate");
        scene.configureBasePlate(1, 0, 6);
        scene.showBasePlate();
        Selection out1 = util.select.fromTo(7, 0, 0, 8, 0, 5);
        Selection out2 = util.select.fromTo(0, 0, 0, 0, 0, 5);
        Selection blocksExceptBasePlate = util.select.layersFrom(1).add(out1).add(out2);
        scene.idle(10);
        scene.world.showSection(blocksExceptBasePlate, Direction.DOWN);
        scene.idle(10);
        scene.overlay.showSelectionWithText(out1, 100).colored(PonderPalette.BLACK).text("Blocks outside of the base plate do not affect scaling");
        scene.overlay.showSelectionWithText(out2, 100).colored(PonderPalette.BLACK).text("configureBasePlate() makes sure of that.");
        scene.markAsFinished();
    }

    public static void particleScene(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("debug_particles", "Emitting particles");
        scene.showBasePlate();
        scene.idle(10);
        scene.world.showSection(util.select.layersFrom(1), Direction.DOWN);
        scene.idle(10);
        Vector3d emitterPos = util.vector.of(2.5, 2.25, 2.5);
        EmitParticlesInstruction.Emitter emitter = EmitParticlesInstruction.Emitter.simple(ParticleTypes.field_197595_F, util.vector.of(0.0, 0.1, 0.0));
        EmitParticlesInstruction.Emitter rotation = EmitParticlesInstruction.Emitter.simple(new RotationIndicatorParticleData(IRotate.SpeedLevel.MEDIUM.getColor(), 12.0f, 1.0f, 1.0f, 20, 'Y'), util.vector.of(0.0, 0.1, 0.0));
        scene.overlay.showText(20).text("Incoming...").pointAt(emitterPos);
        scene.idle(30);
        scene.effects.emitParticles(emitterPos, emitter, 1.0f, 60);
        scene.effects.emitParticles(emitterPos, rotation, 20.0f, 1);
        scene.idle(30);
        scene.rotateCameraY(180.0f);
    }

    public static void controlsScene(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("debug_controls", "Basic player interaction");
        scene.showBasePlate();
        scene.idle(10);
        scene.world.showSection(util.select.layer(1), Direction.DOWN);
        scene.idle(4);
        scene.world.showSection(util.select.layer(2), Direction.DOWN);
        scene.idle(4);
        scene.world.showSection(util.select.layer(3), Direction.DOWN);
        scene.idle(10);
        BlockPos shaftPos = util.grid.at(3, 1, 1);
        Selection shaftSelection = util.select.position(shaftPos);
        scene.overlay.showControls(new InputWindowElement(util.vector.topOf(shaftPos), Pointing.DOWN).rightClick().whileSneaking().withWrench(), 40);
        scene.idle(20);
        scene.world.replaceBlocks(shaftSelection, AllBlocks.SHAFT.getDefaultState(), true);
        scene.idle(20);
        scene.world.hideSection(shaftSelection, Direction.UP);
        scene.idle(20);
        scene.overlay.showControls(new InputWindowElement(util.vector.of(1.0, 4.5, 3.5), Pointing.LEFT).rightClick().withItem(new ItemStack((IItemProvider)Blocks.field_196657_h)), 20);
        scene.world.showSection(util.select.layer(4), Direction.DOWN);
        scene.idle(40);
        BlockPos chassis = util.grid.at(1, 1, 3);
        Vector3d chassisSurface = util.vector.blockSurface(chassis, Direction.NORTH);
        Object chassisValueBoxHighlight = new Object();
        Object chassisEffectHighlight = new Object();
        AxisAlignedBB point = new AxisAlignedBB(chassisSurface, chassisSurface);
        AxisAlignedBB expanded = point.func_72314_b(0.25, 0.25, 0.0625);
        Selection singleBlock = util.select.position(1, 2, 3);
        Selection twoBlocks = util.select.fromTo(1, 2, 3, 1, 3, 3);
        Selection threeBlocks = util.select.fromTo(1, 2, 3, 1, 4, 3);
        Selection singleRow = util.select.fromTo(1, 2, 3, 3, 2, 3);
        Selection twoRows = util.select.fromTo(1, 2, 3, 3, 3, 3);
        Selection threeRows = twoRows.copy().add(threeBlocks);
        scene.overlay.chaseBoundingBoxOutline(PonderPalette.GREEN, chassisValueBoxHighlight, point, 1);
        scene.idle(1);
        scene.overlay.chaseBoundingBoxOutline(PonderPalette.GREEN, chassisValueBoxHighlight, expanded, 120);
        scene.overlay.showControls(new InputWindowElement(chassisSurface, Pointing.UP).scroll().withWrench(), 40);
        PonderPalette white = PonderPalette.WHITE;
        scene.overlay.showOutline(white, chassisEffectHighlight, singleBlock, 10);
        scene.idle(10);
        scene.overlay.showOutline(white, chassisEffectHighlight, twoBlocks, 10);
        scene.idle(10);
        scene.overlay.showOutline(white, chassisEffectHighlight, threeBlocks, 10);
        scene.idle(10);
        scene.overlay.showOutline(white, chassisEffectHighlight, twoBlocks, 10);
        scene.idle(10);
        scene.overlay.showOutline(white, chassisEffectHighlight, singleBlock, 10);
        scene.idle(10);
        scene.idle(30);
        scene.overlay.showControls(new InputWindowElement(chassisSurface, Pointing.UP).whileCTRL().scroll().withWrench(), 40);
        scene.overlay.showOutline(white, chassisEffectHighlight, singleRow, 10);
        scene.idle(10);
        scene.overlay.showOutline(white, chassisEffectHighlight, twoRows, 10);
        scene.idle(10);
        scene.overlay.showOutline(white, chassisEffectHighlight, threeRows, 10);
        scene.idle(10);
        scene.overlay.showOutline(white, chassisEffectHighlight, twoRows, 10);
        scene.idle(10);
        scene.overlay.showOutline(white, chassisEffectHighlight, singleRow, 10);
        scene.idle(10);
        scene.markAsFinished();
    }

    public static void birbScene(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("debug_birbs", "Birbs");
        scene.showBasePlate();
        scene.idle(10);
        scene.world.showSection(util.select.layersFrom(1), Direction.DOWN);
        scene.idle(10);
        BlockPos pos = new BlockPos(1, 2, 3);
        scene.special.birbOnSpinnyShaft(pos);
        scene.overlay.showText(100).colored(PonderPalette.GREEN).text("More birbs = More interesting").pointAt(util.vector.topOf(pos));
        scene.idle(10);
        scene.special.createBirb(util.vector.topOf(0, 1, 2), ParrotElement.DancePose::new);
        scene.idle(10);
        scene.special.createBirb(util.vector.centerOf(3, 1, 3).func_72441_c(0.0, 0.25, 0.0), ParrotElement.FacePointOfInterestPose::new);
        scene.idle(20);
        BlockPos poi1 = util.grid.at(4, 1, 0);
        BlockPos poi2 = util.grid.at(0, 1, 4);
        scene.world.setBlock(poi1, Blocks.field_150340_R.func_176223_P(), true);
        scene.special.movePointOfInterest(poi1);
        scene.idle(20);
        scene.world.setBlock(poi2, Blocks.field_150340_R.func_176223_P(), true);
        scene.special.movePointOfInterest(poi2);
        scene.overlay.showText(20).text("Point of Interest").pointAt(util.vector.centerOf(poi2));
        scene.idle(20);
        scene.world.destroyBlock(poi1);
        scene.special.movePointOfInterest(poi1);
        scene.idle(20);
        scene.world.destroyBlock(poi2);
        scene.special.movePointOfInterest(poi2);
    }

    public static void sectionsScene(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("debug_sections", "Sections");
        scene.showBasePlate();
        scene.idle(10);
        scene.rotateCameraY(95.0f);
        BlockPos mergePos = util.grid.at(1, 1, 1);
        BlockPos independentPos = util.grid.at(3, 1, 1);
        Selection toMerge = util.select.position(mergePos);
        Selection independent = util.select.position(independentPos);
        Selection start = util.select.layersFrom(1).substract(toMerge).substract(independent);
        scene.world.showSection(start, Direction.DOWN);
        scene.idle(20);
        scene.world.showSection(toMerge, Direction.DOWN);
        ElementLink<WorldSectionElement> link = scene.world.showIndependentSection(independent, Direction.DOWN);
        scene.idle(20);
        scene.overlay.showText(40).colored(PonderPalette.GREEN).text("This Section got merged to base.").pointAt(util.vector.topOf(mergePos));
        scene.idle(10);
        scene.overlay.showText(40).colored(PonderPalette.RED).text("This Section renders independently.").pointAt(util.vector.topOf(independentPos));
        scene.idle(40);
        scene.world.hideIndependentSection(link, Direction.DOWN);
        scene.world.hideSection(util.select.fromTo(mergePos, util.grid.at(1, 1, 4)), Direction.DOWN);
        scene.idle(20);
        Selection hiddenReplaceArea = util.select.fromTo(2, 1, 2, 4, 1, 4).substract(util.select.position(4, 1, 3)).substract(util.select.position(2, 1, 3));
        scene.world.hideSection(hiddenReplaceArea, Direction.UP);
        scene.idle(20);
        scene.world.setBlocks(hiddenReplaceArea, AllBlocks.REFINED_RADIANCE_CASING.getDefaultState(), false);
        scene.world.showSection(hiddenReplaceArea, Direction.DOWN);
        scene.idle(20);
        scene.overlay.showSelectionWithText(hiddenReplaceArea, 30).colored(PonderPalette.BLUE).text("Seamless substitution of blocks");
        scene.idle(40);
        ElementLink<WorldSectionElement> helicopter = scene.world.makeSectionIndependent(hiddenReplaceArea);
        scene.world.rotateSection(helicopter, 50.0, 1800.0, 0.0, 60);
        scene.world.moveSection(helicopter, util.vector.of(0.0, 4.0, 5.0), 50);
        scene.overlay.showText(30).colored(PonderPalette.BLUE).text("Up, up and away.").independent(30);
        scene.idle(40);
        scene.world.hideIndependentSection(helicopter, Direction.UP);
    }

    public static void itemScene(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("debug_items", "Manipulating Items");
        scene.configureBasePlate(0, 0, 6);
        scene.world.showSection(util.select.layer(0), Direction.UP);
        scene.idle(10);
        scene.world.showSection(util.select.layersFrom(1), Direction.DOWN);
        ItemStack brassItem = AllItems.BRASS_INGOT.asStack();
        ItemStack copperItem = AllItems.COPPER_INGOT.asStack();
        for (int z = 4; z >= 2; --z) {
            scene.world.createItemEntity(util.vector.centerOf(0, 4, z), Vector3d.field_186680_a, brassItem.func_77946_l());
            scene.idle(10);
        }
        BlockPos beltPos = util.grid.at(2, 1, 3);
        ElementLink<BeltItemElement> itemOnBelt = scene.world.createItemOnBelt(beltPos, Direction.EAST, copperItem.func_77946_l());
        scene.idle(10);
        scene.world.stallBeltItem(itemOnBelt, true);
        scene.idle(5);
        scene.overlay.showText(40).colored(PonderPalette.FAST).text("Belt Items can only be force-stalled on the belt they were created on.").pointAt(util.vector.topOf(2, 1, 2));
        scene.idle(45);
        scene.world.stallBeltItem(itemOnBelt, false);
        scene.idle(20);
        scene.world.modifyEntities(ItemEntity.class, entity -> {
            if (copperItem.func_77969_a(entity.func_92059_d())) {
                entity.func_189654_d(true);
            }
        });
        scene.idle(20);
        scene.world.modifyEntities(ItemEntity.class, entity -> {
            if (brassItem.func_77969_a(entity.func_92059_d())) {
                entity.func_213317_d(util.vector.of(-0.15f, 0.5, 0.0));
            }
        });
        scene.idle(27);
        scene.world.modifyEntities(ItemEntity.class, Entity::func_70106_y);
    }

    public static void pipeScene(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("debug_pipes", "Manipulating Items");
        scene.configureBasePlate(0, 0, 5);
        scene.world.showSection(util.select.layer(0), Direction.UP);
        scene.idle(10);
        scene.world.showSection(util.select.layersFrom(1), Direction.DOWN);
    }
}

